/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.web.controller.api;

import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.quality.console.facade.PluginInstCheckstyleRptService;
import com.irdstudio.allinapaas.quality.console.facade.PluginInstCoverageRptService;
import com.irdstudio.allinapaas.quality.console.facade.PluginInstFindbugsModuleService;
import com.irdstudio.allinapaas.quality.console.facade.dto.PluginInstCheckstyleRptDTO;
import com.irdstudio.allinapaas.quality.console.facade.dto.PluginInstCoverageRptDTO;
import com.irdstudio.allinapaas.quality.console.facade.dto.PluginInstFindbugsModuleDTO;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.Base64;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/"})
public class PaasCbaReportShowController
extends AbstractController {
    @Autowired
    private PluginInstCheckstyleRptService pluginInstCheckstyleRptService;
    @Autowired
    private PluginInstFindbugsModuleService pluginInstFindbugsModuleService;
    @Autowired
    private PluginInstCoverageRptService pluginInstCoverageRptService;
    @Value(value="${server.servlet.contextPath}")
    private String contextPath;

    @RequestMapping(value={"/code/report/{reportId}/**"}, method={RequestMethod.GET})
    public void fetchReportFile(@PathVariable(value="reportId") String reportId, HttpServletRequest request, HttpServletResponse response) throws IOException {
        File reportRootDir = new File(SdEnvUtil.PROJECT_PATH, reportId);
        if (reportRootDir.exists()) {
            String path = request.getServletPath();
            File file = new File(reportRootDir, path.substring(path.indexOf(reportId) + reportId.length()));
            try (FileInputStream input = new FileInputStream(file);){
                byte[] ctx = IOUtils.readFully((InputStream)input, (int)input.available());
                IOUtils.write((byte[])ctx, (OutputStream)response.getOutputStream());
            }
            response.setHeader("Content-Type", Files.probeContentType(file.toPath()));
        }
    }

    @RequestMapping(value={"/api/paas/cba/report/html/view"}, method={RequestMethod.GET})
    public void fetchReport(@RequestParam(value="reportId") String reportId, @RequestParam(value="cbaCode") String cbaCode, @RequestParam(value="appId") String appId, HttpServletResponse response) throws IOException {
        if (StringUtils.equals((CharSequence)cbaCode, (CharSequence)"paas-test-checkstyle")) {
            PluginInstCheckstyleRptDTO reportInfo = new PluginInstCheckstyleRptDTO();
            reportInfo.setReportId(reportId);
            reportInfo = (PluginInstCheckstyleRptDTO)this.pluginInstCheckstyleRptService.queryByPk((Object)reportInfo);
            if (reportInfo != null) {
                File reportRootDir = new File(SdEnvUtil.PROJECT_PATH, reportId);
                this.unzipRptData(reportId, reportInfo.getRptData(), reportRootDir);
                response.sendRedirect(String.format("%s/code/report/%s/%s", this.contextPath, reportId, reportInfo.getNowFileRte()));
            }
        } else if (StringUtils.equals((CharSequence)cbaCode, (CharSequence)"paas-test-findbugs")) {
            PluginInstFindbugsModuleDTO moduleReport = new PluginInstFindbugsModuleDTO();
            moduleReport.setId(reportId);
            moduleReport = (PluginInstFindbugsModuleDTO)this.pluginInstFindbugsModuleService.queryByPk((Object)moduleReport);
            if (moduleReport != null) {
                File reportRootDir = new File(SdEnvUtil.PROJECT_PATH, reportId);
                this.unzipRptData(reportId, moduleReport.getRptData(), reportRootDir);
                response.sendRedirect(String.format("%s/code/report/%s/%s", this.contextPath, reportId, moduleReport.getNowFileRte()));
            }
        } else if (StringUtils.equals((CharSequence)cbaCode, (CharSequence)"paas-test-unit")) {
            PluginInstCoverageRptDTO covReport = new PluginInstCoverageRptDTO();
            covReport.setReportId(reportId);
            covReport = (PluginInstCoverageRptDTO)this.pluginInstCoverageRptService.queryByPk((Object)covReport);
            if (covReport != null) {
                File reportRootDir = new File(SdEnvUtil.PROJECT_PATH, reportId);
                this.unzipRptData(reportId, covReport.getRptData(), reportRootDir);
                response.sendRedirect(String.format("%s/code/report/%s/%s", this.contextPath, reportId, covReport.getNowFileRte()));
            }
        }
    }

    private boolean unzipRptData(String reportId, String rptData, File reportRootDir) {
        if (!reportRootDir.exists()) {
            reportRootDir.mkdirs();
        }
        byte[] reportDataBase64 = Base64.getDecoder().decode(rptData);
        ByteArrayInputStream reportInput = new ByteArrayInputStream(reportDataBase64);
        BufferedOutputStream bos = null;
        try (ZipInputStream zis = new ZipInputStream(reportInput);){
            ZipEntry entry = null;
            while ((entry = zis.getNextEntry()) != null) {
                String path = reportRootDir.getAbsolutePath() + File.separator + entry.getName();
                File unzipFile = new File(path);
                if (entry.isDirectory()) {
                    if (unzipFile.isDirectory()) continue;
                    unzipFile.mkdirs();
                    continue;
                }
                if (!unzipFile.getParentFile().exists()) {
                    unzipFile.getParentFile().mkdirs();
                }
                bos = new BufferedOutputStream(new FileOutputStream(path));
                int read = 0;
                byte[] buffer = new byte[10240];
                while ((read = zis.read(buffer, 0, buffer.length)) != -1) {
                    bos.write(buffer, 0, read);
                }
                bos.flush();
                zis.closeEntry();
            }
        }
        catch (IOException e) {
            logger.error("\u89e3\u538b\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly(bos);
            IOUtils.closeQuietly((InputStream)reportInput);
        }
        return true;
    }
}

