/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.web.controller.api;

import com.irdstudio.allinapaas.portal.console.facade.PaasTaskInfoService;
import com.irdstudio.allinapaas.portal.console.facade.dto.PaasTaskInfoDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class PaasTaskInfoController
extends BaseController<PaasTaskInfoDTO, PaasTaskInfoService> {
    @RequestMapping(value={"/api/paas/task/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasTaskInfoDTO>> queryPaasTaskInfoAll(PaasTaskInfoDTO dto) {
        if (StringUtils.contains((CharSequence)dto.getTaskCategory(), (CharSequence)",")) {
            String[] catagorys = StringUtils.split((String)dto.getTaskCategory(), (String)",");
            dto.setTaskCategoryList(Arrays.asList(catagorys));
            dto.setTaskCategory(null);
        }
        List outputVo = ((PaasTaskInfoService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/task/info/{taskId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<PaasTaskInfoDTO> queryByPk(@PathVariable(value="taskId") String taskId) {
        PaasTaskInfoDTO inVo = new PaasTaskInfoDTO();
        inVo.setTaskId(taskId);
        PaasTaskInfoDTO outputVo = (PaasTaskInfoDTO)((PaasTaskInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/task/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody PaasTaskInfoDTO inPaasTaskInfoDTO) {
        int outputVo = ((PaasTaskInfoService)this.getService()).deleteByPk((Object)inPaasTaskInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/task/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody PaasTaskInfoDTO inPaasTaskInfoDTO) {
        this.setUserInfoToVO(inPaasTaskInfoDTO);
        inPaasTaskInfoDTO.setLastUpdateUser(inPaasTaskInfoDTO.getLoginUserId());
        inPaasTaskInfoDTO.setLastUpdateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((PaasTaskInfoService)this.getService()).updateByPk((Object)inPaasTaskInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/task/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> insertPaasTaskInfo(@RequestBody PaasTaskInfoDTO inPaasTaskInfoDTO) {
        int outputVo;
        this.setUserInfoToVO(inPaasTaskInfoDTO);
        inPaasTaskInfoDTO.setCreateUser(inPaasTaskInfoDTO.getLoginUserId());
        inPaasTaskInfoDTO.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        inPaasTaskInfoDTO.setLastUpdateUser(inPaasTaskInfoDTO.getLoginUserId());
        inPaasTaskInfoDTO.setLastUpdateTime(inPaasTaskInfoDTO.getCreateTime());
        if (StringUtils.isBlank((CharSequence)inPaasTaskInfoDTO.getTaskId())) {
            inPaasTaskInfoDTO.setTaskId(UUIDUtil.getShortUUID());
        } else {
            outputVo = ((PaasTaskInfoService)this.getService()).updateByPk((Object)inPaasTaskInfoDTO);
            if (outputVo == 1) {
                return this.getResponseData(inPaasTaskInfoDTO.getTaskId());
            }
        }
        outputVo = ((PaasTaskInfoService)this.getService()).insert((Object)inPaasTaskInfoDTO);
        return this.getResponseData(inPaasTaskInfoDTO.getTaskId());
    }

    @RequestMapping(value={"/client/PaasTaskInfoService/executeTask"}, method={RequestMethod.POST})
    @ResponseBody
    Integer executeTask(@RequestParam(value="taskId") String taskId, @RequestParam(value="userId") String userId) {
        return ((PaasTaskInfoService)this.getService()).executeTask(taskId, userId);
    }
}

