/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.paas.dbo.web.controller.api;

import com.irdstudio.paas.dbo.facade.DataQualityProblemService;
import com.irdstudio.paas.dbo.facade.dto.DataQualityProblemDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class DataQualityProblemController
extends BaseController<DataQualityProblemDTO, DataQualityProblemService> {
    @Autowired
    @Qualifier(value="dataQualityProblemServiceImpl")
    private DataQualityProblemService dataQualityProblemService;

    @RequestMapping(value={"/api/data/quality/problems"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<DataQualityProblemDTO>> queryDataQualityProblemAll(DataQualityProblemDTO vo) {
        List outputVo = this.dataQualityProblemService.queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/data/quality/problem/{problemId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<DataQualityProblemDTO> queryByPk(@PathVariable(value="problemId") String problemId) {
        DataQualityProblemDTO inVo = new DataQualityProblemDTO();
        inVo.setProblemId(problemId);
        DataQualityProblemDTO outputVo = (DataQualityProblemDTO)this.dataQualityProblemService.queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/data/quality/problem"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody DataQualityProblemDTO inDataQualityProblemVo) {
        int outputVo = this.dataQualityProblemService.deleteByPk((Object)inDataQualityProblemVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/data/quality/problem"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody DataQualityProblemDTO inDataQualityProblemVo) {
        int outputVo = this.dataQualityProblemService.updateByPk((Object)inDataQualityProblemVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/data/quality/problem"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertDataQualityProblem(@RequestBody DataQualityProblemDTO inDataQualityProblemVo) {
        inDataQualityProblemVo.setProblemId(UUIDUtil.getShortUUID());
        inDataQualityProblemVo.setCreateUser(inDataQualityProblemVo.getLoginUserId());
        inDataQualityProblemVo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = this.dataQualityProblemService.insert((Object)inDataQualityProblemVo);
        return this.getResponseData(outputVo);
    }
}

