/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.deliver.console.application.service.impl;

import com.irdstudio.allinflow.deliver.console.acl.repository.FlowConfMasterRepository;
import com.irdstudio.allinflow.deliver.console.domain.entity.FlowConfMasterDO;
import com.irdstudio.allinflow.deliver.console.facade.FlowConfMasterService;
import com.irdstudio.allinflow.deliver.console.facade.dto.FlowConfMasterDTO;
import com.irdstudio.allinflow.deliver.console.facade.dto.FlowInstMasterDTO;
import com.irdstudio.framework.beans.core.audit.AuditOperate;
import com.irdstudio.framework.beans.core.base.BaseServiceImpl;
import com.irdstudio.framework.beans.core.vo.BaseInfo;
import com.irdstudio.framework.beans.core.vo.ResponseData;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Strings;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.stereotype.Service;

@Service(value="flowConfMasterServiceImpl")
public class FlowConfMasterServiceImpl
extends BaseServiceImpl<FlowConfMasterDTO, FlowConfMasterDO, FlowConfMasterRepository>
implements FlowConfMasterService {
    public List<FlowConfMasterDTO> queryAppsBatchByPage(FlowConfMasterDTO flowConfMaster) {
        FlowConfMasterDO param = (FlowConfMasterDO)this.beanCopy(flowConfMaster, FlowConfMasterDO.class);
        List list = ((FlowConfMasterRepository)this.getRepository()).queryAppsBatchByPage(param);
        return this.beansCopy(list, FlowConfMasterDTO.class);
    }

    public List<FlowConfMasterDTO> queryTemplateBatchByPage(FlowConfMasterDTO flowConfMaster) {
        FlowConfMasterDO param = (FlowConfMasterDO)this.beanCopy(flowConfMaster, FlowConfMasterDO.class);
        List list = ((FlowConfMasterRepository)this.getRepository()).queryTemplateBatchByPage(param);
        return this.beansCopy(list, FlowConfMasterDTO.class);
    }

    public ResponseData<String> startBatchForClient(FlowInstMasterDTO param) {
        throw new UnsupportedOperationException("startBatchForClient \u4e0d\u5e94\u6267\u884c\u5230\u8fd9\u91cc");
    }

    public FlowInstMasterDTO execPluginWithoutRunBatchInst(FlowInstMasterDTO param) {
        return null;
    }

    @AuditOperate(action=AuditOperate.Action.Add, auditType="B", bizKey="${args[0].batchId}", bizName="${args[0].batchName}", text="${dynamicLog.action().getName()}\u4e86 #${args[0].batchId} ${args[0].batchName}")
    public int insert(FlowConfMasterDTO paramDTO) {
        return super.insert((BaseInfo)paramDTO);
    }

    @AuditOperate(action=AuditOperate.Action.Update, auditType="B", bizKey="${args[0].batchId}", bizName="${args[0].batchName}")
    public int updateByPk(FlowConfMasterDTO paramDTO) {
        FlowConfMasterDTO oldData = (FlowConfMasterDTO)this.queryByPk((BaseInfo)paramDTO);
        paramDTO.setOldData((Object)oldData);
        return super.updateByPk((BaseInfo)paramDTO);
    }

    @AuditOperate(action=AuditOperate.Action.Delete, auditType="B", bizKey="${args[0].batchId}", bizName="${args[0].batchName}", text="${dynamicLog.action().getName()}\u4e86 #${args[0].batchId} ${args[0].batchName}")
    public int deleteByPk(FlowConfMasterDTO paramDTO) {
        return super.deleteByPk((BaseInfo)paramDTO);
    }

    public int excelImport(String excelUploadType, FlowConfMasterDTO uploadParams, List<FlowConfMasterDTO> list) {
        List deleteList;
        if (StringUtils.equals((CharSequence)excelUploadType, (CharSequence)"insert") && CollectionUtils.isNotEmpty((Collection)(deleteList = ((FlowConfMasterRepository)this.getRepository()).queryList(this.beanCopy(uploadParams, FlowConfMasterDO.class))))) {
            deleteList.forEach(del -> ((FlowConfMasterRepository)this.getRepository()).deleteByPk(del));
        }
        return this.batchInsert(list);
    }

    public void exportToExcel(String flowId, HttpServletResponse response) throws Exception {
        FlowConfMasterDTO dto = new FlowConfMasterDTO();
        dto.setBatchId(flowId);
        dto = (FlowConfMasterDTO)this.queryByPk((BaseInfo)dto);
        if (Strings.isBlank((String)dto.getBatchId())) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u6d41\u7a0bID: " + flowId);
        }
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        String fileName = URLEncoder.encode(dto.getBatchName() + "_\u6d41\u7a0b\u914d\u7f6e\u4fe1\u606f.xlsx", "UTF-8");
        fileName = fileName.replaceAll("\\+", "%20");
        response.setHeader("Content-Disposition", "attachment; filename*=UTF-8''" + fileName);
        XSSFWorkbook workbook = new XSSFWorkbook();
        Sheet sheet = workbook.createSheet(dto.getBatchName() + "\u914d\u7f6e\u8be6\u60c5");
        Row headerRow = sheet.createRow(0);
        String[] headers = new String[]{"\u6d41\u7a0b\u6807\u8bc6", "\u6d41\u7a0b\u540d\u79f0", "\u5e94\u7528\u7cfb\u7edf\u7b80\u79f0", "\u53d1\u8d77\u65b9\u5f0f", "\u5b9a\u65f6\u5468\u671f", "\u751f\u6548\u65e5\u671f", "\u4efb\u52a1\u5e76\u53d1\u6570", "\u5907\u6ce8", "\u662f\u5426\u5141\u8bb8\u91cd\u8dd1", "\u4ee3\u7406\u6807\u8bc6", "\u6d41\u6c34\u7ebf\u7c7b\u578b", "\u6d41\u7a0b\u63cf\u8ff0\u4fe1\u606f\u6a21\u677f", "\u5e94\u7528\u7cfb\u7edf\u7f16\u53f7", "\u5e94\u7528\u7f16\u53f7", "\u73af\u5883\u6807\u8bc6", "Paas\u7ec4\u4ef6\u4ee3\u7801", "\u670d\u52a1\u5668\u6807\u8bc6", "\u6d41\u7a0b\u7ba1\u7406\u6807\u8bc6", "\u6d41\u7a0b\u6267\u884c\u5411\u5bfc\u5f0f\u9875", "\u521b\u5efa\u7528\u6237", "\u521b\u5efa\u65f6\u95f4", "\u6700\u8fd1\u4fee\u6539\u7528\u6237", "\u6700\u8fd1\u4fee\u6539\u65f6\u95f4", "\u6d41\u7a0b\u72b6\u6001", "\u6d41\u7a0b\u6765\u6e90", "\u7248\u672c\u53f7"};
        CellStyle headerStyle = workbook.createCellStyle();
        Font headerFont = workbook.createFont();
        headerFont.setBold(true);
        headerStyle.setFont(headerFont);
        for (int i = 0; i < headers.length; ++i) {
            Cell cell = headerRow.createCell(i);
            cell.setCellValue(headers[i]);
            cell.setCellStyle(headerStyle);
            sheet.setColumnWidth(i, 5120);
        }
        Row dataRow = sheet.createRow(1);
        dataRow.createCell(0).setCellValue(dto.getBatchId());
        dataRow.createCell(1).setCellValue(dto.getBatchName());
        dataRow.createCell(2).setCellValue(dto.getSubsName());
        dataRow.createCell(3).setCellValue(dto.getLaunchType());
        dataRow.createCell(4).setCellValue(dto.getBatchCronValue());
        dataRow.createCell(5).setCellValue(dto.getValidDate());
        dataRow.createCell(6).setCellValue((double)dto.getEquallyTaskAmount().intValue());
        dataRow.createCell(7).setCellValue(dto.getRemark());
        dataRow.createCell(8).setCellValue(dto.getIsRunAgain() != null ? ("1".equals(dto.getIsRunAgain()) ? "\u662f" : "\u5426") : "");
        dataRow.createCell(9).setCellValue(dto.getAgentId());
        dataRow.createCell(10).setCellValue(dto.getAlType());
        dataRow.createCell(11).setCellValue(dto.getAlDescTemplate());
        dataRow.createCell(12).setCellValue(dto.getSubsId());
        dataRow.createCell(13).setCellValue(dto.getAppId());
        dataRow.createCell(14).setCellValue(dto.getEnvId());
        dataRow.createCell(15).setCellValue(dto.getCbaCode());
        dataRow.createCell(16).setCellValue(dto.getEcsId());
        dataRow.createCell(17).setCellValue(dto.getBatchMgrType());
        dataRow.createCell(18).setCellValue(dto.getBatchGuideUrl());
        dataRow.createCell(19).setCellValue(dto.getCreateUser());
        dataRow.createCell(20).setCellValue(dto.getCreateTime());
        dataRow.createCell(21).setCellValue(dto.getLastModifyUser());
        dataRow.createCell(22).setCellValue(dto.getLastModifyTime());
        dataRow.createCell(23).setCellValue(dto.getBatchState());
        dataRow.createCell(24).setCellValue(dto.getBatchSource());
        dataRow.createCell(25).setCellValue(dto.getFlowVersion());
        workbook.write((OutputStream)response.getOutputStream());
        workbook.close();
        response.getOutputStream().flush();
    }

    public List<FlowConfMasterDTO> queryCpnRelList(String flowId) {
        List list = ((FlowConfMasterRepository)this.getRepository()).queryCpnRelList(flowId);
        return this.beansCopy(list, FlowConfMasterDTO.class);
    }
}

