/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.flow.console.application.service.impl;

import com.irdstudio.allinflow.flow.WorkflowBizInterface;
import com.irdstudio.allinflow.flow.WorkflowEngineInterface;
import com.irdstudio.allinflow.flow.console.facade.dto.ResultInstanceDto;
import com.irdstudio.allinflow.flow.exception.WorkflowException;
import com.irdstudio.allinflow.flow.util.WorkFlowUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Service(value="workflowEngineImpl")
public class WorkflowEngineImpl
implements WorkflowEngineInterface {
    @Autowired
    private WorkflowBizInterface bizService;

    @Transactional(rollbackFor={Exception.class})
    public void afterSubmit(final ResultInstanceDto instanceInfo) throws WorkflowException {
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCommit() {
                String bizBeanId = instanceInfo.getBizBeanId();
                if (!WorkFlowUtil.isNullOrEmpty((String)bizBeanId)) {
                    if ("1".equals(instanceInfo.getAsynDo())) {
                        WorkflowEngineImpl.this.bizService.saynBizOp(instanceInfo);
                    } else {
                        WorkflowEngineImpl.this.bizService.afterSubmit(instanceInfo);
                    }
                }
            }
        });
    }
}

