/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.deliver.console.application.service.impl;

import com.irdstudio.allinflow.deliver.console.acl.repository.FlowInstTodoRepository;
import com.irdstudio.allinflow.deliver.console.domain.entity.FlowInstTodoDO;
import com.irdstudio.allinflow.deliver.console.facade.FlowConfTaskService;
import com.irdstudio.allinflow.deliver.console.facade.FlowInstClosedService;
import com.irdstudio.allinflow.deliver.console.facade.FlowInstDoneService;
import com.irdstudio.allinflow.deliver.console.facade.FlowInstTodoService;
import com.irdstudio.allinflow.deliver.console.facade.dto.FlowConfTaskDTO;
import com.irdstudio.allinflow.deliver.console.facade.dto.FlowInstClosedDTO;
import com.irdstudio.allinflow.deliver.console.facade.dto.FlowInstDoneDTO;
import com.irdstudio.allinflow.deliver.console.facade.dto.FlowInstTodoDTO;
import com.irdstudio.allinflow.deliver.console.facade.dto.FlowRecordDTO;
import com.irdstudio.allinflow.deliver.console.types.ProcConcl;
import com.irdstudio.allinflow.deliver.console.types.TskFlowTranMth;
import com.irdstudio.allinflow.deliver.console.types.TskSt;
import com.irdstudio.allinflow.deliver.console.types.YesOrNO;
import com.irdstudio.allinflow.flow.console.facade.NWfOrsingConfigService;
import com.irdstudio.allinflow.flow.console.facade.dto.NWfOrsingConfigDto;
import com.irdstudio.allinflow.flow.util.WorkFlowUtil;
import com.irdstudio.framework.beans.core.base.BaseServiceImpl;
import com.irdstudio.framework.beans.core.util.CurrentDateUtil;
import com.irdstudio.framework.beans.core.util.DateTool;
import com.irdstudio.framework.beans.core.vo.BaseInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="flowInstTodoServiceImpl")
public class FlowInstTodoServiceImpl
extends BaseServiceImpl<FlowInstTodoDTO, FlowInstTodoDO, FlowInstTodoRepository>
implements FlowInstTodoService {
    @Autowired
    protected FlowConfTaskService flowConfTaskService;
    @Autowired
    protected FlowInstDoneService flowInstDoneService;
    @Autowired
    protected FlowInstClosedService flowInstClosedService;
    @Autowired
    protected NWfOrsingConfigService nWfOrsingConfigService;

    public List<FlowInstTodoDTO> queryFlowInstTodoWebPools(FlowInstTodoDTO dto) {
        FlowInstTodoDO param = (FlowInstTodoDO)this.beanCopy(dto, FlowInstTodoDO.class);
        List list = ((FlowInstTodoRepository)this.getRepository()).queryFlowInstTodoWebPools(param);
        return this.beansCopy(list, FlowInstTodoDTO.class);
    }

    public List<FlowInstTodoDTO> qryAllTaskList(FlowInstTodoDTO dto) {
        FlowInstTodoDO param = (FlowInstTodoDO)this.beanCopy(dto, FlowInstTodoDO.class);
        List list = ((FlowInstTodoRepository)this.getRepository()).qryAllTaskList(param);
        return this.beansCopy(list, FlowInstTodoDTO.class);
    }

    public int manaRecOrder(FlowInstTodoDTO dto) {
        FlowInstTodoDO flowInstTodoDO = this.qryTodoByTskSeqNo(dto.getTskSeqNo());
        if (StringUtils.isNotBlank((String)flowInstTodoDO.getOprr())) {
            throw new RuntimeException("\u5f53\u524d\u4efb\u52a1\u5df2\u7ecf\u88ab\u5de5\u53f7\u3010" + flowInstTodoDO.getOprr() + "\u3011\u9886\u53d6\uff01");
        }
        int n = this.updateTskStToInProce(dto, dto.getTskSeqNo());
        if (n <= 0) {
            throw new RuntimeException("\u9886\u53d6\u4efb\u52a1\u66f4\u65b0\u5931\u8d25\uff01");
        }
        return 1;
    }

    public String batchAllocationTask(FlowInstTodoDTO dto) {
        if (StringUtils.isBlank((String)dto.getTskSeqNo())) {
            throw new RuntimeException("\u4efb\u52a1\u6d41\u6c34\u53f7\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((String)dto.getOprr())) {
            throw new RuntimeException("\u7ecf\u529e\u4eba\u4e3a\u7a7a\uff01");
        }
        String[] tskSeqNoArr = dto.getTskSeqNo().split(",");
        String fail = "";
        String err = "";
        for (String tskSeqNo : tskSeqNoArr) {
            FlowInstTodoDO flowInstTodoDO = this.qryTodoByTskSeqNo(tskSeqNo);
            if (StringUtils.isNotBlank((String)flowInstTodoDO.getOprr())) {
                fail = fail + tskSeqNo + "\u3001";
                continue;
            }
            int n = this.updateTskStToInProce(dto, tskSeqNo);
            if (n > 0) continue;
            err = err + tskSeqNo + "\u3001";
        }
        String msg = "0";
        if (fail.length() > 0) {
            fail = fail.substring(0, fail.length() - 1);
            if (err.length() > 0) {
                err = err.substring(0, err.length() - 1);
                msg = "\u4efb\u52a1\u3010" + fail + "\u3011\u5df2\u88ab\u9886\u53d6\uff0c\u4efb\u52a1\u3010" + err + "\u3011\u66f4\u65b0\u5931\u8d25\uff0c\u5176\u4f59\u4efb\u52a1\u6210\u529f\u5206\u914d\uff01";
            } else {
                msg = "\u4efb\u52a1\u3010" + fail + "\u3011\u5df2\u88ab\u9886\u53d6\uff0c\u5176\u4f59\u4efb\u52a1\u6210\u529f\u5206\u914d\uff01";
            }
        }
        return msg;
    }

    public int updateUrgentFlagByTskSeqNo(FlowInstTodoDTO dto) {
        FlowInstTodoDO updateDO = new FlowInstTodoDO();
        updateDO.setTskSeqNo(dto.getTskSeqNo());
        updateDO.setIsUrgtTsk(dto.getIsUrgtTsk());
        String nowTime = CurrentDateUtil.getTodayDateEx2();
        updateDO.setUpdateTime(nowTime);
        updateDO.setUpdatePrtcr(dto.getLoginUserId());
        int n = ((FlowInstTodoRepository)this.getRepository()).updateByPk((Object)updateDO);
        if (n <= 0) {
            throw new RuntimeException("\u66f4\u65b0\u5f85\u529e\u4efb\u52a1\u52a0\u6025\u72b6\u6001\u5931\u8d25\uff01");
        }
        return n;
    }

    public int updateTopFlagByTskSeqNo(FlowInstTodoDTO dto) {
        FlowInstDoneDTO flowInstDoneDTO;
        int n = 0;
        FlowInstTodoDO flowInstTodoDO = this.qryTodoByTskSeqNo(dto.getTskSeqNo());
        if (flowInstTodoDO != null) {
            FlowInstTodoDO updateDO = new FlowInstTodoDO();
            updateDO.setTskSeqNo(dto.getTskSeqNo());
            updateDO.setIsTop(dto.getIsTop());
            String nowTime = CurrentDateUtil.getTodayDateEx2();
            updateDO.setUpdateTime(nowTime);
            updateDO.setUpdatePrtcr(dto.getLoginUserId());
            n = ((FlowInstTodoRepository)this.getRepository()).updateByPk((Object)updateDO);
            if (n <= 0) {
                throw new RuntimeException("\u66f4\u65b0\u5f85\u529e\u4efb\u52a1\u7f6e\u9876\u72b6\u6001\u5931\u8d25\uff01");
            }
        }
        if (flowInstTodoDO == null) {
            FlowInstDoneDTO doneDTO = this.qryDoneByTskSeqNo(dto.getTskSeqNo());
            if (doneDTO != null) {
                flowInstDoneDTO = new FlowInstDoneDTO();
                flowInstDoneDTO.setTskSeqNo(dto.getTskSeqNo());
                flowInstDoneDTO.setIsTop(dto.getIsTop());
                n = this.flowInstDoneService.updateByPk((Object)flowInstDoneDTO);
                if (n <= 0) {
                    throw new RuntimeException("\u66f4\u65b0\u5df2\u529e\u4efb\u52a1\u7f6e\u9876\u72b6\u6001\u5931\u8d25\uff01");
                }
            } else {
                FlowInstClosedDTO flowInstClosedDTO = new FlowInstClosedDTO();
                flowInstClosedDTO.setTskSeqNo(dto.getTskSeqNo());
                flowInstClosedDTO.setIsTop(dto.getIsTop());
                n = this.flowInstClosedService.updateByPk((Object)flowInstClosedDTO);
                if (n <= 0) {
                    throw new RuntimeException("\u66f4\u65b0\u529e\u7ed3\u4efb\u52a1\u7f6e\u9876\u72b6\u6001\u5931\u8d25\uff01");
                }
            }
        }
        if (YesOrNO.YES.getCode2().equals(dto.getIsTop())) {
            FlowInstTodoDO updateDO2 = new FlowInstTodoDO();
            updateDO2.setTskSeqNo(dto.getTskSeqNo());
            updateDO2.setCurrNodeProcr(dto.getLoginUserId());
            n += ((FlowInstTodoRepository)this.getRepository()).cancelTop(updateDO2);
            flowInstDoneDTO = new FlowInstDoneDTO();
            flowInstDoneDTO.setTskSeqNo(dto.getTskSeqNo());
            flowInstDoneDTO.setCurrNodeProcr(dto.getLoginUserId());
            n += this.flowInstDoneService.cancelTop(flowInstDoneDTO);
            FlowInstClosedDTO flowInstClosedDTO = new FlowInstClosedDTO();
            flowInstClosedDTO.setTskSeqNo(dto.getTskSeqNo());
            flowInstClosedDTO.setCurrNodeProcr(dto.getLoginUserId());
            n += this.flowInstClosedService.cancelTop(flowInstClosedDTO);
        }
        return n;
    }

    public int submitTodo(FlowInstTodoDTO dto) {
        int r = 0;
        if (ProcConcl.PASS.getCode().equals(dto.getProcConcl())) {
            r = this.handPass(dto);
        } else if (ProcConcl.REFUSE.getCode().equals(dto.getProcConcl())) {
            r = this.handRefuse(dto);
        } else if (ProcConcl.BACK.getCode().equals(dto.getProcConcl())) {
            r = this.handBack(dto);
        }
        return r;
    }

    public int tranSubmit(FlowInstTodoDTO dto) {
        FlowInstTodoDO updateDO = new FlowInstTodoDO();
        updateDO.setTskSeqNo(dto.getTskSeqNo());
        updateDO.setOprr(dto.getOprr());
        updateDO.setOprrName(dto.getOprrName());
        updateDO.setOprrBelgOrg(dto.getOprrBelgOrg());
        String currNodeProcr = StringUtils.isBlank((String)dto.getCurrNodeProcr()) ? dto.getOprr() : dto.getCurrNodeProcr();
        String currNodeProcrName = StringUtils.isBlank((String)dto.getCurrNodeProcrName()) ? dto.getOprrName() : dto.getCurrNodeProcrName();
        updateDO.setCurrNodeProcr(currNodeProcr);
        updateDO.setCurrNodeProcrName(currNodeProcrName);
        updateDO.setUpdatePrtcr(dto.getLoginUserId());
        updateDO.setTskSt(TskSt.IN_PROCE.getCode());
        updateDO.setIsTop(YesOrNO.NO.getCode2());
        String nowTime = CurrentDateUtil.getTodayDateEx2();
        updateDO.setUpdateTime(nowTime);
        int n = ((FlowInstTodoRepository)this.getRepository()).updateByPk((Object)updateDO);
        return n;
    }

    public List<FlowRecordDTO> qryTaskRecordList(FlowInstTodoDTO dto) {
        String bizSeqNo = null;
        switch (dto.getQryType()) {
            case "2": {
                FlowInstDoneDTO flowInstDoneDTO = this.qryDoneByTskSeqNo(dto.getTskSeqNo());
                bizSeqNo = flowInstDoneDTO.getBizSeqNo();
                break;
            }
            case "3": {
                FlowInstClosedDTO flowInstClosedDTO = this.qryClosedByTskSeqNo(dto.getTskSeqNo());
                bizSeqNo = flowInstClosedDTO.getBizSeqNo();
                break;
            }
            default: {
                FlowInstTodoDO flowInstTodoDO = this.qryTodoByTskSeqNo(dto.getTskSeqNo());
                bizSeqNo = flowInstTodoDO.getBizSeqNo();
            }
        }
        FlowInstTodoDO qryParams = new FlowInstTodoDO();
        qryParams.setBizSeqNo(bizSeqNo);
        List list = ((FlowInstTodoRepository)this.getRepository()).qryTaskRecordList(qryParams);
        ArrayList<FlowRecordDTO> rlist = new ArrayList<FlowRecordDTO>();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            AtomicInteger i = new AtomicInteger(1);
            list.forEach(item -> {
                FlowRecordDTO flowRecord = new FlowRecordDTO();
                String title = "\u5904\u7406\u4eba\uff1a" + item.getCurrNodeProcrName() + "\uff0c\u5ba1\u6279\u5f00\u59cb\u65f6\u95f4\uff1a" + item.getTskSetupTm() + "\uff0c\u5ba1\u6279\u7ed3\u675f\u65f6\u95f4\uff1a" + item.getTskEndTm() + "\uff0c\u7ed3\u8bba\uff1a" + ProcConcl.nameByCode((String)item.getProcConcl());
                flowRecord.setTitle(title);
                flowRecord.setHandMessage(item.getHandMessage());
                flowRecord.setProcConcl(item.getProcConcl());
                flowRecord.setName(String.valueOf(i.getAndIncrement()));
                rlist.add(flowRecord);
            });
        }
        return rlist;
    }

    public int tskCreated(FlowInstTodoDTO dto) {
        if (StringUtils.isBlank((String)dto.getTskTp())) {
            throw new RuntimeException("\u4efb\u52a1\u7c7b\u578b\u4e3a\u7a7a");
        }
        FlowConfTaskDTO flowConfTaskDTO = new FlowConfTaskDTO();
        flowConfTaskDTO.setTskTp(dto.getTskTp());
        FlowConfTaskDTO flowConfTask = (FlowConfTaskDTO)this.flowConfTaskService.queryByPk((Object)flowConfTaskDTO);
        if (flowConfTask == null) {
            throw new RuntimeException("\u67e5\u8be2\u4e0d\u5230\u4efb\u52a1\u914d\u7f6e");
        }
        String tskSeqNo = "TSK" + DateTool.getCurrentDateTimeSSS();
        FlowInstTodoDO input = (FlowInstTodoDO)this.beanCopy(dto, FlowInstTodoDO.class);
        input.setTskSeqNo(tskSeqNo);
        input.setTskBizStag(flowConfTask.getTskBizStag());
        input.setTskFlowTranMth(flowConfTask.getTskFlowTranMth());
        input.setTskJumpPage(flowConfTask.getTskJumpPage());
        input.setIsInPcTermShow(flowConfTask.getIsInPcTermShow());
        input.setIsMayPcHand(flowConfTask.getIsMayPcHand());
        input.setIsInMovTermShow(flowConfTask.getIsInMovTermShow());
        int n = ((FlowInstTodoRepository)this.getRepository()).insert((Object)input);
        if (n <= 0) {
            throw new RuntimeException("\u4efb\u52a1\u63d2\u5165\u5931\u8d25");
        }
        return n;
    }

    public FlowInstTodoDTO qryAllTaskDetails(FlowInstTodoDTO dto) {
        FlowInstTodoDO param = (FlowInstTodoDO)this.beanCopy(dto, FlowInstTodoDO.class);
        List list = ((FlowInstTodoRepository)this.getRepository()).qryAllTaskDetails(param);
        if (CollectionUtils.isNotEmpty((Collection)list) && list.size() > 1) {
            throw new RuntimeException("\u4efb\u52a1\u8fd4\u56de\u591a\u6b21\u8bb0\u5f55");
        }
        FlowInstTodoDTO flowInstTodoDTO = (FlowInstTodoDTO)this.beanCopy(list.get(0), FlowInstTodoDTO.class);
        return flowInstTodoDTO;
    }

    private int handPass(FlowInstTodoDTO dto) {
        dto.setTskSt(TskSt.PASS.getCode());
        int n = this.insertDoneTsk(dto);
        return n += this.deleteByTskSeqNo(dto.getTskSeqNo());
    }

    private int handRefuse(FlowInstTodoDTO dto) {
        dto.setTskSt(TskSt.REFUSE.getCode());
        int n = this.insertDoneTsk(dto);
        return n += this.deleteByTskSeqNo(dto.getTskSeqNo());
    }

    private int handBack(FlowInstTodoDTO dto) {
        FlowInstTodoDO flowInstTodoDO = this.qryTodoByTskSeqNo(dto.getTskSeqNo());
        int n = 0;
        if (TskFlowTranMth.STS_FL.getCode().equals(flowInstTodoDO.getTskFlowTranMth())) {
            FlowInstTodoDO updateParams = new FlowInstTodoDO();
            updateParams.setTskSeqNo(dto.getTskSeqNo());
            n = ((FlowInstTodoRepository)this.getRepository()).updateOprrNullByPk(updateParams);
        } else if (TskFlowTranMth.FLOW_FL.getCode().equals(flowInstTodoDO.getTskFlowTranMth())) {
            // empty if block
        }
        return n;
    }

    private FlowInstTodoDO qryTodoByTskSeqNo(String tskSeqNo) {
        if (StringUtils.isBlank((String)tskSeqNo)) {
            throw new RuntimeException("\u4efb\u52a1\u6d41\u6c34\u53f7\u4e3a\u7a7a");
        }
        FlowInstTodoDO qryParam = new FlowInstTodoDO();
        qryParam.setTskSeqNo(tskSeqNo);
        FlowInstTodoDO flowInstTodoDO = (FlowInstTodoDO)((FlowInstTodoRepository)this.getRepository()).queryByPk((Object)qryParam);
        return flowInstTodoDO;
    }

    private FlowInstDoneDTO qryDoneByTskSeqNo(String tskSeqNo) {
        if (StringUtils.isBlank((String)tskSeqNo)) {
            throw new RuntimeException("\u4efb\u52a1\u6d41\u6c34\u53f7\u4e3a\u7a7a");
        }
        FlowInstDoneDTO qryParam = new FlowInstDoneDTO();
        qryParam.setTskSeqNo(tskSeqNo);
        FlowInstDoneDTO flowInstDoneDO = (FlowInstDoneDTO)this.flowInstDoneService.queryByPk((Object)qryParam);
        return flowInstDoneDO;
    }

    private FlowInstClosedDTO qryClosedByTskSeqNo(String tskSeqNo) {
        if (StringUtils.isBlank((String)tskSeqNo)) {
            throw new RuntimeException("\u4efb\u52a1\u6d41\u6c34\u53f7\u4e3a\u7a7a");
        }
        FlowInstClosedDTO qryParam = new FlowInstClosedDTO();
        qryParam.setTskSeqNo(tskSeqNo);
        FlowInstClosedDTO flowInstClosedDTO = (FlowInstClosedDTO)this.flowInstClosedService.queryByPk((Object)qryParam);
        return flowInstClosedDTO;
    }

    private int deleteByTskSeqNo(String tskSeqNo) {
        if (StringUtils.isBlank((String)tskSeqNo)) {
            throw new RuntimeException("\u4efb\u52a1\u6d41\u6c34\u53f7\u4e3a\u7a7a");
        }
        FlowInstTodoDO delParams = new FlowInstTodoDO();
        delParams.setTskSeqNo(tskSeqNo);
        int n = ((FlowInstTodoRepository)this.getRepository()).deleteByPk((Object)delParams);
        if (n <= 0) {
            throw new RuntimeException("\u5220\u9664\u5f85\u529e\u4efb\u52a1\u5931\u8d25");
        }
        return n;
    }

    private int insertDoneTsk(FlowInstTodoDTO dto) {
        FlowInstTodoDO flowInstTodoDO = this.qryTodoByTskSeqNo(dto.getTskSeqNo());
        FlowInstDoneDTO flowInstDoneDTO = (FlowInstDoneDTO)this.beanCopy(flowInstTodoDO, FlowInstDoneDTO.class);
        flowInstDoneDTO.setTskSt(dto.getTskSt());
        flowInstDoneDTO.setHandMessage(dto.getHandMessage());
        flowInstDoneDTO.setProcConcl(dto.getProcConcl());
        flowInstDoneDTO.setIsTop(YesOrNO.NO.getCode2());
        flowInstDoneDTO.setIsNew(YesOrNO.NO.getCode2());
        String nowTime = CurrentDateUtil.getTodayDateEx2();
        flowInstDoneDTO.setUpdateTime(nowTime);
        flowInstDoneDTO.setUpdatePrtcr(dto.getLoginUserId());
        flowInstDoneDTO.setCreateTime(nowTime);
        flowInstDoneDTO.setCreateUser(dto.getLoginUserId());
        int n = this.flowInstDoneService.insert((Object)flowInstDoneDTO);
        if (n <= 0) {
            throw new RuntimeException("\u5df2\u529e\u4efb\u52a1\u63d2\u5165\u5931\u8d25");
        }
        return n;
    }

    private int updateTskStToInProce(FlowInstTodoDTO dto, String tskSeqNo) {
        FlowInstTodoDO updateDO = new FlowInstTodoDO();
        updateDO.setTskSeqNo(tskSeqNo);
        updateDO.setOprr(dto.getOprr());
        updateDO.setOprrName(dto.getOprrName());
        updateDO.setOprrBelgOrg(dto.getLoginUserOrgCode());
        String currNodeProcr = StringUtils.isBlank((String)dto.getCurrNodeProcr()) ? dto.getOprr() : dto.getCurrNodeProcr();
        String currNodeProcrName = StringUtils.isBlank((String)dto.getCurrNodeProcrName()) ? dto.getOprrName() : dto.getCurrNodeProcrName();
        updateDO.setCurrNodeProcr(currNodeProcr);
        updateDO.setCurrNodeProcrName(currNodeProcrName);
        updateDO.setUpdatePrtcr(dto.getLoginUserId());
        updateDO.setTskSt(TskSt.IN_PROCE.getCode());
        String nowTime = CurrentDateUtil.getTodayDateEx2();
        updateDO.setUpdateTime(nowTime);
        int n = ((FlowInstTodoRepository)this.getRepository()).updateByPk((Object)updateDO);
        return n;
    }

    public int insertFlowInstTodo(NWfOrsingConfigDto nWfOrsingConfigDto, String bizSeqNo) {
        int n = 0;
        if ("S".equals((nWfOrsingConfigDto = (NWfOrsingConfigDto)this.nWfOrsingConfigService.queryByPk((Object)nWfOrsingConfigDto)).getNodeType())) {
            FlowInstTodoDTO flowInstTodoDTO = new FlowInstTodoDTO();
            String seqNo = WorkFlowUtil.generatePrimaryKey();
            flowInstTodoDTO.setTskSeqNo(seqNo);
            flowInstTodoDTO.setTskSt("02");
            flowInstTodoDTO.setHandMessage("");
            flowInstTodoDTO.setProcConcl("");
            flowInstTodoDTO.setIsTop(YesOrNO.NO.getCode2());
            if (YesOrNO.NO.getCode().equals(nWfOrsingConfigDto.getIsFirst())) {
                flowInstTodoDTO.setIsNew(YesOrNO.YES.getCode2());
            } else {
                flowInstTodoDTO.setIsNew(YesOrNO.NO.getCode2());
            }
            flowInstTodoDTO.setBatchId(nWfOrsingConfigDto.getBatchId());
            flowInstTodoDTO.setCurrNodeProcr(nWfOrsingConfigDto.getUserId());
            flowInstTodoDTO.setBizSeqNo(bizSeqNo);
            flowInstTodoDTO.setTskTp("10009");
            flowInstTodoDTO.setTskBizStag("05");
            flowInstTodoDTO.setIsTop(YesOrNO.NO.getCode2());
            flowInstTodoDTO.setIsUrgtTsk(YesOrNO.NO.getCode2());
            flowInstTodoDTO.setCustName("\u5f20\u4e09");
            flowInstTodoDTO.setPrdName("\u4e91\u519c\u8d37");
            flowInstTodoDTO.setCurrTskNode(nWfOrsingConfigDto.getNodeId());
            flowInstTodoDTO.setNextNodeId(nWfOrsingConfigDto.getNextNodeId());
            flowInstTodoDTO.setCurrTskNodeName(nWfOrsingConfigDto.getNodeName());
            String nowTime = CurrentDateUtil.getTodayDateEx2();
            flowInstTodoDTO.setUpdateTime(nowTime);
            flowInstTodoDTO.setUpdatePrtcr(nWfOrsingConfigDto.getUserId());
            flowInstTodoDTO.setCreateTime(nowTime);
            flowInstTodoDTO.setCreateUser(nWfOrsingConfigDto.getUserId());
            n = this.insert((BaseInfo)flowInstTodoDTO);
        } else {
            String[] users;
            for (String userId : users = nWfOrsingConfigDto.getUserId().split(",")) {
                FlowInstTodoDTO flowInstTodoDTO = new FlowInstTodoDTO();
                String seqNo = WorkFlowUtil.generatePrimaryKey();
                flowInstTodoDTO.setTskSeqNo(seqNo);
                flowInstTodoDTO.setTskSt("02");
                flowInstTodoDTO.setHandMessage("");
                flowInstTodoDTO.setProcConcl("");
                flowInstTodoDTO.setIsTop(YesOrNO.NO.getCode2());
                if (YesOrNO.NO.getCode().equals(nWfOrsingConfigDto.getIsFirst())) {
                    flowInstTodoDTO.setIsNew(YesOrNO.YES.getCode2());
                } else {
                    flowInstTodoDTO.setIsNew(YesOrNO.NO.getCode2());
                }
                flowInstTodoDTO.setBatchId(nWfOrsingConfigDto.getBatchId());
                flowInstTodoDTO.setCurrNodeProcr(userId);
                flowInstTodoDTO.setBizSeqNo(bizSeqNo);
                flowInstTodoDTO.setTskTp("10009");
                flowInstTodoDTO.setTskBizStag("05");
                flowInstTodoDTO.setCurrTskNodeName(nWfOrsingConfigDto.getNodeName());
                flowInstTodoDTO.setIsTop(YesOrNO.NO.getCode2());
                flowInstTodoDTO.setIsUrgtTsk(YesOrNO.NO.getCode2());
                flowInstTodoDTO.setCustName("\u5f20\u4e09");
                flowInstTodoDTO.setPrdName("\u4e91\u519c\u8d37");
                flowInstTodoDTO.setCurrTskNode(nWfOrsingConfigDto.getNodeId());
                flowInstTodoDTO.setNextNodeId(nWfOrsingConfigDto.getNextNodeId());
                String nowTime = CurrentDateUtil.getTodayDateEx2();
                flowInstTodoDTO.setUpdateTime(nowTime);
                flowInstTodoDTO.setUpdatePrtcr(userId);
                flowInstTodoDTO.setCreateTime(nowTime);
                flowInstTodoDTO.setCreateUser(userId);
                n = this.insert((BaseInfo)flowInstTodoDTO);
            }
        }
        if (n <= 0) {
            throw new RuntimeException("\u5f85\u529e\u4efb\u52a1\u63d2\u5165\u5931\u8d25");
        }
        return n;
    }
}

