/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.flow.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.irdstudio.allinflow.flow.util.SpringContextUtils;
import org.springframework.util.StringUtils;

public class ObjectMapperUtils {
    private static ObjectMapper INSTANCE;

    private static synchronized void init() {
        if (INSTANCE == null) {
            INSTANCE = (ObjectMapper)SpringContextUtils.getBeanProvider(ObjectMapper.class).getIfAvailable(ObjectMapper::new);
        }
    }

    public static ObjectMapper instance() {
        if (INSTANCE == null) {
            ObjectMapperUtils.init();
        }
        return INSTANCE;
    }

    public static String toJson(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return ObjectMapperUtils.instance().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T toObject(String json, Class<T> classType) {
        if (StringUtils.isEmpty((Object)json)) {
            return null;
        }
        try {
            return (T)ObjectMapperUtils.instance().readValue(json, classType);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

