/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.flow.util;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.util.Asserts;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.lang.NonNull;

public class SpringContextUtils
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;
    private static boolean init;

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static void initApplicationContext(ApplicationContext applicationContext) {
        SpringContextUtils.applicationContext = applicationContext;
    }

    public static void initApplicationContextIfNotSet(ApplicationContext applicationContext) {
        if (!init) {
            SpringContextUtils.applicationContext = applicationContext;
        }
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) {
        init = true;
        SpringContextUtils.initApplicationContext(applicationContext);
    }

    public static <T> T getBean(String name) {
        SpringContextUtils.checkContext();
        return (T)applicationContext.getBean(name);
    }

    public static <T> ObjectProvider<T> getBeanProvider(Class<T> classType) {
        SpringContextUtils.checkContext();
        return applicationContext.getBeanProvider(classType);
    }

    public static <T> T getBean(Class<T> requiredType) {
        SpringContextUtils.checkContext();
        return (T)applicationContext.getBean(requiredType);
    }

    public static boolean containsBean(String name) {
        SpringContextUtils.checkContext();
        return applicationContext.containsBean(name);
    }

    public static <T> T getBean(String name, Class<T> requiredType) {
        SpringContextUtils.checkContext();
        return (T)applicationContext.getBean(name, requiredType);
    }

    public static String[] getBeanNamesForAnnotation(Class<? extends Annotation> annotationType) {
        SpringContextUtils.checkContext();
        return applicationContext.getBeanNamesForAnnotation(annotationType);
    }

    public static String[] getBeanNamesForType(Class<?> type) {
        SpringContextUtils.checkContext();
        return applicationContext.getBeanNamesForType(type);
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> classType) {
        SpringContextUtils.checkContext();
        return applicationContext.getBeansOfType(classType);
    }

    public static Map<String, Object> getBeansWithAnnotation(Class<? extends Annotation> annotationType) {
        SpringContextUtils.checkContext();
        return applicationContext.getBeansWithAnnotation(annotationType);
    }

    public static <T> List<T> getBeansWithAnnotationToList(Class<? extends Annotation> annotationType) {
        SpringContextUtils.checkContext();
        return new ArrayList(applicationContext.getBeansWithAnnotation(annotationType).values());
    }

    public static String[] getBeanDefinitionNames() {
        SpringContextUtils.checkContext();
        return applicationContext.getBeanDefinitionNames();
    }

    public static void publishEvent(ApplicationEvent event) {
        SpringContextUtils.checkContext();
        applicationContext.publishEvent(event);
    }

    public static String getApplicationName() {
        SpringContextUtils.checkContext();
        return applicationContext.getEnvironment().getProperty("spring.application.name");
    }

    public static String getDomain() {
        SpringContextUtils.checkContext();
        return applicationContext.getEnvironment().getProperty("spring.application.domain");
    }

    public static String[] getActiveProfiles() {
        SpringContextUtils.checkContext();
        return applicationContext.getEnvironment().getActiveProfiles();
    }

    private static void checkContext() {
        Asserts.notNull((Object)applicationContext, (String)"application context not init");
    }

    static {
        init = false;
    }
}

