/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.deliver.console.web.controller.api;

import com.irdstudio.allinflow.deliver.console.facade.FlowConfNodeService;
import com.irdstudio.allinflow.deliver.console.facade.FlowInstNodeService;
import com.irdstudio.allinflow.deliver.console.facade.dto.FlowConfNodeDTO;
import com.irdstudio.allinflow.deliver.console.facade.dto.FlowInstNodeDTO;
import com.irdstudio.allinflow.deliver.console.facade.dto.FlowInstNodeTreeDTO;
import com.irdstudio.framework.beans.core.vo.ResponseData;
import com.irdstudio.framework.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class FlowInstNodeController
extends BaseController<FlowInstNodeDTO, FlowInstNodeService> {
    @Autowired
    private FlowConfNodeService flowConfNodeService;

    @RequestMapping(value={"/api/flow/inst/nodes"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<FlowInstNodeDTO>> queryFlowInstNodeAll(FlowInstNodeDTO dto) {
        List outputVo = ((FlowInstNodeService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/flow/inst/nodes/list"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<FlowInstNodeDTO>> queryList(FlowInstNodeDTO dto) {
        List outputVo = ((FlowInstNodeService)this.getService()).queryList((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/flow/inst/node/{batchSerialNo}/{taskId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<FlowInstNodeDTO> queryByPk(@PathVariable(value="batchSerialNo") String batchSerialNo, @PathVariable(value="taskId") String taskId) {
        FlowInstNodeDTO inVo = new FlowInstNodeDTO();
        inVo.setBatchSerialNo(batchSerialNo);
        inVo.setTaskId(taskId);
        FlowInstNodeDTO outputVo = (FlowInstNodeDTO)((FlowInstNodeService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/flow/inst/node"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody FlowInstNodeDTO inFlowInstNodeDTO) {
        int outputVo = ((FlowInstNodeService)this.getService()).deleteByPk((Object)inFlowInstNodeDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/flow/inst/node"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody FlowInstNodeDTO inFlowInstNodeDTO) {
        int outputVo = ((FlowInstNodeService)this.getService()).updateByPk((Object)inFlowInstNodeDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/flow/inst/node"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertFlowInstNode(@RequestBody FlowInstNodeDTO inFlowInstNodeDTO) {
        int outputVo = ((FlowInstNodeService)this.getService()).insert((Object)inFlowInstNodeDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/flow/inst/node/tree/{batchSerialNo}/{batchId}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<FlowInstNodeTreeDTO> queryInstTaskTree(@PathVariable(value="batchSerialNo") String batchSerialNo, @PathVariable(value="batchId") String batchId) {
        FlowInstNodeDTO inVo = new FlowInstNodeDTO();
        inVo.setBatchSerialNo(batchSerialNo);
        inVo.setBatchId(batchId);
        List outputVo = ((FlowInstNodeService)this.getService()).queryFlowInstNodeTree(inVo);
        return outputVo;
    }

    @RequestMapping(value={"/api/flow/hist/nodeangup"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> hangUp(@RequestBody FlowInstNodeDTO inFlowInstNodeVo) {
        FlowInstNodeDTO updateParam = new FlowInstNodeDTO();
        updateParam.setBatchSerialNo(inFlowInstNodeVo.getBatchSerialNo());
        updateParam.setTaskId(inFlowInstNodeVo.getTaskId());
        updateParam.setTaskInterveneState("2");
        int outputVo = ((FlowInstNodeService)this.getService()).updateByPk((Object)inFlowInstNodeVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/flow/hist/nodeangdown"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> hangDown(@RequestBody FlowInstNodeDTO inFlowInstNodeVo) {
        FlowInstNodeDTO updateParam = new FlowInstNodeDTO();
        updateParam.setBatchSerialNo(inFlowInstNodeVo.getBatchSerialNo());
        updateParam.setTaskId(inFlowInstNodeVo.getTaskId());
        updateParam.setTaskInterveneState("0");
        int outputVo = ((FlowInstNodeService)this.getService()).updateByPk((Object)inFlowInstNodeVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/flow/inst/node/skip"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> skip(@RequestBody FlowInstNodeDTO inFlowInstNodeVo) {
        FlowConfNodeDTO params = new FlowConfNodeDTO();
        params.setTaskId(inFlowInstNodeVo.getTaskId());
        FlowConfNodeDTO configVO = (FlowConfNodeDTO)this.flowConfNodeService.queryByPk((Object)params);
        ResponseData data = null;
        if (configVO != null && StringUtils.isNotEmpty((CharSequence)configVO.getTaskSkipTactic()) && !configVO.getTaskSkipTactic().equals("2")) {
            FlowInstNodeDTO updateParam = new FlowInstNodeDTO();
            updateParam.setBatchSerialNo(inFlowInstNodeVo.getBatchSerialNo());
            updateParam.setTaskId(inFlowInstNodeVo.getTaskId());
            updateParam.setTaskInterveneState("1");
            int outputVo = ((FlowInstNodeService)this.getService()).updateByPk((Object)inFlowInstNodeVo);
            data = this.getResponseData(outputVo);
        } else {
            data = this.getResponseData(-1);
            data.setMessage("\u8be5\u4efb\u52a1\u4e0d\u5141\u8bb8\u7f6e\u8fc7\uff01");
        }
        return data;
    }
}

