/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.quality.console.web.controller.api;

import com.irdstudio.allinflow.quality.console.application.service.check.scheme.executor.SCheckSchemeExecutor;
import com.irdstudio.allinflow.quality.console.facade.SCheckExecutorService;
import com.irdstudio.allinflow.quality.console.facade.dto.SCheckSchemeDTO;
import com.irdstudio.allinflow.quality.console.facade.dto.SCheckSchemeService;
import com.irdstudio.framework.beans.core.threadpool.ApplicationThreadPool2;
import com.irdstudio.framework.beans.core.util.TimeUtil;
import com.irdstudio.framework.beans.core.vo.ResponseData;
import com.irdstudio.framework.beans.web.controller.AbstractController;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class SCheckExecutorController
extends AbstractController {
    @Autowired
    private ApplicationThreadPool2 applicationThreadPool;
    @Autowired
    private SCheckSchemeService sCheckSchemeService;
    @Autowired
    private SCheckExecutorService sCheckExecutorService;

    @RequestMapping(value={"/api/s/check/scheme/run"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<String> executeScheme(@RequestParam(value="schemeNo") String schemeNo, @RequestParam(value="id") String id) {
        SCheckSchemeDTO inVo = new SCheckSchemeDTO();
        inVo.setSchemeNo(schemeNo);
        try {
            String key = String.format("%s-%s", schemeNo, id);
            String serialNo = (String)SCheckSchemeExecutor.taskDebounce.get(key);
            if (StringUtils.isNotBlank((CharSequence)serialNo)) {
                return this.getResponseData(serialNo);
            }
            SCheckSchemeExecutor.taskDebounce.put(String.format("%s-%s-result", schemeNo, id), "start");
            SCheckSchemeDTO checkScheme = (SCheckSchemeDTO)this.sCheckSchemeService.queryByPk((Object)inVo);
            String outputVo = null;
            if (Objects.nonNull(checkScheme)) {
                SCheckSchemeDTO schemeParam = checkScheme;
                schemeParam.setLoginUserId(this.getUserInfo().getUserId());
                serialNo = TimeUtil.getTimeStampByPattern((String)"yyyyMMddHHmmssSSS");
                SCheckSchemeExecutor executor = new SCheckSchemeExecutor(schemeParam, serialNo, id);
                SCheckSchemeExecutor.taskDebounce.put(key, serialNo);
                this.applicationThreadPool.add((Callable)executor);
                outputVo = serialNo;
            } else {
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
                outputVo = null;
            }
            return this.getResponseData(outputVo);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            ResponseData resp = this.getResponseData(null);
            resp.setMessage(e.getMessage());
            return resp;
        }
    }

    @RequestMapping(value={"/api/s/check/scheme/run/result"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<String> getExecuteSchemeResult(@RequestParam(value="schemeNo") String schemeNo, @RequestParam(value="id") String id) {
        String result = (String)SCheckSchemeExecutor.taskDebounce.get(String.format("%s-%s-result", schemeNo, id));
        if (result == null) {
            result = "";
        }
        return this.getResponseData(result);
    }

    @RequestMapping(value={"/client/SCheckSchemeService/executeSchemeSync"}, method={RequestMethod.POST})
    @ResponseBody
    public List<String> executeSchemeSync(@RequestParam(value="schemeNo") String schemeNo, @RequestParam(value="id") String id, @RequestParam(value="userId") String userId) {
        return this.sCheckExecutorService.executeSchemeSync(schemeNo, id, userId);
    }
}

