/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.admin.console.application.service.impl;

import com.irdstudio.allinrdm.admin.console.acl.repository.RdmWeeklyCalendarRepository;
import com.irdstudio.allinrdm.admin.console.acl.repository.RdmWeeklyInfoRepository;
import com.irdstudio.allinrdm.admin.console.acl.repository.RdmWeeklyIssueRepository;
import com.irdstudio.allinrdm.admin.console.acl.repository.RdmWeeklyTaskRepository;
import com.irdstudio.allinrdm.admin.console.domain.entity.RdmWeeklyCalendarDO;
import com.irdstudio.allinrdm.admin.console.domain.entity.RdmWeeklyInfoDO;
import com.irdstudio.allinrdm.admin.console.domain.entity.RdmWeeklyIssueDO;
import com.irdstudio.allinrdm.admin.console.domain.entity.RdmWeeklyTaskDO;
import com.irdstudio.allinrdm.admin.console.facade.RdmWeeklyInfoService;
import com.irdstudio.allinrdm.admin.console.facade.dto.RdmWeeklyInfoDTO;
import com.irdstudio.allinrdm.admin.console.types.ReportType;
import com.irdstudio.allinrdm.dev.console.types.YesOrNO;
import com.irdstudio.allinrdm.project.console.acl.repository.RdmProjectUserRepository;
import com.irdstudio.allinrdm.project.console.acl.repository.RdmTeamInfoRepository;
import com.irdstudio.allinrdm.project.console.domain.entity.RdmProjectUserDO;
import com.irdstudio.allinrdm.project.console.domain.entity.RdmTeamInfoDO;
import com.irdstudio.allinrdm.project.console.types.ReportState;
import com.irdstudio.allintcp.admin.facade.AllinCloudPortalClient;
import com.irdstudio.allintcp.admin.facade.dto.SUserDTO;
import com.irdstudio.sdk.admin.service.dynamic.DynamicLog;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rdmWeeklyInfoServiceImpl")
public class RdmWeeklyInfoServiceImpl
extends BaseServiceImpl<RdmWeeklyInfoDTO, RdmWeeklyInfoDO, RdmWeeklyInfoRepository>
implements RdmWeeklyInfoService {
    @Autowired
    private AllinCloudPortalClient portalClient;
    @Autowired
    private RdmWeeklyCalendarRepository rdmWeeklyCalendarRepository;
    @Autowired
    private RdmTeamInfoRepository rdmTeamInfoRepository;
    @Autowired
    private RdmProjectUserRepository rdmProjectUserRepository;
    @Autowired
    private RdmWeeklyTaskRepository rdmWeeklyTaskRepository;
    @Autowired
    private RdmWeeklyIssueRepository rdmWeeklyIssueRepository;

    @DynamicLog(action=DynamicLog.Action.Add, dynamicType=DynamicLog.DynamicLogType.WeekReport, moduleCode="rdm", bizKey="${args[0].reportId}")
    public int insert(RdmWeeklyInfoDTO paramDTO) {
        if (StringUtils.isBlank((CharSequence)paramDTO.getCheckUserId())) {
            RdmTeamInfoDO teamInfo = new RdmTeamInfoDO();
            teamInfo.setLoginUserId(paramDTO.getInchargeUserId());
            List teamList = this.rdmTeamInfoRepository.queryListByPage((Object)teamInfo);
            if (CollectionUtils.isNotEmpty((Collection)teamList)) {
                teamInfo = (RdmTeamInfoDO)teamList.get(0);
                paramDTO.setCheckUserId(teamInfo.getIncharge());
                paramDTO.setCheckUserName(teamInfo.getInchargeName());
            }
        }
        return super.insert((BaseInfo)paramDTO);
    }

    @DynamicLog(action=DynamicLog.Action.Delete, dynamicType=DynamicLog.DynamicLogType.WeekReport, moduleCode="rdm", bizKey="${args[0].reportId}")
    public int deleteByPk(RdmWeeklyInfoDTO paramDTO) {
        RdmWeeklyTaskDO taskDel = new RdmWeeklyTaskDO();
        taskDel.setReportId(paramDTO.getReportId());
        this.rdmWeeklyTaskRepository.deleteByCond(taskDel);
        RdmWeeklyIssueDO issueDel = new RdmWeeklyIssueDO();
        issueDel.setReportId(paramDTO.getReportId());
        this.rdmWeeklyIssueRepository.deleteByCond(issueDel);
        return super.deleteByPk((BaseInfo)paramDTO);
    }

    @DynamicLog(action=DynamicLog.Action.Update, dynamicType=DynamicLog.DynamicLogType.WeekReport, moduleCode="rdm", bizKey="${args[0].reportId}")
    public int updateByPk(RdmWeeklyInfoDTO paramDO) {
        RdmWeeklyInfoDTO oldData = (RdmWeeklyInfoDTO)this.queryByPk((BaseInfo)paramDO);
        if (!StringUtils.equals((CharSequence)oldData.getReportState(), (CharSequence)paramDO.getReportState()) && StringUtils.equals((CharSequence)paramDO.getReportState(), (CharSequence)ReportState.Submitted.getCode())) {
            paramDO.setDlText(String.format("%s%s", ReportState.Submitted.getName(), paramDO.diffPrefix()));
        }
        return super.updateByPk((BaseInfo)paramDO);
    }

    public List<Map<String, Object>> queryMessageSummary(RdmWeeklyInfoDTO param) {
        RdmWeeklyInfoDO rdmWeeklyInfoDO = new RdmWeeklyInfoDO();
        this.beanCopy(param, rdmWeeklyInfoDO);
        return ((RdmWeeklyInfoRepository)this.getRepository()).queryMessageSummary(rdmWeeklyInfoDO);
    }

    public Integer initThisWeekReport(String date) {
        RdmWeeklyCalendarDO cal = this.rdmWeeklyCalendarRepository.initThisWeekCalendar(date);
        SUserDTO userParam = new SUserDTO();
        userParam.setState("1");
        List userList = this.portalClient.querySUserList(userParam);
        if (CollectionUtils.isNotEmpty((Collection)userList)) {
            ArrayList<RdmWeeklyInfoDO> reportList = new ArrayList<RdmWeeklyInfoDO>(userList.size());
            for (SUserDTO user : userList) {
                RdmWeeklyInfoDO report = new RdmWeeklyInfoDO();
                report.setInchargeUserId(user.getActorno());
                report.setInchargeUserName(user.getActorname());
                report.setWeekId(cal.getWeekId());
                List checkReports = ((RdmWeeklyInfoRepository)this.getRepository()).queryListByPage((Object)report);
                if (CollectionUtils.isNotEmpty((Collection)checkReports)) continue;
                report.setReportId(UUIDUtil.getShortUUID());
                report.setReportState(ReportState.Draft.getCode());
                reportList.add(report);
            }
            if (reportList.size() > 0) {
                int output = ((RdmWeeklyInfoRepository)this.getRepository()).batchInsert(reportList);
                return output;
            }
        }
        return 0;
    }

    public Integer initThisWeekProjectReport(String projectId, String genOption, String weekId, String overrideFlag) {
        Calendar now = Calendar.getInstance();
        String nowDate = DateFormatUtils.format((Calendar)now, (String)"yyyy-MM-dd");
        RdmWeeklyCalendarDO cal = null;
        if (StringUtils.isNotBlank((CharSequence)weekId)) {
            RdmWeeklyCalendarDO weekParam = new RdmWeeklyCalendarDO();
            weekParam.setWeekId(Integer.valueOf(NumberUtils.toInt((String)weekId)));
            cal = (RdmWeeklyCalendarDO)this.rdmWeeklyCalendarRepository.queryByPk((Object)weekParam);
        } else {
            cal = this.rdmWeeklyCalendarRepository.initThisWeekCalendar(nowDate);
        }
        RdmProjectUserDO memberParam = new RdmProjectUserDO();
        memberParam.setProjectId(projectId);
        List memberList = this.rdmProjectUserRepository.queryList((Object)memberParam);
        HashMap<String, RdmTeamInfoDO> teamMap = new HashMap<String, RdmTeamInfoDO>();
        int output = -1;
        if (CollectionUtils.isNotEmpty((Collection)memberList)) {
            ArrayList<RdmWeeklyInfoDO> reportList = new ArrayList<RdmWeeklyInfoDO>(memberList.size());
            ArrayList initRepoortList = new ArrayList(memberList.size());
            for (RdmProjectUserDO user : memberList) {
                RdmWeeklyInfoDO report = new RdmWeeklyInfoDO();
                report.setInchargeUserId(user.getUserId());
                report.setInchargeUserName(user.getUserName());
                report.setReportType(ReportType.Project.getCode());
                RdmTeamInfoDO teamInfo = (RdmTeamInfoDO)teamMap.get(user.getTeamId());
                if (teamInfo == null) {
                    teamInfo = new RdmTeamInfoDO();
                    teamInfo.setTeamId(user.getTeamId());
                    teamInfo = (RdmTeamInfoDO)this.rdmTeamInfoRepository.queryByPk((Object)teamInfo);
                    if (teamInfo != null) {
                        teamMap.put(teamInfo.getTeamId(), teamInfo);
                    }
                }
                if (teamInfo != null) {
                    report.setCheckUserId(teamInfo.getIncharge());
                    report.setCheckUserName(teamInfo.getInchargeName());
                }
                report.setWeekId(cal.getWeekId());
                List checkReports = ((RdmWeeklyInfoRepository)this.getRepository()).queryListByPage((Object)report);
                if (CollectionUtils.isNotEmpty((Collection)checkReports)) {
                    if (StringUtils.equals((CharSequence)overrideFlag, (CharSequence)YesOrNO.YES.getCode())) {
                        ((RdmWeeklyInfoRepository)this.getRepository()).deleteByPk(checkReports.get(0));
                        RdmWeeklyTaskDO deleteParam = new RdmWeeklyTaskDO();
                        deleteParam.setReportId(((RdmWeeklyInfoDO)checkReports.get(0)).getReportId());
                        this.rdmWeeklyTaskRepository.deleteByCond(deleteParam);
                        RdmWeeklyIssueDO deleteIssueParam = new RdmWeeklyIssueDO();
                        deleteIssueParam.setReportId(((RdmWeeklyInfoDO)checkReports.get(0)).getReportId());
                        this.rdmWeeklyIssueRepository.deleteByCond(deleteIssueParam);
                    } else {
                        initRepoortList.add(checkReports.get(0));
                        if (!StringUtils.equalsIgnoreCase((CharSequence)genOption, (CharSequence)"auto")) continue;
                        ((RdmWeeklyInfoDO)checkReports.get(0)).setReportState(ReportState.Submitted.getCode());
                        ((RdmWeeklyInfoRepository)this.getRepository()).updateByPk(checkReports.get(0));
                        continue;
                    }
                }
                report.setReportId(UUIDUtil.getUUID());
                if (StringUtils.equalsIgnoreCase((CharSequence)genOption, (CharSequence)"auto")) {
                    report.setReportState(ReportState.Submitted.getCode());
                } else {
                    report.setReportState(ReportState.Draft.getCode());
                }
                reportList.add(report);
                initRepoortList.add(report);
            }
            if (reportList.size() > 0) {
                output = ((RdmWeeklyInfoRepository)this.getRepository()).batchInsert(reportList);
            }
            if (CollectionUtils.isNotEmpty(initRepoortList)) {
                for (RdmWeeklyInfoDO reportInfo : initRepoortList) {
                    RdmWeeklyTaskDO reportInitParam = new RdmWeeklyTaskDO();
                    reportInitParam.setReportId(reportInfo.getReportId());
                    this.rdmWeeklyTaskRepository.autoFillWeekTask(reportInitParam);
                    RdmWeeklyIssueDO weeklyIssueDO = new RdmWeeklyIssueDO();
                    weeklyIssueDO.setReportId(reportInfo.getReportId());
                    this.rdmWeeklyIssueRepository.autoFillWeekIssue(weeklyIssueDO);
                }
            }
            output = initRepoortList.size();
        }
        return output;
    }

    public Integer autoFillWeek(RdmWeeklyInfoDTO rdmWeeklyInfoDTO) {
        int output = 0;
        if (rdmWeeklyInfoDTO.getTaskFlag() != null && rdmWeeklyInfoDTO.getTaskFlag().booleanValue()) {
            RdmWeeklyTaskDO reportInitParam = new RdmWeeklyTaskDO();
            reportInitParam.setReportId(rdmWeeklyInfoDTO.getReportId());
            output += this.rdmWeeklyTaskRepository.autoFillWeekTask(reportInitParam);
        }
        if (rdmWeeklyInfoDTO.getIssueFlag() != null && rdmWeeklyInfoDTO.getIssueFlag().booleanValue()) {
            RdmWeeklyIssueDO weeklyIssueDO = new RdmWeeklyIssueDO();
            weeklyIssueDO.setReportId(rdmWeeklyInfoDTO.getReportId());
            output += this.rdmWeeklyIssueRepository.autoFillWeekIssue(weeklyIssueDO);
        }
        return output;
    }
}

