/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dam.console.application.service.impl;

import com.irdstudio.allinrdm.dam.console.acl.repository.DictItemInfoRepository;
import com.irdstudio.allinrdm.dam.console.acl.repository.DictOptionEnumRepository;
import com.irdstudio.allinrdm.dam.console.acl.repository.DictOptionInfoRepository;
import com.irdstudio.allinrdm.dam.console.acl.repository.DictWordInfoRepository;
import com.irdstudio.allinrdm.dam.console.application.service.utils.PinYinUtil;
import com.irdstudio.allinrdm.dam.console.domain.entity.DictOptionEnumDO;
import com.irdstudio.allinrdm.dam.console.domain.entity.DictOptionInfoDO;
import com.irdstudio.allinrdm.dam.console.domain.entity.DictWordInfoDO;
import com.irdstudio.allinrdm.dam.console.facade.DictOptionEnumService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableFieldService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableInfoService;
import com.irdstudio.allinrdm.dam.console.facade.dto.DictOptionEnumDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableFieldDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.SDicDTO;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="dictOptionEnumService")
public class DictOptionEnumServiceImpl
extends BaseServiceImpl<DictOptionEnumDTO, DictOptionEnumDO, DictOptionEnumRepository>
implements DictOptionEnumService {
    @Autowired
    private ModelTableInfoService modelTableInfoService;
    @Autowired
    private ModelTableFieldService modelTableFieldService;
    @Autowired
    private DictItemInfoRepository dictItemInfoRepository;
    @Autowired
    private DictOptionInfoRepository dictOptionInfoRepository;
    @Autowired
    private DictWordInfoRepository dictWordInfoRepository;

    public List<DictOptionEnumDTO> queryAllByDictId(String dictId) {
        List dictOptionEnums = ((DictOptionEnumRepository)this.getRepository()).queryAllByDictId(dictId);
        List list = Collections.emptyList();
        try {
            list = this.beansCopy(dictOptionEnums, DictOptionEnumDTO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public int deleteByDictId(String dictId) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + dictId);
        int num = 0;
        try {
            num = ((DictOptionEnumRepository)this.getRepository()).deleteByDictId(dictId);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + dictId + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    public List<SDicDTO> queryModelTableFieldDicts(String fieldId) {
        ModelTableFieldDTO fieldParam = new ModelTableFieldDTO();
        fieldParam.setFieldId(fieldId);
        ModelTableFieldDTO field = (ModelTableFieldDTO)this.modelTableFieldService.queryByPk((Object)fieldParam);
        return this.queryModelTableFieldDicts(field);
    }

    public List<SDicDTO> queryModelTableAllDicts(String tableObjectId) {
        ModelTableFieldDTO fieldParam = new ModelTableFieldDTO();
        fieldParam.setObjectId(tableObjectId);
        List fieldList = this.modelTableFieldService.queryList((Object)fieldParam);
        if (CollectionUtils.isEmpty((Collection)fieldList)) {
            return Collections.emptyList();
        }
        ArrayList<SDicDTO> result = new ArrayList<SDicDTO>();
        for (ModelTableFieldDTO field : fieldList) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)field.getFieldOption())) continue;
            result.addAll(this.queryModelTableFieldDicts(field));
        }
        return result;
    }

    public int formatOptionEnumEmpty() {
        int num = 0;
        DictOptionInfoDO optionParam = new DictOptionInfoDO();
        optionParam.setSize(Integer.valueOf(Integer.MAX_VALUE));
        List optionList = this.dictOptionInfoRepository.queryList((Object)optionParam);
        Pattern pattern = Pattern.compile("^[a-zA-Z\\$\\_][a-zA-Z\\$\\_0-9]{1,39}");
        if (CollectionUtils.isNotEmpty((Collection)optionList)) {
            for (DictOptionInfoDO option : optionList) {
                List enumList = ((DictOptionEnumRepository)this.getRepository()).queryAllByDictId(option.getDictId());
                if (CollectionUtils.isEmpty((Collection)enumList)) continue;
                HashMap<String, DictOptionEnumDO> enumMap = new HashMap<String, DictOptionEnumDO>();
                ArrayList<DictOptionEnumDO> updateList = new ArrayList<DictOptionEnumDO>();
                for (DictOptionEnumDO de : enumList) {
                    Matcher m;
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)de.getOptionEnum()) && (m = pattern.matcher(de.getOptionEnum())).matches()) continue;
                    try {
                        String optionName = de.getOptionName();
                        String formatName = "";
                        String pyEnum = PinYinUtil.getPinYinHeadChar(optionName);
                        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)pyEnum)) {
                            formatName = org.apache.commons.lang3.StringUtils.upperCase((String)pyEnum);
                        } else {
                            String wordEnum = this.getNewFieldCodeByCnName(optionName);
                            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)wordEnum)) continue;
                            formatName = org.apache.commons.lang3.StringUtils.upperCase((String)wordEnum);
                        }
                        formatName = PinYinUtil.wrapperStr(formatName);
                        de.setOptionEnum(formatName);
                        if (enumMap.get(formatName) != null) {
                            de.setOptionEnum(String.format("%s%s", formatName, de.getOptionCode()));
                        }
                        enumMap.put(formatName, de);
                        updateList.add(de);
                    }
                    catch (Exception e) {
                        logger.error("\u683c\u5f0f\u5316\u5f02\u5e38", (Throwable)e);
                    }
                }
                for (DictOptionEnumDO de : updateList) {
                    ((DictOptionEnumRepository)this.getRepository()).updateByPk((Object)de);
                }
            }
        }
        return num;
    }

    private String getNewFieldCodeByCnName(String fieldName) {
        String newFieldCode = null;
        if (StringUtils.isBlank((String)fieldName)) {
            return newFieldCode;
        }
        String currentName = fieldName;
        int strLen = fieldName.length();
        int currentIdx = strLen - 1;
        ArrayList<String> findWords = new ArrayList<String>(strLen);
        if (currentIdx > 0) {
            List words;
            int currentLen = currentName.length();
            ArrayList<String> itemNames = new ArrayList<String>(currentLen);
            for (int i = 0; i < currentLen; ++i) {
                itemNames.add(StringUtils.substring((String)currentName, (int)i, (int)currentLen));
            }
            if (!itemNames.isEmpty() && CollectionUtils.isNotEmpty((Collection)(words = this.dictWordInfoRepository.queryByCNNames(itemNames)))) {
                words.sort(new Comparator<DictWordInfoDO>(){

                    @Override
                    public int compare(DictWordInfoDO o1, DictWordInfoDO o2) {
                        return Integer.compare(o1.getWordCnDesc().length(), o2.getWordCnDesc().length()) * -1;
                    }
                });
                DictWordInfoDO word = (DictWordInfoDO)words.get(0);
                if (word.getWordCnDesc().length() == currentLen) {
                    findWords.add(word.getWordEnDesc());
                }
            }
        }
        StringBuffer newFieldCodeBf = new StringBuffer();
        for (int i = findWords.size() - 1; i >= 0; --i) {
            newFieldCodeBf.append((String)findWords.get(i));
            if (i <= 0) continue;
            newFieldCodeBf.append("_");
        }
        newFieldCode = newFieldCodeBf.toString();
        return newFieldCode;
    }

    private List<SDicDTO> queryModelTableFieldDicts(ModelTableFieldDTO field) {
        if (Objects.isNull(field) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)field.getDictId())) {
            return Collections.emptyList();
        }
        DictOptionInfoDO optionParam = new DictOptionInfoDO();
        optionParam.setDictId(field.getDictId());
        DictOptionInfoDO optionInfo = (DictOptionInfoDO)this.dictOptionInfoRepository.queryByPk((Object)optionParam);
        if (Objects.isNull(optionInfo) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)optionInfo.getDictId())) {
            return Collections.emptyList();
        }
        DictOptionEnumDO enumParam = new DictOptionEnumDO();
        enumParam.setDictId(optionInfo.getDictId());
        List enumList = ((DictOptionEnumRepository)this.getRepository()).queryAllByDictId(optionInfo.getDictId());
        if (CollectionUtils.isEmpty((Collection)enumList)) {
            return Collections.emptyList();
        }
        ArrayList<SDicDTO> result = new ArrayList<SDicDTO>(enumList.size());
        String opttype = optionInfo.getDictCode().toUpperCase();
        String memo = optionInfo.getDictName();
        for (DictOptionEnumDO dict : enumList) {
            SDicDTO vo = new SDicDTO();
            vo.setOpttype(opttype);
            vo.setMemo(memo);
            vo.setEnname(dict.getOptionCode());
            vo.setCnname(dict.getOptionName());
            result.add(vo);
        }
        return result;
    }

    public List<DictOptionEnumDTO> queryAllOptionForExcel(DictOptionEnumDTO dictOptionEnum) {
        DictOptionEnumDO dictOptionEnumDO = new DictOptionEnumDO();
        this.beanCopy(dictOptionEnum, dictOptionEnumDO);
        List list = ((DictOptionEnumRepository)this.getRepository()).queryAllOptionForExcel(dictOptionEnumDO);
        try {
            return this.beansCopy(list, DictOptionEnumDTO.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<DictOptionEnumDTO> queryAppDictOptionList(DictOptionEnumDTO dictOptionEnum) {
        DictOptionEnumDO dictOptionEnumDO = new DictOptionEnumDO();
        this.beanCopy(dictOptionEnum, dictOptionEnumDO);
        List dictList = ((DictOptionEnumRepository)this.getRepository()).queryAllByProjectIdByPage(dictOptionEnumDO);
        return this.beansCopy(dictList, DictOptionEnumDTO.class);
    }
}

