/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.application.service.impl;

import com.irdstudio.allinrdm.dev.console.acl.repository.AppResourceRepository;
import com.irdstudio.allinrdm.dev.console.acl.repository.AppResourceactionRepository;
import com.irdstudio.allinrdm.dev.console.domain.entity.AppResourceDO;
import com.irdstudio.allinrdm.dev.console.facade.AppResourceService;
import com.irdstudio.allinrdm.dev.console.facade.dto.AppResourceDTO;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="appResourceServiceImpl")
public class AppResourceServiceImpl
extends BaseServiceImpl<AppResourceDTO, AppResourceDO, AppResourceRepository>
implements AppResourceService {
    @Autowired
    private AppResourceactionRepository sResourceactionRepository;

    public int batchInsert(List<AppResourceDTO> list) {
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u4e3a:" + list.size());
        int num = 0;
        for (AppResourceDTO vo : list) {
            if (this.queryByPk((BaseInfo)vo) != null) {
                num += this.updateByPk((BaseInfo)vo);
                continue;
            }
            num += this.insert((BaseInfo)vo);
        }
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u6761\u6570\u4e3a:" + num);
        return num;
    }

    public int deleteByPk(AppResourceDTO inAppResourceVo) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + inAppResourceVo.toString());
        int num = 0;
        try {
            AppResourceDO sResource = new AppResourceDO();
            this.beanCopy(inAppResourceVo, sResource);
            num += ((AppResourceRepository)this.getRepository()).deleteByPk((Object)sResource);
            this.sResourceactionRepository.deleteByAppResourceId(sResource.getAppId(), sResource.getResourceid());
            num += this.recursionDeleteChildren(sResource.getAppId(), sResource.getResourceid());
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + inAppResourceVo + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    public int deleteByAppId(String appId) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + appId.toString());
        int num = 0;
        try {
            num += ((AppResourceRepository)this.getRepository()).deleteByAppId(appId);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + appId + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    private int recursionDeleteChildren(String appId, String parentId) {
        int num = 0;
        AppResourceDO param = new AppResourceDO();
        param.setParentid(parentId);
        param.setAppId(appId);
        List childrenList = ((AppResourceRepository)this.getRepository()).queryList((Object)param);
        if (CollectionUtils.isNotEmpty((Collection)childrenList)) {
            for (AppResourceDO child : childrenList) {
                num += ((AppResourceRepository)this.getRepository()).deleteByPk((Object)child);
                this.sResourceactionRepository.deleteByAppResourceId(child.getAppId(), child.getResourceid());
                num += this.recursionDeleteChildren(appId, child.getResourceid());
            }
        }
        return num;
    }

    public List<AppResourceDTO> getAllByParentId(String parentid) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + parentid);
        List sResources = ((AppResourceRepository)this.getRepository()).getAllByParentId(parentid);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + sResources.size());
        List list = Collections.emptyList();
        try {
            list = this.beansCopy(sResources, AppResourceDTO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public List<AppResourceDTO> queryAllByActorno(String actorno) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + actorno);
        List sResources = ((AppResourceRepository)this.getRepository()).queryAllByActorno(actorno);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + sResources.size());
        List list = Collections.emptyList();
        try {
            list = this.beansCopy(sResources, AppResourceDTO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }
}

