/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.application.service.task;

import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.allinapaas.quality.console.types.CheckResult;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableInfoService;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableInfoDTO;
import com.irdstudio.allinrdm.dev.console.application.service.task.DevFnCreateTaskImpl;
import com.irdstudio.allinrdm.dev.console.facade.FormDelCondService;
import com.irdstudio.allinrdm.dev.console.facade.FormModelApiService;
import com.irdstudio.allinrdm.dev.console.facade.FormModelFieldService;
import com.irdstudio.allinrdm.dev.console.facade.FormModelInfoService;
import com.irdstudio.allinrdm.dev.console.facade.FormModelRefactorService;
import com.irdstudio.allinrdm.dev.console.facade.FormModelValidateService;
import com.irdstudio.allinrdm.dev.console.facade.dto.CodeTemplateData;
import com.irdstudio.allinrdm.dev.console.facade.dto.CodeTemplateMethod;
import com.irdstudio.allinrdm.dev.console.facade.dto.CodeTemplateMethodInput;
import com.irdstudio.allinrdm.dev.console.facade.dto.CodeTemplateMethodInvoke;
import com.irdstudio.allinrdm.dev.console.facade.dto.CodeTemplateMethodReturn;
import com.irdstudio.allinrdm.dev.console.facade.dto.CodeTemplateMethodValid;
import com.irdstudio.allinrdm.dev.console.facade.dto.CodeTemplateSqlCond;
import com.irdstudio.allinrdm.dev.console.facade.dto.FormDelCondDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.FormListFieldDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.FormModelApiDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.FormModelFieldDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.FormModelInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.FormModelRefactorDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.FormModelValidateDTO;
import com.irdstudio.allinrdm.dev.console.types.CondCompareSign;
import com.irdstudio.allinrdm.dev.console.types.CondLogicRelation;
import com.irdstudio.allinrdm.dev.console.types.FieldEvalWay;
import com.irdstudio.allinrdm.dev.console.types.RefactorType;
import com.irdstudio.allinrdm.dev.console.types.SrvModelTypeEnum;
import com.irdstudio.allinrdm.sam.console.facade.FnValidateInfoService;
import com.irdstudio.allinrdm.sam.console.facade.dto.FnModelInfoDTO;
import com.irdstudio.allinrdm.sam.console.facade.dto.FnValidateInfoDTO;
import com.irdstudio.allinrdm.sam.console.types.FnType;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.TmModelUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="DevFnRemoveTaskImpl")
public class DevFnRemoveTaskImpl
extends DevFnCreateTaskImpl {
    @Autowired
    private ModelTableInfoService modelTableInfoService;
    @Autowired
    private FormModelFieldService formModelFieldService;
    @Autowired
    private FormModelValidateService formModelValidateService;
    @Autowired
    private FormDelCondService formDelCondService;
    @Autowired
    private FormModelApiService formModelApiService;
    @Autowired
    private FormModelInfoService formModelInfoService;
    @Autowired
    private FormModelRefactorService formModelRefactorService;

    @Override
    public boolean create(FnModelInfoDTO fnModelInfo, boolean reCreateFlag, Map<String, Object> params) {
        boolean flag = true;
        if (StringUtils.isNotBlank((CharSequence)fnModelInfo.getFormId())) {
            flag = this.initFormData(fnModelInfo, reCreateFlag);
        } else {
            fnModelInfo.setDataModels(Arrays.asList(SrvModelTypeEnum.DELETE_BY_PK.getType()));
            FnType fnTypeEnum = FnType.get((String)fnModelInfo.getFnType2());
            flag = this.initSrvData(fnModelInfo);
        }
        return flag;
    }

    @Override
    protected boolean initFormData(FnModelInfoDTO fnModelInfo, boolean reCreateFlag) {
        boolean flag = true;
        ModelTableInfoDTO tableModelInfo = new ModelTableInfoDTO();
        tableModelInfo.setObjectId(fnModelInfo.getTableModelId());
        tableModelInfo = (ModelTableInfoDTO)this.modelTableInfoService.queryByPk((Object)tableModelInfo);
        FormModelFieldDTO modelFieldParam = new FormModelFieldDTO();
        modelFieldParam.setFormId(fnModelInfo.getFormId());
        List formFieldList = this.formModelFieldService.queryList((Object)modelFieldParam);
        String fnId = fnModelInfo.getFnId();
        String formId = fnModelInfo.getFormId();
        String formCode = fnModelInfo.getFormCode();
        String appId = fnModelInfo.getAppId();
        String comId = fnModelInfo.getComId();
        String subsId = fnModelInfo.getSubsId();
        String userId = fnModelInfo.getLoginUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        if (CollectionUtils.isNotEmpty((Collection)formFieldList)) {
            ArrayList formDelCondList = new ArrayList(formFieldList.size());
            formFieldList.forEach(formField -> {
                if (YesOrNO.YES.getCode().equals(formField.getIsPk())) {
                    FormDelCondDTO delCond = new FormDelCondDTO();
                    delCond.setRecordKeyid(UUIDUtil.getUUID());
                    delCond.setFormId(formId);
                    delCond.setFnId(fnId);
                    delCond.setFormFieldId(formField.getFormFieldId());
                    delCond.setFormFieldCode(formField.getFieldCode());
                    delCond.setFormFieldName(formField.getFieldName());
                    delCond.setCondLogicRelation(CondLogicRelation.AND.getCode());
                    delCond.setCondCompareSign(CondCompareSign.E.getCode());
                    delCond.setFieldEvalWay(FieldEvalWay.ASSIGN.getCode());
                    delCond.setEvalContent(formField.getFieldCode());
                    delCond.setEvalDesc(formField.getFieldName());
                    delCond.setDomainFieldId(formField.getFieldId());
                    delCond.setDomainFieldCode(formField.getFieldCode());
                    delCond.setDomainFieldName(formField.getFieldName());
                    formDelCondList.add(delCond);
                }
            });
            this.formDelCondService.batchInsert(formDelCondList);
        }
        FormModelApiDTO formDeleteApi = new FormModelApiDTO();
        formDeleteApi.setApiId(UUIDUtil.getUUID());
        formDeleteApi.setApiName(fnModelInfo.getFnType2Name().replace("\u529f\u80fd", "").replace("\u8868\u5355", "") + "\u63a5\u53e3");
        String InsertSingleUrlAfterStr = "/" + SrvModelTypeEnum.DELETE_BY_PK.getCode();
        String url = String.format("/api/%s%s", TmModelUtil.tableCodeToClassName((String)formCode), InsertSingleUrlAfterStr);
        formDeleteApi.setApiUrl(url);
        formDeleteApi.setFormId(formId);
        formDeleteApi.setFnId(fnId);
        formDeleteApi.setApiDesc(fnModelInfo.getFnType2Name().replace("\u529f\u80fd", "").replace("\u8868\u5355", "") + "\u63a5\u53e3");
        this.formModelApiService.insert((Object)formDeleteApi);
        return flag;
    }

    @Override
    public boolean refactor(FnModelInfoDTO fnModelInfo) {
        String fnId = fnModelInfo.getFnId();
        String formId = fnModelInfo.getFormId();
        String userId = fnModelInfo.getLoginUserId();
        FormModelRefactorDTO refactorParam = new FormModelRefactorDTO();
        refactorParam.setFormId(formId);
        refactorParam.setRefactorFlag(YesOrNO.YES.getCode());
        List refactorList = this.formModelRefactorService.queryList((Object)refactorParam);
        if (CollectionUtils.isNotEmpty((Collection)refactorList)) {
            for (FormModelRefactorDTO reField : refactorList) {
                FormListFieldDTO formField;
                if (StringUtils.equals((CharSequence)reField.getRefactorType(), (CharSequence)RefactorType.Add.getCode())) {
                    formField = new FormListFieldDTO();
                    formField.setFormFieldId(reField.getFormFieldId());
                    if ((formField = (FormModelFieldDTO)this.formModelFieldService.queryByPk((Object)formField)) == null || !YesOrNO.YES.getCode().equals(formField.getIsPk())) continue;
                    FormDelCondDTO delCond = new FormDelCondDTO();
                    delCond.setRecordKeyid(UUIDUtil.getUUID());
                    delCond.setFormId(formId);
                    delCond.setFnId(fnId);
                    delCond.setFormFieldId(formField.getFormFieldId());
                    delCond.setFormFieldCode(formField.getFieldCode());
                    delCond.setFormFieldName(formField.getFieldName());
                    delCond.setCondLogicRelation(CondLogicRelation.AND.getCode());
                    delCond.setCondCompareSign(CondCompareSign.E.getCode());
                    delCond.setFieldEvalWay(FieldEvalWay.ASSIGN.getCode());
                    delCond.setEvalContent(formField.getFieldCode());
                    delCond.setEvalDesc(formField.getFieldName());
                    delCond.setDomainFieldId(formField.getFieldId());
                    delCond.setDomainFieldCode(formField.getFieldCode());
                    delCond.setDomainFieldName(formField.getFieldName());
                    this.formDelCondService.insert((Object)delCond);
                    continue;
                }
                if (StringUtils.equals((CharSequence)reField.getRefactorType(), (CharSequence)RefactorType.Update.getCode())) {
                    formField = new FormListFieldDTO();
                    formField.setFormFieldId(reField.getFormFieldId());
                    formField = (FormModelFieldDTO)this.formModelFieldService.queryByPk((Object)formField);
                    FormDelCondDTO delCondParam = new FormDelCondDTO();
                    delCondParam.setFormFieldId(formField.getFormFieldId());
                    delCondParam.setFormId(formId);
                    List delConds = this.formDelCondService.queryListByPage((Object)delCondParam);
                    if (!CollectionUtils.isNotEmpty((Collection)delConds)) continue;
                    for (FormDelCondDTO delCond : delConds) {
                        delCond.setFormId(formId);
                        delCond.setFnId(fnId);
                        delCond.setFormFieldId(formField.getFormFieldId());
                        delCond.setFormFieldCode(formField.getFieldCode());
                        delCond.setFormFieldName(formField.getFieldName());
                        delCond.setCondLogicRelation(CondLogicRelation.AND.getCode());
                        delCond.setCondCompareSign(CondCompareSign.E.getCode());
                        delCond.setFieldEvalWay(FieldEvalWay.ASSIGN.getCode());
                        delCond.setEvalContent(formField.getFieldCode());
                        delCond.setEvalDesc(formField.getFieldName());
                        delCond.setDomainFieldId(formField.getFieldId());
                        delCond.setDomainFieldCode(formField.getFieldCode());
                        delCond.setDomainFieldName(formField.getFieldName());
                        this.formDelCondService.updateByPk((Object)delCond);
                    }
                    continue;
                }
                if (!StringUtils.equals((CharSequence)reField.getRefactorType(), (CharSequence)RefactorType.Delete.getCode())) continue;
                FormDelCondDTO delCondParam = new FormDelCondDTO();
                delCondParam.setFormFieldId(reField.getFormFieldId());
                delCondParam.setFormId(formId);
                List delConds = this.formDelCondService.queryListByPage((Object)delCondParam);
                if (!CollectionUtils.isNotEmpty((Collection)delConds)) continue;
                for (FormDelCondDTO delCond : delConds) {
                    this.formDelCondService.deleteByPk((Object)delCond);
                }
            }
        }
        return true;
    }

    @Override
    public boolean delete(FnModelInfoDTO fnModelInfo) {
        if (StringUtils.isNotBlank((CharSequence)fnModelInfo.getFormId())) {
            String formId = fnModelInfo.getFormId();
            this.formDelCondService.deleteByFnId(formId, fnModelInfo.getFnId());
            this.formModelValidateService.deleteByFnId(formId, fnModelInfo.getFnId());
            this.formModelApiService.deleteByFnId(formId, fnModelInfo.getFnId());
        } else {
            super.delete(fnModelInfo);
        }
        return true;
    }

    @Override
    public List<String> validate(FnModelInfoDTO fnModelInfo) {
        if (StringUtils.isNotBlank((CharSequence)fnModelInfo.getFormId())) {
            FnValidateInfoService fnValidateService = (FnValidateInfoService)SpringContextUtils.getBean(FnValidateInfoService.class);
            ArrayList<FnValidateInfoDTO> validList = new ArrayList<FnValidateInfoDTO>();
            HashMap<String, FnValidateInfoDTO> validMap = new HashMap<String, FnValidateInfoDTO>();
            ArrayList<String> failureMessageList = new ArrayList<String>();
            String formId = fnModelInfo.getFormId();
            String fnId = fnModelInfo.getFnId();
            List<String> validTypes = Arrays.asList("dcond");
            for (String type : validTypes) {
                FnValidateInfoDTO valid = new FnValidateInfoDTO();
                valid.setRecordKeyid(UUIDUtil.getUUID());
                valid.setFnId(fnModelInfo.getFnId());
                valid.setFormId(formId);
                valid.setValidId(formId);
                valid.setCreateUser(fnModelInfo.getLoginUserId());
                valid.setCreateTime(CurrentDateUtil.getTodayDateEx2());
                valid.setValidType(type);
                validList.add(valid);
                validMap.put(type, valid);
            }
            if (CollectionUtils.isNotEmpty(validList)) {
                fnValidateService.batchInsert(validList);
            }
            FormDelCondDTO delCond = new FormDelCondDTO();
            delCond.setFormId(formId);
            delCond.setFnId(fnId);
            List addFieldList = this.formDelCondService.queryList((Object)delCond);
            FnValidateInfoDTO dcond = (FnValidateInfoDTO)validMap.get("dcond");
            for (FormDelCondDTO viewF : addFieldList) {
                if (!CollectionUtils.isNotEmpty((Collection)viewF.validate())) continue;
                dcond.setValidRe(CheckResult.Fail.getCode());
                dcond.setValidTime(CurrentDateUtil.getTodayDateEx2());
                dcond.setValidMsg("\u8868\u5355\u67e5\u770b\u5c55\u793a\u6821\u9a8c\u4e0d\u901a\u8fc7");
                failureMessageList.add(dcond.getValidMsg());
                break;
            }
            if (StringUtils.isBlank((CharSequence)dcond.getValidRe())) {
                dcond.setValidRe(CheckResult.Pass.getCode());
                dcond.setValidTime(CurrentDateUtil.getTodayDateEx2());
            }
            fnValidateService.updateByPk((Object)dcond);
            return failureMessageList;
        }
        return super.validate(fnModelInfo);
    }

    @Override
    public CodeTemplateData generate(FnModelInfoDTO fnModelInfo) {
        if (StringUtils.isNotBlank((CharSequence)fnModelInfo.getFormId())) {
            CodeTemplateData codeTemplateData = new CodeTemplateData();
            FormModelInfoDTO formModel = new FormModelInfoDTO();
            formModel.setFormId(fnModelInfo.getFormId());
            formModel = (FormModelInfoDTO)this.formModelInfoService.queryByPk((Object)formModel);
            String tableModelId = formModel.getTableModelId();
            String tableModelCode = formModel.getTableModelCode();
            String tableModelName = formModel.getTableModelName();
            String appId = formModel.getAppId();
            String fnId = fnModelInfo.getFnId();
            String formId = fnModelInfo.getFormId();
            String formCode = fnModelInfo.getFormCode();
            String fnType2 = fnModelInfo.getFnType2();
            String userId = fnModelInfo.getLoginUserId();
            codeTemplateData.setPackageName(formModel.getFolderName());
            codeTemplateData.setClassName(TmModelUtil.tableCodeToClassName((String)formCode));
            codeTemplateData.setClassDesc(formModel.getFormName());
            codeTemplateData.setNowTime(CurrentDateUtil.getTodayDate());
            FormDelCondDTO delCondParam = new FormDelCondDTO();
            delCondParam.setFormId(formId);
            delCondParam.setFnId(fnId);
            List condList = this.formDelCondService.queryList((Object)delCondParam);
            if (CollectionUtils.isNotEmpty((Collection)condList)) {
                codeTemplateData.setSqlCondList(condList.stream().map(s -> {
                    CodeTemplateSqlCond sql = new CodeTemplateSqlCond();
                    BeanUtility.beanCopy((Object)s, (Object)sql);
                    return sql;
                }).collect(Collectors.toList()));
            }
            CodeTemplateMethod method = new CodeTemplateMethod();
            FormModelApiDTO formApi = new FormModelApiDTO();
            formApi.setFormId(formId);
            formApi.setApiName(fnModelInfo.getFnType2Name().replace("\u529f\u80fd", "").replace("\u8868\u5355", "") + "\u63a5\u53e3");
            List apiList = this.formModelApiService.queryListByPage((Object)formApi);
            if (CollectionUtils.isNotEmpty((Collection)apiList)) {
                formApi = (FormModelApiDTO)apiList.get(0);
                method.setRestfulUrl(StringUtils.replaceOnce((String)formApi.getApiUrl(), (String)("/" + fnModelInfo.getAppCode()), (String)""));
            }
            method.setMethodName(SrvModelTypeEnum.DELETE_BY_PK.getCode());
            if (StringUtils.isNotBlank((CharSequence)fnModelInfo.getFnDesc())) {
                method.setComment(fnModelInfo.getFnDesc());
            } else {
                method.setComment(fnModelInfo.getFnName());
            }
            FormModelValidateDTO validateParam = new FormModelValidateDTO();
            validateParam.setFormId(formId);
            validateParam.setFnId(fnId);
            List validateList = this.formModelValidateService.queryList((Object)validateParam);
            if (CollectionUtils.isNotEmpty((Collection)validateList)) {
                method.setValidList(validateList.stream().map(v -> {
                    CodeTemplateMethodValid valid = new CodeTemplateMethodValid();
                    BeanUtility.beanCopy((Object)v, (Object)valid);
                    return valid;
                }).collect(Collectors.toList()));
            }
            CodeTemplateMethodInput input = new CodeTemplateMethodInput();
            input.setClassType(TmModelUtil.tableCodeToClassName((String)formCode) + "DTO");
            input.setListFlag(YesOrNO.NO.getCode());
            input.setPropertyName("input");
            method.setInputType(input);
            CodeTemplateMethodInput output = new CodeTemplateMethodInput();
            output.setClassType("int");
            output.setListFlag(YesOrNO.NO.getCode());
            output.setPropertyName("output");
            method.setOutputType(output);
            CodeTemplateMethodInvoke invoke = new CodeTemplateMethodInvoke();
            invoke.setOutputType(output);
            invoke.setServiceName("super");
            invoke.setServiceMethod("deleteByPk");
            method.setInvoke(invoke);
            method.setResult(new CodeTemplateMethodReturn());
            codeTemplateData.setMethodList(Arrays.asList(method));
            return codeTemplateData;
        }
        return super.generate(fnModelInfo);
    }
}

