/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.project.console.application.service.impl;

import com.irdstudio.allinrdm.project.console.acl.repository.RdmObjectiveInfoRepository;
import com.irdstudio.allinrdm.project.console.domain.entity.RdmObjectiveInfoDO;
import com.irdstudio.allinrdm.project.console.facade.RdmObjectiveInfoService;
import com.irdstudio.allinrdm.project.console.facade.dto.RdmObjectiveInfoDTO;
import com.irdstudio.sdk.admin.service.dynamic.DynamicLog;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="rdmProjectObjectiveServiceImpl")
public class RdmObjectiveInfoServiceImpl
extends BaseServiceImpl<RdmObjectiveInfoDTO, RdmObjectiveInfoDO, RdmObjectiveInfoRepository>
implements RdmObjectiveInfoService {
    @DynamicLog(action=DynamicLog.Action.Add, dynamicType=DynamicLog.DynamicLogType.OKR, moduleCode="rdm", bizKey="${args[0].objectiveId}", text="${dynamicLog.action().getName()}\u4e86${#transformCode('ObjectiveCategory', dynamicLog.moduleCode(), args[0].objectiveCategory)} #${args[0].projectId} #${args[0].objectiveId} ${args[0].objectiveName}")
    public int insert(RdmObjectiveInfoDTO paramDO) {
        if (StringUtils.isNotBlank((CharSequence)paramDO.getObjectiveIncharge()) && StringUtils.isBlank((CharSequence)paramDO.getDispatcher())) {
            paramDO.setDispatcher(paramDO.getLoginUserId());
            paramDO.setDispatcherName(paramDO.getLoginUserName());
        }
        return super.insert((BaseInfo)paramDO);
    }

    @DynamicLog(action=DynamicLog.Action.Update, dynamicType=DynamicLog.DynamicLogType.OKR, moduleCode="rdm", bizKey="${args[0].objectiveId}")
    public int updateByPk(RdmObjectiveInfoDTO paramDO) {
        RdmObjectiveInfoDTO oldData = (RdmObjectiveInfoDTO)this.queryByPk((BaseInfo)paramDO);
        paramDO.setOldData((Object)oldData);
        if (StringUtils.isNotBlank((CharSequence)paramDO.getObjectiveIncharge()) && StringUtils.isBlank((CharSequence)paramDO.getDispatcher())) {
            paramDO.setDispatcher(paramDO.getLoginUserId());
            paramDO.setDispatcherName(paramDO.getLoginUserName());
        }
        return super.updateByPk((BaseInfo)paramDO);
    }

    @DynamicLog(action=DynamicLog.Action.Delete, dynamicType=DynamicLog.DynamicLogType.OKR, moduleCode="rdm", bizKey="${args[0].objectiveId}", text="${dynamicLog.action().getName()}\u4e86${#transformCode('ObjectiveCategory', dynamicLog.moduleCode(), args[0].objectiveCategory)} #${args[0].objectiveId} ${args[0].objectiveName}")
    public int deleteByPk(RdmObjectiveInfoDTO paramDO) {
        return super.deleteByPk((BaseInfo)paramDO);
    }

    public String queryMaxId(String projectId, String objectiveCategory) {
        if (StringUtils.isNotBlank((CharSequence)projectId)) {
            objectiveCategory = null;
        }
        String id = ((RdmObjectiveInfoRepository)this.getRepository()).queryMaxId(projectId, objectiveCategory);
        if (StringUtils.isNotBlank((CharSequence)projectId)) {
            if (StringUtils.isNotBlank((CharSequence)id)) {
                String numStr = StringUtils.replaceOnce((String)id, (String)projectId, (String)"");
                int num = NumberUtils.toInt((String)numStr, (int)0);
                return String.format("%s%s", projectId, StringUtils.leftPad((String)String.valueOf(num + 1), (int)4, (String)"0"));
            }
            return String.format("%s%s", projectId, StringUtils.leftPad((String)String.valueOf(1), (int)4, (String)"0"));
        }
        if (StringUtils.isNotBlank((CharSequence)id)) {
            String numStr = StringUtils.replaceOnce((String)id, (String)objectiveCategory, (String)"");
            int num = NumberUtils.toInt((String)numStr, (int)0);
            return String.format("%s%s", objectiveCategory, StringUtils.leftPad((String)String.valueOf(num + 1), (int)4, (String)"0"));
        }
        return String.format("%s%s", objectiveCategory, StringUtils.leftPad((String)String.valueOf(1), (int)4, (String)"0"));
    }

    public List<Map<String, Object>> queryObjectiveSummary(RdmObjectiveInfoDTO paramDTO) {
        RdmObjectiveInfoDO paramDO = (RdmObjectiveInfoDO)this.beanCopy(paramDTO, RdmObjectiveInfoDO.class);
        return ((RdmObjectiveInfoRepository)this.getRepository()).queryObjectiveSummary(paramDO);
    }

    public List<Map<String, Object>> queryOKRInchargeGroupByPage(RdmObjectiveInfoDTO paramDTO) {
        RdmObjectiveInfoDO paramDO = (RdmObjectiveInfoDO)this.beanCopy(paramDTO, RdmObjectiveInfoDO.class);
        return ((RdmObjectiveInfoRepository)this.getRepository()).queryOKRInchargeGroupByPage(paramDO);
    }

    public List<Map<String, Object>> queryRdmObjectiveWorkloadUserByPage(RdmObjectiveInfoDTO paramDTO) {
        RdmObjectiveInfoDO paramDO = (RdmObjectiveInfoDO)this.beanCopy(paramDTO, RdmObjectiveInfoDO.class);
        List result = ((RdmObjectiveInfoRepository)this.getRepository()).queryRdmObjectiveWorkloadUserByPage(paramDO);
        paramDTO.setTotal(paramDO.getTotal());
        return result;
    }

    public RdmObjectiveInfoDTO queryProjectObjectivePeriod(RdmObjectiveInfoDTO param) {
        RdmObjectiveInfoDO rdmObjectiveInfoDO = new RdmObjectiveInfoDO();
        this.beanCopy(param, rdmObjectiveInfoDO);
        RdmObjectiveInfoDO result = ((RdmObjectiveInfoRepository)this.getRepository()).queryProjectObjectivePeriod(rdmObjectiveInfoDO);
        return (RdmObjectiveInfoDTO)this.beanCopy(result, RdmObjectiveInfoDTO.class);
    }
}

