/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.project.console.application.service.impl;

import com.irdstudio.allinrdm.project.console.acl.repository.RdmRelationInfoRepository;
import com.irdstudio.allinrdm.project.console.acl.repository.RdmRequirementAttachRepository;
import com.irdstudio.allinrdm.project.console.acl.repository.RdmRequirementInfoRepository;
import com.irdstudio.allinrdm.project.console.acl.repository.RdmTagInfoRepository;
import com.irdstudio.allinrdm.project.console.domain.entity.RdmRequirementInfoDO;
import com.irdstudio.allinrdm.project.console.domain.entity.RdmTagInfoDO;
import com.irdstudio.allinrdm.project.console.facade.RdmRequirementInfoService;
import com.irdstudio.allinrdm.project.console.facade.dto.RdmRequirementInfoDTO;
import com.irdstudio.allinrdm.project.console.types.ReqSource;
import com.irdstudio.allinrdm.project.console.types.ReqStat;
import com.irdstudio.allinrdm.project.console.types.ReqType;
import com.irdstudio.allinrdm.project.console.types.TagCatalog;
import com.irdstudio.sdk.admin.service.dynamic.DynamicLog;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rdmRequirementInfoServiceImpl")
public class RdmRequirementInfoServiceImpl
extends BaseServiceImpl<RdmRequirementInfoDTO, RdmRequirementInfoDO, RdmRequirementInfoRepository>
implements RdmRequirementInfoService {
    private static Logger logger = LoggerFactory.getLogger(RdmRequirementInfoServiceImpl.class);
    @Autowired
    private RdmTagInfoRepository rdmTagInfoRepository;
    @Autowired
    protected RdmRequirementAttachRepository rdmRequirementAttachRepository;
    @Autowired
    protected RdmRelationInfoRepository rdmRelationInfoRepository;

    @DynamicLog(action=DynamicLog.Action.Add, dynamicType=DynamicLog.DynamicLogType.Requirement, moduleCode="rdm", bizKey="${args[0].reqId}", text="${dynamicLog.action().getName()}\u4e86${#transformCode('ReqCategory', dynamicLog.moduleCode(), args[0].reqCategory)} #${args[0].reqId} ${args[0].reqTitle}")
    public int insert(RdmRequirementInfoDTO paramDO) {
        if (StringUtils.isNotBlank((CharSequence)paramDO.getIncharge()) && StringUtils.isBlank((CharSequence)paramDO.getDispatcher())) {
            paramDO.setDispatcher(paramDO.getLoginUserId());
            paramDO.setDispatcherName(paramDO.getLoginUserName());
        }
        this.rdmRequirementAttachRepository.updateRefIdToNew(paramDO.getAll(), paramDO.getReqId());
        this.rdmRelationInfoRepository.updateByRelationId("reqId", paramDO.getAll(), paramDO.getReqId());
        return super.insert((BaseInfo)paramDO);
    }

    @DynamicLog(action=DynamicLog.Action.Update, dynamicType=DynamicLog.DynamicLogType.Requirement, moduleCode="rdm", bizKey="${args[0].reqId}")
    public int updateByPk(RdmRequirementInfoDTO paramDO) {
        RdmRequirementInfoDTO oldData = (RdmRequirementInfoDTO)this.queryByPk((BaseInfo)paramDO);
        paramDO.setOldData((Object)oldData);
        if (StringUtils.isNotBlank((CharSequence)paramDO.getIncharge()) && StringUtils.isBlank((CharSequence)paramDO.getDispatcher())) {
            paramDO.setDispatcher(paramDO.getLoginUserId());
            paramDO.setDispatcherName(paramDO.getLoginUserName());
        }
        return super.updateByPk((BaseInfo)paramDO);
    }

    @DynamicLog(action=DynamicLog.Action.Delete, dynamicType=DynamicLog.DynamicLogType.Requirement, moduleCode="rdm", bizKey="${args[0].reqId}", text="${dynamicLog.action().getName()}\u4e86${#transformCode('ReqCategory', dynamicLog.moduleCode(), args[0].reqCategory)} #${args[0].reqId} ${args[0].reqTitle}")
    public int deleteByPk(RdmRequirementInfoDTO paramDO) {
        return super.deleteByPk((BaseInfo)paramDO);
    }

    public int batchInsert(List<RdmRequirementInfoDTO> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            HashMap<String, RdmTagInfoDO> tagMap = new HashMap<String, RdmTagInfoDO>();
            int count = 0;
            Calendar now = Calendar.getInstance();
            ArrayList<Object> insertList = new ArrayList<Object>(list.size());
            for (RdmRequirementInfoDTO require : list) {
                String tagNames;
                if (StringUtils.isBlank((CharSequence)require.getReqStat())) {
                    require.setReqStat(ReqStat.codeByName((String)require.getReqStatName()));
                }
                if (StringUtils.isBlank((CharSequence)require.getReqSource())) {
                    require.setReqSource(ReqSource.codeByName((String)require.getReqSourceName()));
                }
                now.add(13, 1);
                require.setCreateUser(require.getLoginUserId());
                require.setLastUpdateUser(require.getLoginUserId());
                require.setCreateTime(DateFormatUtils.format((Calendar)now, (String)"yyyy-MM-dd HH:mm:ss"));
                require.setLastUpdateTime(require.getCreateTime());
                if (StringUtils.isBlank((CharSequence)require.getReqId())) {
                    require.setReqId(this.queryMaxId());
                }
                if (StringUtils.isNotBlank((CharSequence)(tagNames = require.getTagName()))) {
                    String[] tagNameList = StringUtils.split((String)tagNames, (String)",");
                    ArrayList<String> ids = new ArrayList<String>();
                    ArrayList<String> names = new ArrayList<String>();
                    for (String tagName : tagNameList) {
                        RdmTagInfoDO tag = (RdmTagInfoDO)tagMap.get(tagName);
                        if (tag == null) {
                            RdmTagInfoDO tagParam = new RdmTagInfoDO();
                            tagParam.setTagName(tagName);
                            tagParam.setTagCatalog(TagCatalog.Require.getCode());
                            List tagList = this.rdmTagInfoRepository.queryListByPage((Object)tagParam);
                            if (CollectionUtils.isNotEmpty((Collection)tagList)) {
                                tag = (RdmTagInfoDO)tagList.get(0);
                                tagMap.put(tagName, tag);
                            } else {
                                tag = new RdmTagInfoDO();
                                tag.setTagId(UUIDUtil.getUUID());
                                tag.setTagName(tagName);
                                tag.setTagCatalog(TagCatalog.Require.getCode());
                                tag.setCreateTime(require.getCreateTime());
                                tag.setLastUpdateTime(require.getCreateTime());
                                this.rdmTagInfoRepository.insert((Object)tag);
                                tagMap.put(tagName, tag);
                            }
                        }
                        ids.add(tag.getTagId());
                        names.add(tag.getTagName());
                    }
                    require.setTagId(StringUtils.join(ids, (String)","));
                    if (names.size() > 0) {
                        require.setTagName("," + StringUtils.join(names, (String)",") + ",");
                    }
                }
                insertList.add(this.beanCopy(require, RdmRequirementInfoDO.class));
            }
            count = ((RdmRequirementInfoRepository)this.getRepository()).batchInsert(insertList);
            return count;
        }
        return 0;
    }

    @DynamicLog(action=DynamicLog.Action.Delete, dynamicType=DynamicLog.DynamicLogType.Requirement, moduleCode="rdm")
    public int deleteByAll(RdmRequirementInfoDTO inRdmRequirementInfoDTO) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + inRdmRequirementInfoDTO);
        int num = 0;
        try {
            RdmRequirementInfoDO rdmRequirementInfo = new RdmRequirementInfoDO();
            this.beanCopy(inRdmRequirementInfoDTO, rdmRequirementInfo);
            num = ((RdmRequirementInfoRepository)this.getRepository()).deleteByAll(rdmRequirementInfo);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + inRdmRequirementInfoDTO + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    public String queryMaxId() {
        return ((RdmRequirementInfoRepository)this.getRepository()).queryMaxId();
    }

    public List<RdmRequirementInfoDTO> queryList(RdmRequirementInfoDTO paramDO) {
        List dtoList = super.queryList((BaseInfo)paramDO);
        dtoList.stream().forEach(req -> {
            req.setReqStatName(ReqStat.nameByCode((String)req.getReqStat()));
            req.setReqSourceName(ReqSource.nameByCode((String)req.getReqSource()));
            req.setReqTypeName(ReqType.nameByCode((String)req.getReqType()));
        });
        return dtoList;
    }

    public List<Map<String, Object>> queryRequirementSummary(RdmRequirementInfoDTO paramDTO) {
        RdmRequirementInfoDO paramDO = (RdmRequirementInfoDO)this.beanCopy(paramDTO, RdmRequirementInfoDO.class);
        return ((RdmRequirementInfoRepository)this.getRepository()).queryRequirementSummary(paramDO);
    }

    public List<Map<String, Object>> queryRdmProjectSummaryByPage(RdmRequirementInfoDTO paramDTO) {
        RdmRequirementInfoDO paramDO = (RdmRequirementInfoDO)this.beanCopy(paramDTO, RdmRequirementInfoDO.class);
        return ((RdmRequirementInfoRepository)this.getRepository()).queryRdmProjectSummaryByPage(paramDO);
    }

    public List<Map<String, Object>> queryRdmInchargeGroupByPage(RdmRequirementInfoDTO paramDTO) {
        RdmRequirementInfoDO paramDO = (RdmRequirementInfoDO)this.beanCopy(paramDTO, RdmRequirementInfoDO.class);
        return ((RdmRequirementInfoRepository)this.getRepository()).queryRdmInchargeGroupByPage(paramDO);
    }

    public List<Map<String, Object>> queryRdmReqInchargeGroupByPage(RdmRequirementInfoDTO paramDTO) {
        RdmRequirementInfoDO paramDO = (RdmRequirementInfoDO)this.beanCopy(paramDTO, RdmRequirementInfoDO.class);
        List result = ((RdmRequirementInfoRepository)this.getRepository()).queryRdmReqInchargeGroupByPage(paramDO);
        paramDTO.setTotal(paramDO.getTotal());
        return result;
    }
}

