/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.sam.console.application.service.impl;

import com.irdstudio.allinrdm.dev.console.acl.repository.FnTypeInfoRepository;
import com.irdstudio.allinrdm.project.console.acl.repository.RdmRelationInfoRepository;
import com.irdstudio.allinrdm.project.console.application.service.utils.Pinyin4jUtil;
import com.irdstudio.allinrdm.sam.console.acl.repository.FnBaseAttachRepository;
import com.irdstudio.allinrdm.sam.console.acl.repository.FnBaseInfoRepository;
import com.irdstudio.allinrdm.sam.console.domain.entity.FnBaseInfoDO;
import com.irdstudio.allinrdm.sam.console.facade.FnBaseInfoService;
import com.irdstudio.allinrdm.sam.console.facade.dto.FnBaseInfoDTO;
import com.irdstudio.allintcp.sdk.bi.acl.repository.RdmModuleInfoRepository;
import com.irdstudio.allintcp.sdk.bi.domain.entity.RdmModuleInfoDO;
import com.irdstudio.allintcp.sdk.sequence.facade.operation.SeqInstInfoService;
import com.irdstudio.sdk.admin.service.dynamic.DynamicLog;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="fnPointInfoServiceImpl")
public class FnBaseInfoServiceImpl
extends BaseServiceImpl<FnBaseInfoDTO, FnBaseInfoDO, FnBaseInfoRepository>
implements FnBaseInfoService {
    @Autowired
    protected RdmModuleInfoRepository rdmModuleInfoRepository;
    @Autowired
    protected FnTypeInfoRepository fnTypeInfoRepository;
    @Autowired
    protected FnBaseAttachRepository fnBaseAttachRepository;
    @Autowired
    protected RdmRelationInfoRepository rdmRelationInfoRepository;

    @DynamicLog(action=DynamicLog.Action.Add, dynamicType=DynamicLog.DynamicLogType.Fn, moduleCode="rdm", bizKey="${args[0].fpId}", text="${dynamicLog.action().getName()}\u4e86 #${args[0].fpId} ${args[0].fpName}")
    public int insert(FnBaseInfoDTO paramDTO) {
        this.fnBaseAttachRepository.updateRefIdToNew(paramDTO.getAll(), paramDTO.getBugId());
        this.rdmRelationInfoRepository.updateByRelationId("fpId", paramDTO.getAll(), paramDTO.getFpId());
        return super.insert((BaseInfo)paramDTO);
    }

    @DynamicLog(action=DynamicLog.Action.Update, dynamicType=DynamicLog.DynamicLogType.Fn, moduleCode="rdm", bizKey="${args[0].fpId}")
    public int updateByPk(FnBaseInfoDTO paramDTO) {
        FnBaseInfoDTO oldData = (FnBaseInfoDTO)this.queryByPk((BaseInfo)paramDTO);
        paramDTO.setOldData((Object)oldData);
        return super.updateByPk((BaseInfo)paramDTO);
    }

    @DynamicLog(action=DynamicLog.Action.Delete, dynamicType=DynamicLog.DynamicLogType.Fn, moduleCode="rdm", bizKey="${args[0].fpId}", text="${dynamicLog.action().getName()}\u4e86 #${args[0].fpId} ${args[0].fpName}")
    public int deleteByPk(FnBaseInfoDTO paramDTO) {
        return super.deleteByPk((BaseInfo)paramDTO);
    }

    public String queryMaxId() {
        return ((FnBaseInfoRepository)this.getRepository()).queryMaxId();
    }

    public int deleteByCond(FnBaseInfoDTO param) {
        FnBaseInfoDO fnPointInfoDO = new FnBaseInfoDO();
        this.beanCopy(param, fnPointInfoDO);
        return ((FnBaseInfoRepository)this.getRepository()).deleteByCond(fnPointInfoDO);
    }

    public int updateExcel(String userId, List<FnBaseInfoDTO> list) {
        String now = CurrentDateUtil.getTodayDateEx2();
        int outputVo = 0;
        for (FnBaseInfoDTO fnBase : list) {
            fnBase.setUpdateUser(userId);
            fnBase.setUpdateTime(now);
            int re = this.updateByPk(fnBase);
            if (re <= 0) continue;
            ++outputVo;
        }
        return outputVo;
    }

    public boolean saveExcel(String userId, String subsId, String subsName, String projectId, String projectName, String appId, String appName, String fnCategory, String excelUploadType, List<FnBaseInfoDTO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return true;
        }
        if (StringUtils.equals((CharSequence)excelUploadType, (CharSequence)"insert")) {
            FnBaseInfoDO deleteParam = new FnBaseInfoDO();
            deleteParam.setFpCategory(fnCategory);
            deleteParam.setSubsId(subsId);
            deleteParam.setProjectId(projectId);
            deleteParam.setAppId(appId);
        }
        String now = CurrentDateUtil.getTodayDateEx2();
        List moduleNames = list.stream().map(FnBaseInfoDTO::getModuleName).collect(Collectors.toList());
        HashMap<String, String> moduleIdMap = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(moduleNames)) {
            ArrayList<RdmModuleInfoDO> insertList = new ArrayList<RdmModuleInfoDO>();
            for (String moduleName : moduleNames) {
                if (moduleIdMap.get(moduleName) != null) continue;
                RdmModuleInfoDO moduleParam = new RdmModuleInfoDO();
                moduleParam.setModuleName(moduleName);
                List findList = this.rdmModuleInfoRepository.queryListByPage((Object)moduleParam);
                if (CollectionUtils.isNotEmpty((Collection)findList)) {
                    moduleIdMap.put(moduleName, ((RdmModuleInfoDO)findList.get(0)).getModuleId());
                    continue;
                }
                RdmModuleInfoDO newModule = new RdmModuleInfoDO();
                newModule.setModuleId(UUIDUtil.getShortUUID());
                newModule.setModuleCode(StringUtils.substring((String)Pinyin4jUtil.getFirstSpellPinYin(moduleName, true), (int)0, (int)32));
                newModule.setModuleName(moduleName);
                newModule.setModuleDesc(moduleName);
                newModule.setSubsId(subsId);
                newModule.setProjectId(projectId);
                newModule.setCreateUser(userId);
                newModule.setCreateTime(now);
                newModule.setUpdateUser(userId);
                newModule.setUpdateTime(now);
                insertList.add(newModule);
                moduleIdMap.put(moduleName, newModule.getModuleId());
            }
            if (CollectionUtils.isNotEmpty(insertList)) {
                this.rdmModuleInfoRepository.batchInsert(insertList);
            }
        }
        int recordNum = 0;
        ArrayList<FnBaseInfoDO> insertList = new ArrayList<FnBaseInfoDO>();
        SeqInstInfoService seqService = (SeqInstInfoService)SpringContextUtils.getBean(SeqInstInfoService.class);
        for (FnBaseInfoDTO fp : list) {
            FnBaseInfoDO fpDO = (FnBaseInfoDO)this.beanCopy(fp, FnBaseInfoDO.class);
            fpDO.setFpId(seqService.nextSequence("RDM-FNP-SEQ", fpDO.getProjectId()));
            fpDO.setCreateUser(userId);
            fpDO.setCreateTime(now);
            fpDO.setUpdateUser(userId);
            fpDO.setUpdateTime(now);
            if (StringUtils.isBlank((CharSequence)fpDO.getFpId())) {
                fpDO.setFpId(UUIDUtil.getShortUUID());
            }
            fpDO.setSubsId(subsId);
            fpDO.setSubsName(subsName);
            fpDO.setProjectId(projectId);
            fpDO.setProjectName(projectName);
            fpDO.setAppId(appId);
            fpDO.setAppName(appName);
            fpDO.setModuleId((String)moduleIdMap.get(fpDO.getModuleName()));
            insertList.add(fpDO);
        }
        recordNum = ((FnBaseInfoRepository)this.getRepository()).batchInsert(insertList);
        return recordNum > 0;
    }
}

