/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.sam.console.application.service.impl;

import com.irdstudio.allinrdm.sam.console.acl.repository.StdBaseInfoRepository;
import com.irdstudio.allinrdm.sam.console.acl.repository.StdFolderInfoRepository;
import com.irdstudio.allinrdm.sam.console.domain.entity.StdBaseInfoDO;
import com.irdstudio.allinrdm.sam.console.domain.entity.StdFolderInfoDO;
import com.irdstudio.allinrdm.sam.console.facade.StdBaseInfoService;
import com.irdstudio.allinrdm.sam.console.facade.StdRuleInfoService;
import com.irdstudio.allinrdm.sam.console.facade.dto.StdBaseInfoDTO;
import com.irdstudio.allinrdm.sam.console.facade.dto.StdRuleInfoDTO;
import com.irdstudio.allintcp.sdk.sequence.acl.repository.SeqInstInfoRepository;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="stdBaseInfoServiceImpl")
public class StdBaseInfoServiceImpl
extends BaseServiceImpl<StdBaseInfoDTO, StdBaseInfoDO, StdBaseInfoRepository>
implements StdBaseInfoService {
    @Autowired
    private SeqInstInfoRepository seqInstInfoRepository;
    @Autowired
    private StdRuleInfoService stdRuleInfoService;
    @Autowired
    private StdFolderInfoRepository stdFolderInfoRepository;

    public int insert(StdBaseInfoDTO paramDTO) {
        if (StringUtils.isBlank((CharSequence)paramDTO.getStdId())) {
            paramDTO.setStdId(this.seqInstInfoRepository.nextAndSave("STD-ID", "\u89c4\u8303\u7f16\u53f7", "00", "1", "99999", "1", "08", "0", "STD{{SEQ}}", "5", "Y", new String[0]));
        }
        return super.insert((BaseInfo)paramDTO);
    }

    public int deleteByCond(StdBaseInfoDTO param) {
        StdBaseInfoDO stdBaseInfoDO = new StdBaseInfoDO();
        this.beanCopy(param, stdBaseInfoDO);
        return ((StdBaseInfoRepository)this.getRepository()).deleteByCond(stdBaseInfoDO);
    }

    public int saveExcel(String userId, List<StdBaseInfoDTO> list, List<StdRuleInfoDTO> ruleList) {
        int outputVo = 0;
        String now = CurrentDateUtil.getTodayDateEx2();
        HashMap<String, StdBaseInfoDTO> baseMap = new HashMap<String, StdBaseInfoDTO>();
        if (CollectionUtils.isNotEmpty(list)) {
            StdFolderInfoDO folderParam = new StdFolderInfoDO();
            List folderList = this.stdFolderInfoRepository.queryList((Object)folderParam);
            Map folderMap = folderList.stream().collect(Collectors.toMap(StdFolderInfoDO::getFolderName, Function.identity()));
            ArrayList<StdFolderInfoDO> needToAddFolderList = new ArrayList<StdFolderInfoDO>();
            for (StdBaseInfoDTO base : list) {
                StdFolderInfoDO folder = (StdFolderInfoDO)folderMap.get(base.getFolderName());
                if (folder == null) {
                    folder = new StdFolderInfoDO();
                    folder.setFolderId(UUIDUtil.getShortUUID());
                    folder.setFolderName(base.getFolderName());
                    folder.setCreateUser(userId);
                    folder.setCreateTime(now);
                    folder.setLastModifyUser(userId);
                    folder.setLastModifyTime(now);
                    needToAddFolderList.add(folder);
                    folderMap.put(folder.getFolderName(), folder);
                }
                base.setFolderId(folder.getFolderId());
                base.setCreateUser(userId);
                base.setCreateTime(now);
                base.setLastModifyUser(userId);
                base.setLastModifyTime(now);
                int re = this.insert(base);
                if (re != 1) continue;
                ++outputVo;
                baseMap.put(base.getStdName(), base);
            }
            if (CollectionUtils.isNotEmpty(needToAddFolderList)) {
                this.stdFolderInfoRepository.batchInsert(needToAddFolderList);
            }
        }
        if (CollectionUtils.isNotEmpty(ruleList)) {
            for (StdRuleInfoDTO rule : ruleList) {
                StdBaseInfoDTO base = (StdBaseInfoDTO)baseMap.get(rule.getStdId());
                if (base == null) continue;
                rule.setStdId(base.getStdId());
                rule.setCreateUser(userId);
                rule.setCreateTime(now);
                rule.setLastModifyUser(userId);
                rule.setLastModifyTime(now);
                this.stdRuleInfoService.insert((Object)rule);
            }
        }
        return outputVo;
    }
}

