/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.sam.console.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsArtifactService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsArtifactDTO;
import com.irdstudio.allinrdm.dev.console.types.YesOrNO;
import com.irdstudio.allinrdm.sam.console.acl.repository.TclOpensourceInfoRepository;
import com.irdstudio.allinrdm.sam.console.acl.repository.TclOpensourceLicenseRepository;
import com.irdstudio.allinrdm.sam.console.acl.repository.TclOpensourceVersionRepository;
import com.irdstudio.allinrdm.sam.console.acl.repository.TclOpensourceVulRepository;
import com.irdstudio.allinrdm.sam.console.domain.entity.TclOpensourceInfoDO;
import com.irdstudio.allinrdm.sam.console.domain.entity.TclOpensourceLicenseDO;
import com.irdstudio.allinrdm.sam.console.domain.entity.TclOpensourceVersionDO;
import com.irdstudio.allinrdm.sam.console.domain.entity.TclOpensourceVulDO;
import com.irdstudio.allinrdm.sam.console.facade.TclOpensourceInfoService;
import com.irdstudio.allinrdm.sam.console.facade.dto.TclOpensourceInfoDTO;
import com.irdstudio.allinrdm.sam.console.types.VulRisk;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import com.irdstudio.sdk.beans.core.util.DateUtility;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="tclOpensourceInfoServiceImpl")
public class TclOpensourceInfoServiceImpl
extends BaseServiceImpl<TclOpensourceInfoDTO, TclOpensourceInfoDO, TclOpensourceInfoRepository>
implements TclOpensourceInfoService {
    @Autowired
    private PaasAppsArtifactService paasAppsArtifactService;
    @Autowired
    private TclOpensourceVersionRepository tclOpensourceVersionRepository;
    @Autowired
    private TclOpensourceLicenseRepository tclOpensourceLicenseRepository;
    @Autowired
    private TclOpensourceVulRepository tclOpensourceVulRepository;
    private HttpClient httpClient = HttpClients.createDefault();
    @Value(value="${chromium.webdriver:}")
    private String webDriver;

    public int insert(TclOpensourceInfoDTO paramDTO) {
        TclOpensourceInfoDO infoParam = new TclOpensourceInfoDO();
        infoParam.setGroupId(paramDTO.getGroupId());
        infoParam.setArtifactId(paramDTO.getArtifactId());
        List findInfoList = ((TclOpensourceInfoRepository)this.getRepository()).queryListByPage((Object)infoParam);
        if (CollectionUtils.isNotEmpty((Collection)findInfoList)) {
            TclOpensourceVersionDO versionInfo = new TclOpensourceVersionDO();
            this.beanCopy(paramDTO, versionInfo);
            versionInfo.setOpensourceId(((TclOpensourceInfoDO)findInfoList.get(0)).getOpensourceId());
            return this.tclOpensourceVersionRepository.insert((Object)versionInfo);
        }
        paramDTO.setOpensourceId(UUIDUtil.getShortUUID());
        TclOpensourceVersionDO versionInfo = new TclOpensourceVersionDO();
        this.beanCopy(paramDTO, versionInfo);
        this.tclOpensourceVersionRepository.insert((Object)versionInfo);
        return super.insert((BaseInfo)paramDTO);
    }

    public int updateByPk(TclOpensourceInfoDTO paramDTO) {
        TclOpensourceVersionDO versionInfo = new TclOpensourceVersionDO();
        this.beanCopy(paramDTO, versionInfo);
        this.tclOpensourceVersionRepository.updateByPk((Object)versionInfo);
        return super.updateByPk((BaseInfo)paramDTO);
    }

    public List<TclOpensourceInfoDTO> queryIndexListByPage(TclOpensourceInfoDTO param) {
        TclOpensourceInfoDO tclOpensourceInfoDO = new TclOpensourceInfoDO();
        this.beanCopy(param, tclOpensourceInfoDO);
        List list = ((TclOpensourceInfoRepository)this.getRepository()).queryIndexListByPage(tclOpensourceInfoDO);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (TclOpensourceInfoDO info : list) {
                PaasAppsArtifactDTO appParam = new PaasAppsArtifactDTO();
                appParam.setArtifactId(info.getArtifactId());
                appParam.setGroupId(info.getGroupId());
                appParam.setVersionId(info.getVersionId());
                List appList = this.paasAppsArtifactService.queryAppNameList(appParam);
                if (!CollectionUtils.isNotEmpty((Collection)appList)) continue;
                info.setAppGroupConcat(appList.stream().map(PaasAppsArtifactDTO::getAppName).collect(Collectors.joining(",")));
            }
        }
        param.setTotal(tclOpensourceInfoDO.getTotal());
        return this.beansCopy(list, TclOpensourceInfoDTO.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TclOpensourceInfoDTO fetchInfoByCrawler(TclOpensourceInfoDTO param) {
        TclOpensourceInfoDTO info = (TclOpensourceInfoDTO)this.queryByPk((BaseInfo)param);
        if (info == null) {
            return info;
        }
        if (StringUtils.isBlank((CharSequence)param.getOpensourceId())) {
            param.setOpensourceId(info.getOpensourceId());
        }
        ChromeDriver driver = null;
        try {
            String bingCacheUrl = "https://cn.bing.com/search?q=%s";
            String mvnRepositoryHost = "https://mvnrepository.com/artifact/%s/%s/%s";
            String cveHost = "https://cve.mitre.org/cgi-bin/cvename.cgi?name=%s";
            String cnvdHost = "https://www.cnvd.org.cn/flaw/show/%s";
            String cnnvdHost = "https://www.cnnvd.org.cn/home/globalSearch?keyword=%s";
            System.setProperty("webdriver.chrome.driver", this.webDriver);
            ChromeOptions options = new ChromeOptions();
            options.addArguments(new String[]{"----headless", "new"});
            options.addArguments(new String[]{"headless", "no-sandbox"});
            options.addArguments(new String[]{"--no-sandbox"});
            options.addArguments(new String[]{"--disable-gpu"});
            options.addArguments(new String[]{"--window-size=1920,1024"});
            options.addArguments(new String[]{"--remote-allow-origins=*"});
            String ua = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/87.0.4280.88 Safari/537.36";
            options.addArguments(new String[]{String.format("--user-agent=%s", ua)});
            driver = new ChromeDriver(options);
            String url = String.format(bingCacheUrl, String.format("%s:%s:%s site:mvnrepository.com", param.getGroupId(), param.getArtifactId(), param.getVersionId()));
            logger.info("\u6293\u53d6\u94fe\u63a5\u5185\u5bb9 {}", (Object)url);
            driver.get(url);
            WebDriverWait wait = new WebDriverWait((WebDriver)driver, Duration.ofSeconds(10L));
            wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.id((String)"b_results")));
            WebElement bResult = driver.findElement(By.id((String)"b_results"));
            String snapshotUrl = this.findCacheSnapShotUrl(bResult, driver, wait, param);
            logger.info("\u6293\u53d6\u5feb\u7167\u94fe\u63a5\u5185\u5bb9 {}", (Object)snapshotUrl);
            if (StringUtils.isBlank((CharSequence)snapshotUrl)) {
                logger.info("\u672a\u627e\u5230\u7f13\u5b58\u5feb\u7167\u94fe\u63a5");
                TclOpensourceInfoDTO tclOpensourceInfoDTO = null;
                return tclOpensourceInfoDTO;
            }
            driver.get(snapshotUrl);
            wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.className((String)"im-title")));
            WebElement imTitle = driver.findElement(By.className((String)"im-title"));
            WebElement imDesc = driver.findElement(By.className((String)"im-description"));
            param.setOpensourceName(imDesc.getText());
            WebElement grid = driver.findElement(By.className((String)"grid"));
            WebElement gridTbody = grid.findElement(By.tagName((String)"tbody"));
            List gridTr = gridTbody.findElements(By.tagName((String)"tr"));
            gridTr.forEach(tr -> {
                WebElement th = tr.findElement(By.tagName((String)"th"));
                WebElement td = tr.findElement(By.tagName((String)"td"));
                String title = th.getText();
                String value = td.getText();
                if (StringUtils.equals((CharSequence)title, (CharSequence)"License")) {
                    param.setLicenseName(value);
                    TclOpensourceLicenseDO license = this.fetchLicense(value);
                    if (license != null) {
                        param.setLicenseId(license.getLicenseId());
                        param.setLicenseName(license.getLicenseShort());
                    }
                } else if (StringUtils.equals((CharSequence)title, (CharSequence)"Date")) {
                    String dateStr = value;
                    Date date = DateUtility.parseDate((String)dateStr, (String)"MMM dd, yyyy");
                    dateStr = DateUtility.formatDate((Date)date, (String)"yyyy-MM-dd");
                    param.setReleaseDate(dateStr);
                } else if (StringUtils.equals((CharSequence)title, (CharSequence)"HomePage")) {
                    param.setHomepage(value);
                } else if (StringUtils.equals((CharSequence)title, (CharSequence)"Categories")) {
                    param.setOpensourceCategory(value);
                } else if (StringUtils.equals((CharSequence)title, (CharSequence)"Vulnerabilities")) {
                    String vulText = value;
                    param.setVulText(vulText);
                }
            });
            param.setLanguage("java");
            if (StringUtils.isNotBlank((CharSequence)param.getVulText())) {
                this.handlerVulInfo(param, param.getVulText(), driver, wait);
            }
            this.updateByPk(param);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5f00\u6e90\u7ec4\u4ef6\u4fe1\u606f\u5f02\u5e38 {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            if (driver != null) {
                driver.quit();
            }
        }
        return param;
    }

    private String findCacheSnapShotUrl(WebElement bResult, ChromeDriver driver, WebDriverWait wait, TclOpensourceInfoDTO param) {
        List bResultItemList = bResult.findElements(By.cssSelector((String)"li.b_algo"));
        if (CollectionUtils.isNotEmpty((Collection)bResultItemList)) {
            for (WebElement item : bResultItemList) {
                WebElement bRealUrlEl = item.findElement(By.cssSelector((String)".b_tpcn>.tilk"));
                String realUrl = bRealUrlEl.getAttribute("href");
                if (!StringUtils.contains((CharSequence)realUrl, (CharSequence)String.format("artifact/%s/%s/%s", param.getGroupId(), param.getArtifactId(), param.getVersionId()))) continue;
                wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.className((String)"trgr_icon")));
                wait.until((Function)ExpectedConditions.elementToBeClickable((By)By.className((String)"trgr_icon")));
                WebElement trgeLink = item.findElement(By.className((String)"trgr_icon"));
                trgeLink.sendKeys(new CharSequence[]{" "});
                String dataBm = item.getAttribute("data-bm");
                driver.executeScript(String.format("document.querySelectorAll('li[data-bm=\"%s\"]')[0].querySelectorAll('.c_tlbxTrg')[0].click()", dataBm), new Object[0]);
                wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.cssSelector((String)".c_tlbx div a")));
                String snapshotUrl = item.findElement(By.className((String)"c_tlbx")).findElement(By.tagName((String)"div")).findElement(By.tagName((String)"a")).getAttribute("href");
                if (!StringUtils.contains((CharSequence)snapshotUrl, (CharSequence)"cncc.bingj.com")) continue;
                snapshotUrl = StringUtils.replace((String)snapshotUrl, (String)"https://", (String)"http://");
                return snapshotUrl;
            }
        }
        return null;
    }

    private TclOpensourceLicenseDO fetchLicense(String licenseName) {
        TclOpensourceLicenseDO param = new TclOpensourceLicenseDO();
        param.setLicenseShort(licenseName);
        List list = this.tclOpensourceLicenseRepository.queryListByPage((Object)param);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return (TclOpensourceLicenseDO)list.get(0);
        }
        param.setLicenseShort(licenseName);
        param.setLicenseId(UUIDUtil.getShortUUID());
        param.setLicenseName(licenseName);
        int re = this.tclOpensourceLicenseRepository.insert((Object)param);
        if (re == 1) {
            return param;
        }
        return null;
    }

    private void handlerVulInfo(TclOpensourceInfoDTO param, String vulText, ChromeDriver driver, WebDriverWait wait) {
        if (StringUtils.isNotBlank((CharSequence)vulText)) {
            String[] lines = StringUtils.split((String)vulText, (String)"\n");
            ArrayList<TclOpensourceVulDO> vulList = new ArrayList<TclOpensourceVulDO>();
            for (String line : lines) {
                TclOpensourceVulDO vul;
                String str = StringUtils.trim((String)line);
                if (StringUtils.startsWith((CharSequence)str, (CharSequence)"CVE") && (vul = this.fetchCVEInfo(str, driver, wait)) != null) {
                    vul.setOpensourceId(param.getOpensourceId());
                    vul.setVersionId(param.getVersionId());
                    vulList.add(vul);
                }
                if (StringUtils.contains((CharSequence)line, (CharSequence)"Vulnerabilities from dependencies")) break;
            }
            if (CollectionUtils.isNotEmpty(vulList)) {
                for (TclOpensourceVulDO vul : vulList) {
                    TclOpensourceVulDO vulParam = new TclOpensourceVulDO();
                    vulParam.setVulCve(vul.getVulCve());
                    vulParam.setOpensourceId(vul.getOpensourceId());
                    vulParam.setVersionId(vul.getVersionId());
                    List checkList = this.tclOpensourceVulRepository.queryListByPage((Object)vulParam);
                    if (CollectionUtils.isNotEmpty((Collection)checkList)) {
                        vul.setVulId(((TclOpensourceVulDO)checkList.get(0)).getVulId());
                        this.tclOpensourceVulRepository.updateByPk((Object)vul);
                        continue;
                    }
                    this.tclOpensourceVulRepository.insert((Object)vul);
                }
                param.setVersionState(YesOrNO.YES.getCode());
            }
        }
    }

    private TclOpensourceVulDO fetchCVEInfo(String cveId, ChromeDriver driver, WebDriverWait wait) {
        HttpGet getCve = new HttpGet(String.format("https://cveawg.mitre.org/api/cve/%s", cveId));
        HttpResponse response = null;
        try {
            Map cna;
            Map containers;
            response = this.httpClient.execute((HttpUriRequest)getCve);
            String json = EntityUtils.toString((HttpEntity)response.getEntity());
            Map respMap = (Map)JSON.parseObject((String)json, Map.class);
            TclOpensourceVulDO vul = new TclOpensourceVulDO();
            vul.setVulId(UUIDUtil.getShortUUID());
            vul.setVulCve(cveId);
            vul.setVulCveUrl(String.format("https://www.cve.org/CVERecord?id=%s", cveId));
            Map cveMetadata = MapUtils.getMap((Map)respMap, (Object)"cveMetadata");
            if (cveMetadata != null) {
                vul.setVulPublishDate(this.convertDateFormat(MapUtils.getString((Map)cveMetadata, (Object)"datePublished")));
                vul.setVulUpdateDate(this.convertDateFormat(MapUtils.getString((Map)cveMetadata, (Object)"dateUpdated")));
            }
            if ((containers = MapUtils.getMap((Map)respMap, (Object)"containers")) != null && (cna = MapUtils.getMap((Map)containers, (Object)"cna")) != null) {
                Map cvssV3_1;
                Map metrics;
                List references;
                List descriptions = (List)cna.get("descriptions");
                if (CollectionUtils.isNotEmpty((Collection)descriptions)) {
                    Map desc = (Map)descriptions.get(0);
                    vul.setVulEnDesc(MapUtils.getString((Map)desc, (Object)"value"));
                }
                if (CollectionUtils.isNotEmpty((Collection)(references = (List)cna.get("references")))) {
                    ArrayList<String> refs = new ArrayList<String>();
                    for (Map reference : references) {
                        String url = MapUtils.getString((Map)reference, (Object)"url");
                        if (!StringUtils.isNotBlank((CharSequence)url)) continue;
                        refs.add(url);
                    }
                    vul.setVulReference(StringUtils.join(refs, (String)"\n"));
                }
                if ((metrics = MapUtils.getMap((Map)cna, (Object)"metrics")) != null && (cvssV3_1 = MapUtils.getMap((Map)metrics, (Object)"cvssV3_1")) != null) {
                    vul.setVulVector(MapUtils.getString((Map)cvssV3_1, (Object)"vectorString"));
                    vul.setVulAttackVector(MapUtils.getString((Map)cvssV3_1, (Object)"attackVector"));
                    vul.setVulAttackComplexity(MapUtils.getString((Map)cvssV3_1, (Object)"attackComplexity"));
                    vul.setVulPrivilegesReq(MapUtils.getString((Map)cvssV3_1, (Object)"privilegesRequired"));
                    vul.setVulPrivilegesReq(MapUtils.getString((Map)cvssV3_1, (Object)"privilegesRequired"));
                    vul.setVulUserInteraction(MapUtils.getString((Map)cvssV3_1, (Object)"userInteraction"));
                    vul.setVulScope(MapUtils.getString((Map)cvssV3_1, (Object)"scope"));
                    vul.setVulConfidentiality(MapUtils.getString((Map)cvssV3_1, (Object)"confidentialityImpact"));
                    vul.setVulConfidentiality(MapUtils.getString((Map)cvssV3_1, (Object)"confidentialityImpact"));
                    vul.setVulIntegrity(MapUtils.getString((Map)cvssV3_1, (Object)"integrityImpact"));
                    vul.setVulAvailability(MapUtils.getString((Map)cvssV3_1, (Object)"availabilityImpact"));
                    if (StringUtils.isNotBlank((CharSequence)MapUtils.getString((Map)cvssV3_1, (Object)"baseScore"))) {
                        vul.setVulCvss3Score(new BigDecimal(MapUtils.getString((Map)cvssV3_1, (Object)"baseScore")));
                    }
                }
            }
            try {
                String queryUrl = "https://www.cnnvd.org.cn/web/homePage/cnnvdVulList";
                HttpPost qryPost = new HttpPost(queryUrl);
                String reqJson = String.format("{\"pageIndex\":1,\"pageSize\":10,\"keyword\":\"%s\"}", cveId);
                StringEntity entity = new StringEntity(reqJson, ContentType.APPLICATION_JSON);
                qryPost.setEntity((HttpEntity)entity);
                qryPost.addHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0");
                qryPost.addHeader("Host", "www.cnnvd.org.cn");
                qryPost.addHeader("Origin", "https://www.cnnvd.org.cn");
                qryPost.addHeader("Referer", "https://www.cnnvd.org.cn/home/globalSearch?keyword=" + cveId);
                qryPost.addHeader("Sec-Fetch-Dest", "empty");
                qryPost.addHeader("Sec-Fetch-Mode", "cors");
                qryPost.addHeader("Sec-Fetch-Site", "same-origin");
                qryPost.addHeader("sec-ch-ua", "\"Not/A)Brand\";v=\"8\", \"Chromium\";v=\"126\", \"Microsoft Edge\";v=\"126\"");
                qryPost.addHeader("sec-ch-ua-mobile", "?0");
                qryPost.addHeader("sec-ch-ua-platform", "\"Windows\"");
                response = this.httpClient.execute((HttpUriRequest)qryPost);
                json = EntityUtils.toString((HttpEntity)response.getEntity());
                respMap = (Map)JSON.parseObject((String)json, Map.class);
                Map dataMap = MapUtils.getMap((Map)respMap, (Object)"data");
                List records = (List)dataMap.get("records");
                if (CollectionUtils.isNotEmpty((Collection)records)) {
                    Map qryRe = (Map)records.get(0);
                    String cnnvd_key = MapUtils.getString((Map)qryRe, (Object)"id");
                    String cnnvdCode = MapUtils.getString((Map)qryRe, (Object)"cnnvdCode");
                    String vulType = MapUtils.getString((Map)qryRe, (Object)"vulType");
                    entity = new StringEntity(String.format("{\"id\":\"%s\",\"vulType\":\"%s\",\"cnnvdCode\":\"%s\"}", cnnvd_key, vulType, cnnvdCode), ContentType.APPLICATION_JSON);
                    HttpPost detailPost = new HttpPost("https://www.cnnvd.org.cn/web/cnnvdVul/getCnnnvdDetailOnDatasource");
                    detailPost.setEntity((HttpEntity)entity);
                    detailPost.addHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0");
                    detailPost.addHeader("Host", "www.cnnvd.org.cn");
                    detailPost.addHeader("Origin", "https://www.cnnvd.org.cn");
                    detailPost.addHeader("Referer", "https://www.cnnvd.org.cn/home/globalSearch?keyword=" + cveId);
                    detailPost.addHeader("Sec-Fetch-Dest", "empty");
                    detailPost.addHeader("Sec-Fetch-Mode", "cors");
                    detailPost.addHeader("Sec-Fetch-Site", "same-origin");
                    detailPost.addHeader("sec-ch-ua", "\"Not/A)Brand\";v=\"8\", \"Chromium\";v=\"126\", \"Microsoft Edge\";v=\"126\"");
                    detailPost.addHeader("sec-ch-ua-mobile", "?0");
                    detailPost.addHeader("sec-ch-ua-platform", "\"Windows\"");
                    response = this.httpClient.execute((HttpUriRequest)detailPost);
                    json = EntityUtils.toString((HttpEntity)response.getEntity());
                    respMap = (Map)JSON.parseObject((String)json, Map.class);
                    dataMap = MapUtils.getMap((Map)respMap, (Object)"data");
                    Map cnnvdDetail = MapUtils.getMap((Map)dataMap, (Object)"cnnvdDetail");
                    if (cnnvdDetail != null) {
                        String vulTypeName = MapUtils.getString((Map)cnnvdDetail, (Object)"vulType");
                        String vulDesc = MapUtils.getString((Map)cnnvdDetail, (Object)"vulDesc");
                        String patch = MapUtils.getString((Map)cnnvdDetail, (Object)"patch");
                        String hazardLevel = MapUtils.getString((Map)cnnvdDetail, (Object)"hazardLevel");
                        vul.setVulRisk(VulRisk.codeByCnnvdCode((String)hazardLevel));
                        vul.setVulType(vulTypeName);
                        vul.setVulDesc(vulDesc);
                        vul.setVulSolution(patch);
                        vul.setVulCnnvd(cnnvdCode);
                        vul.setVulCnnvdUrl(String.format("https://www.cnnvd.org.cn/home/globalSearch?keyword=%s", cnnvdCode));
                    }
                }
            }
            catch (Exception cnnvdExp) {
                logger.error("\u8c03\u7528 cnnvd \u63a5\u53e3 \u5931\u8d25 {}", new Object[]{cveId, cnnvdExp.getMessage(), cnnvdExp});
            }
            return vul;
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528cve json \u63a5\u53e3\u5931\u8d25 {}", new Object[]{cveId, e.getMessage(), e});
            return null;
        }
    }

    private String convertDateFormat(String value) {
        try {
            String dateStr = value;
            Date date = DateUtility.parseDate((String)dateStr, (String)"yyyy-MM-dd HH:mm:ss");
            dateStr = DateUtility.formatDate((Date)date, (String)"yyyy-MM-dd");
            return dateStr;
        }
        catch (Exception e) {
            return value;
        }
    }
}

