/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dam.console.application.service.impl;

import com.irdstudio.allinrdm.dam.console.acl.repository.ModelFolderInfoRepository;
import com.irdstudio.allinrdm.dam.console.acl.repository.ModelTableInfoRepository;
import com.irdstudio.allinrdm.dam.console.domain.entity.ModelFolderInfoDO;
import com.irdstudio.allinrdm.dam.console.domain.entity.ModelTableInfoDO;
import com.irdstudio.allinrdm.dam.console.facade.ModelFolderInfoService;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelFolderInfoDTO;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="modelFolderInfoService")
public class ModelFolderInfoServiceImpl
extends BaseServiceImpl<ModelFolderInfoDTO, ModelFolderInfoDO, ModelFolderInfoRepository>
implements ModelFolderInfoService {
    @Autowired
    private ModelTableInfoRepository modelTableInfoRepository;

    public int insert(ModelFolderInfoDTO inModelFolderInfoDTO) {
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u4e3a:" + inModelFolderInfoDTO.toString());
        int num = 0;
        ModelFolderInfoDO modelFolderInfo = new ModelFolderInfoDO();
        this.beanCopy(inModelFolderInfoDTO, modelFolderInfo);
        int order = ((ModelFolderInfoRepository)this.getRepository()).queryMaxOrderValue(modelFolderInfo.getFolderAbvId());
        modelFolderInfo.setOrderValue(Integer.valueOf(order + 1));
        modelFolderInfo.setFolderLocation(this.handleFolderLocation(modelFolderInfo.getFolderId(), modelFolderInfo.getFolderName(), modelFolderInfo.getFolderAbvId()));
        num = ((ModelFolderInfoRepository)this.getRepository()).insert((Object)modelFolderInfo);
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u6761\u6570\u4e3a:" + num);
        return num;
    }

    public int updateByPk(ModelFolderInfoDTO paramDTO) {
        paramDTO.setFolderLocation(this.handleFolderLocation(paramDTO.getFolderId(), paramDTO.getFolderName(), paramDTO.getFolderAbvId()));
        return super.updateByPk((BaseInfo)paramDTO);
    }

    private String handleFolderLocation(String folderId, String folderName, String folderAbvId) {
        if (StringUtils.isNotBlank((String)folderAbvId)) {
            ModelFolderInfoDO abvFolder = new ModelFolderInfoDO();
            abvFolder.setFolderId(folderAbvId);
            abvFolder = (ModelFolderInfoDO)((ModelFolderInfoRepository)this.getRepository()).queryByPk((Object)abvFolder);
            if (abvFolder != null) {
                String abvLocation = abvFolder.getFolderLocation();
                String[] abvLocations = StringUtils.split((String)abvLocation, (String)"/");
                ArrayList<String> abvLocationList = new ArrayList<String>(Arrays.asList(abvLocations));
                abvLocationList.add(folderName);
                return StringUtils.join(abvLocationList, (String)"/");
            }
            return StringUtils.isBlank((String)folderName) ? "" : folderName;
        }
        return StringUtils.isBlank((String)folderName) ? "" : folderName;
    }

    public boolean isHaveSubFolder(String folderId) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u6570\u636e\u6761\u4ef6\u4e3a:" + folderId);
        boolean flag = true;
        flag = ((ModelFolderInfoRepository)this.getRepository()).isHaveSubFolder(folderId);
        logger.debug("\u6839\u636e\u6761\u4ef6:" + folderId + "\u67e5\u8be2\u7684\u6570\u636e\u603b\u6570\u4e3a" + flag);
        return flag;
    }

    public boolean isHaveTableModel(String folderId) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u6570\u636e\u6761\u4ef6\u4e3a:" + folderId);
        return ((ModelFolderInfoRepository)this.getRepository()).isHaveTableModel(folderId);
    }

    public int folderMerge(ModelFolderInfoDTO modelFolderInfoDTO, String type) {
        if (StringUtils.isBlank((String)modelFolderInfoDTO.getFolderId()) || StringUtils.isBlank((String)modelFolderInfoDTO.getFolderAbvId())) {
            return -1;
        }
        String srcFolderId = modelFolderInfoDTO.getFolderId();
        String targetFolderId = modelFolderInfoDTO.getFolderAbvId();
        ModelFolderInfoDTO srcFolderParam = new ModelFolderInfoDTO();
        srcFolderParam.setFolderAbvId(srcFolderId);
        List subFolderList = this.queryList((BaseInfo)srcFolderParam);
        if (CollectionUtils.isNotEmpty((Collection)subFolderList)) {
            for (ModelFolderInfoDTO sub : subFolderList) {
                sub.setFolderAbvId(targetFolderId);
                this.updateByPk(sub);
            }
        }
        ModelTableInfoDO tableParam = new ModelTableInfoDO();
        tableParam.setFolderId(srcFolderId);
        List tableList = this.modelTableInfoRepository.queryList((Object)tableParam);
        if (CollectionUtils.isNotEmpty((Collection)tableList)) {
            for (ModelTableInfoDO table : tableList) {
                table.setFolderId(targetFolderId);
                table.setLastModifyUser(modelFolderInfoDTO.getLoginUserId());
                table.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
                this.modelTableInfoRepository.updateByPk((Object)table);
            }
        }
        if (StringUtils.equals((String)type, (String)"merge")) {
            ModelFolderInfoDTO deleteSrc = new ModelFolderInfoDTO();
            deleteSrc.setFolderId(srcFolderId);
            this.deleteByPk((BaseInfo)deleteSrc);
        }
        return 0;
    }

    public int folderMove(ModelFolderInfoDTO modelFolderInfoDTO) {
        if (StringUtils.isBlank((String)modelFolderInfoDTO.getFolderId()) || StringUtils.isBlank((String)modelFolderInfoDTO.getFolderAbvId())) {
            return -1;
        }
        String srcFolderId = modelFolderInfoDTO.getFolderId();
        String targetFolderId = modelFolderInfoDTO.getFolderAbvId();
        ModelFolderInfoDO child = new ModelFolderInfoDO();
        child.setFolderId(srcFolderId);
        child = (ModelFolderInfoDO)((ModelFolderInfoRepository)this.getRepository()).queryByPk((Object)child);
        if (child != null) {
            child.setFolderAbvId(targetFolderId);
            return ((ModelFolderInfoRepository)this.getRepository()).updateByPk((Object)child);
        }
        return -1;
    }
}

