/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dam.console.application.service.impl;

import com.irdstudio.allinrdm.dam.console.acl.repository.ModelTableSameRepository;
import com.irdstudio.allinrdm.dam.console.domain.entity.ModelTableSameDO;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableSameService;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableSameDTO;
import com.irdstudio.allinrdm.dam.console.types.ObjectType;
import com.irdstudio.allinrdm.dam.console.types.SameType;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import com.irdstudio.sdk.beans.core.threadpool.ApplicationThreadPool2;
import com.irdstudio.sdk.beans.core.threadpool.ExecuteRtnInfo;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.DiffMatchPatch;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="modelTableSameServiceImpl")
public class ModelTableSameServiceImpl
extends BaseServiceImpl<ModelTableSameDTO, ModelTableSameDO, ModelTableSameRepository>
implements ModelTableSameService {
    @Autowired
    private ModelTableSameRepository modelTableSameRepository;
    @Autowired
    private ApplicationThreadPool2 applicationThreadPool;
    private static ConcurrentMap<String, AtomicInteger> taskDebounce = new ConcurrentHashMap<String, AtomicInteger>();
    private static final String TOTAL_SUFFIX = "-TOTAL";

    public boolean execFindSameTable(ModelTableSameDTO paramDTO) {
        boolean flag = true;
        try {
            ModelTableSameDO param = new ModelTableSameDO();
            param.setTargetObjectId(paramDTO.getTargetObjectId());
            param.setObjectType(ObjectType.Table.getIntCode());
            param.setSize(Integer.valueOf(1));
            List sourceList = this.modelTableSameRepository.querySourceTableListByPage(param);
            int size = 100;
            int total = param.getTotal();
            int loop = this.calcLoop(total, size);
            if (total > 0) {
                this.modelTableSameRepository.deleteByTargetId(paramDTO.getTargetObjectId());
            }
            ModelTableSameDO targetDO = (ModelTableSameDO)this.beanCopy(paramDTO, this.getDOClazz());
            BatchFindTask taskOne = new BatchFindTask(targetDO, 1, loop / 2, size, this.modelTableSameRepository);
            BatchFindTask taskTow = new BatchFindTask(targetDO, loop / 2 + 1, loop, size, this.modelTableSameRepository);
            String targetObjectId = paramDTO.getTargetObjectId();
            String totalKey = String.format("%s-%s", targetObjectId, TOTAL_SUFFIX);
            taskDebounce.put(totalKey, new AtomicInteger(total));
            taskDebounce.put(targetObjectId, new AtomicInteger(0));
            this.applicationThreadPool.addWithGeneric((Callable)taskOne);
            this.applicationThreadPool.addWithGeneric((Callable)taskTow);
        }
        catch (Exception e) {
            logger.error("\u751f\u6210\u76f8\u4f3c\u8868\u5bf9\u6bd4\u6570\u636e\u5f02\u5e38 {} {}", new Object[]{paramDTO.getTargetObjectId(), e.getMessage(), e});
            throw new RuntimeException(String.format("\u751f\u6210\u76f8\u4f3c\u8868\u5bf9\u6bd4\u6570\u636e\u5f02\u5e38 %s %s", paramDTO.getTargetObjectId(), e.getMessage()), e);
        }
        return flag;
    }

    public BigDecimal findSameTableStat(ModelTableSameDTO paramDTO) {
        String targetObjectId = paramDTO.getTargetObjectId();
        String totalKey = String.format("%s-%s", targetObjectId, TOTAL_SUFFIX);
        AtomicInteger total = (AtomicInteger)taskDebounce.get(totalKey);
        AtomicInteger current = (AtomicInteger)taskDebounce.get(targetObjectId);
        if (current.get() == -1) {
            return null;
        }
        return total.get() == 0 ? BigDecimal.ZERO : new BigDecimal(current.get()).divide(new BigDecimal(total.get()), 2, RoundingMode.HALF_UP);
    }

    public List<ModelTableSameDTO> querySourceTableListByPage(ModelTableSameDTO sameDTO) {
        List list = null;
        ModelTableSameDO paramDO = (ModelTableSameDO)this.beanCopy(sameDTO, this.getDOClazz());
        List doList = ((ModelTableSameRepository)this.getRepository()).queryListByPage((Object)paramDO);
        list = this.beansCopy(doList, this.getDTOClazz());
        return list;
    }

    private int calcLoop(int size, int len) {
        int loop = size / len;
        if (size % len > 0) {
            return loop + 1;
        }
        return loop;
    }

    public class BatchFindTask
    implements Callable<ExecuteRtnInfo<Integer>> {
        private ModelTableSameRepository modelTableSameRepository;
        private ModelTableSameDO target;
        private List<ModelTableSameDO> sourceList;
        private int start;
        private int end;
        private int page;
        private DiffMatchPatch dmp = new DiffMatchPatch();

        public BatchFindTask(ModelTableSameDO target, int start, int end, int page, ModelTableSameRepository modelTableSameRepository) {
            this.target = target;
            this.start = start;
            this.end = end;
            this.page = page;
            this.modelTableSameRepository = modelTableSameRepository;
        }

        @Override
        public ExecuteRtnInfo<Integer> call() throws Exception {
            ExecuteRtnInfo rtn = new ExecuteRtnInfo();
            try {
                int count = 0;
                String userId = this.target.getLoginUserId();
                String now = CurrentDateUtil.getTodayDateEx2();
                String targetCode = this.target.getTargetObjectCode();
                String targetName = this.target.getTargetObjectName();
                for (int i = this.start; i <= this.end; ++i) {
                    ModelTableSameDO param = new ModelTableSameDO();
                    param.setTargetObjectId(this.target.getTargetObjectId());
                    param.setObjectType(ObjectType.Table.getIntCode());
                    param.setPage(Integer.valueOf(i));
                    param.setSize(Integer.valueOf(this.page));
                    this.sourceList = this.modelTableSameRepository.querySourceTableListByPage(param);
                    if (!CollectionUtils.isNotEmpty(this.sourceList)) continue;
                    ArrayList<ModelTableSameDO> resultList = new ArrayList<ModelTableSameDO>(this.sourceList.size());
                    for (ModelTableSameDO source : this.sourceList) {
                        AtomicInteger current;
                        BigDecimal nameProportion;
                        String code = source.getObjectCode();
                        String name = source.getObjectName();
                        BigDecimal codeProportion = this.calcProportion(targetCode, code);
                        if (codeProportion.max(nameProportion = this.calcProportion(targetName, name)).compareTo(new BigDecimal("0.7")) >= 0) {
                            if (codeProportion.compareTo(nameProportion) >= 0) {
                                source.setSameType(SameType.CodeLike.getCode());
                                source.setSameContent(String.format("\u8868\u6a21\u578b\u4ee3\u7801\u76f8\u4f3c %s%%", codeProportion.multiply(new BigDecimal(100))));
                            } else {
                                source.setSameType(SameType.NameLike.getCode());
                                source.setSameContent(String.format("\u8868\u6a21\u578b\u540d\u79f0\u76f8\u4f3c %s%%", nameProportion.multiply(new BigDecimal(100))));
                            }
                            source.setTargetObjectId(this.target.getTargetObjectId());
                            source.setTargetObjectCode(this.target.getTargetObjectCode());
                            source.setTargetObjectName(this.target.getTargetObjectName());
                            resultList.add(source);
                        }
                        if ((current = (AtomicInteger)taskDebounce.get(this.target.getTargetObjectId())).get() == -1) break;
                        current.getAndIncrement();
                        ++count;
                    }
                    if (!CollectionUtils.isNotEmpty(resultList)) continue;
                    this.modelTableSameRepository.batchInsert(resultList);
                }
                rtn.setResult((Object)count);
                rtn.setSuccessFlag(true);
            }
            catch (Exception e) {
                BaseServiceImpl.logger.error("\u751f\u6210\u76f8\u4f3c\u8868\u5bf9\u6bd4\u6570\u636e\u4efb\u52a1\u6267\u884c\u5f02\u5e38 {} start:{}, end:{}, error:{}", new Object[]{this.target.getTargetObjectId(), this.start, this.end, e.getMessage(), e});
                ((AtomicInteger)taskDebounce.get(this.target.getTargetObjectId())).set(-1);
            }
            return rtn;
        }

        private BigDecimal calcProportion(String target, String code) {
            LinkedList diff = this.dmp.diff_main(target, code);
            this.dmp.diff_cleanupSemantic(diff);
            BigDecimal proportion = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty((Collection)diff)) {
                int len = 0;
                for (DiffMatchPatch.Diff d : diff) {
                    if (d.operation != DiffMatchPatch.Operation.EQUAL) continue;
                    len += d.text.length();
                }
                proportion = new BigDecimal(len).divide(new BigDecimal(target.length()), 2, RoundingMode.HALF_UP);
            }
            return proportion;
        }
    }
}

