/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dam.console.application.service.task;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.irdstudio.allinrdm.dam.console.application.service.task.DamTemplateTask;
import com.irdstudio.allinrdm.dam.console.facade.DictCategoryInfoService;
import com.irdstudio.allinrdm.dam.console.facade.DictItemInfoService;
import com.irdstudio.allinrdm.dam.console.facade.DictOptionEnumService;
import com.irdstudio.allinrdm.dam.console.facade.DictOptionInfoService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableFieldService;
import com.irdstudio.allinrdm.dam.console.facade.PubDatatypeService;
import com.irdstudio.allinrdm.dam.console.facade.PubDbmsDatatypeService;
import com.irdstudio.allinrdm.dam.console.facade.dto.DictCategoryInfoDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.DictItemInfoDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.DictOptionInfoDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.PubDatatypeDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.PubDbmsDatatypeDTO;
import com.irdstudio.allinrdm.dam.console.types.CatePackageType;
import com.irdstudio.allinrdm.dam.console.types.CategoryPackagePrefix;
import com.irdstudio.allinrdm.dam.console.types.PackageLevel;
import com.irdstudio.allinrdm.dam.console.types.PublishState;
import com.irdstudio.allinrdm.dam.console.types.SuitType;
import com.irdstudio.allintcp.sdk.sequence.facade.operation.SeqInstInfoService;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.TimeUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class DictItemInfoImportTask
implements DamTemplateTask {
    @Autowired
    @Qualifier(value="dictItemInfoService")
    private DictItemInfoService dictItemInfoService;
    @Autowired
    @Qualifier(value="dictOptionInfoService")
    private DictOptionInfoService dictOptionInfoService;
    @Autowired
    @Qualifier(value="dictOptionEnumService")
    private DictOptionEnumService dictOptionEnumService;
    @Autowired
    @Qualifier(value="dictCategoryInfoServiceImpl")
    private DictCategoryInfoService dictCategoryInfoService;
    @Autowired
    private ModelTableFieldService modelTableFieldService;
    @Autowired
    @Qualifier(value="pubDbmsDatatypeService")
    private PubDbmsDatatypeService pubDbmsDatatypeService;
    @Autowired
    @Qualifier(value="pubDatatypeService")
    private PubDatatypeService pubDatatypeService;
    @Autowired
    protected SeqInstInfoService seqInstInfoService;

    @Override
    public Map<String, Object> handler(Map<String, Object> params, File uploadFile) {
        String excelUploadType = MapUtils.getString(params, (Object)"excelUploadType");
        String accessLevel = MapUtils.getString(params, (Object)"accessLevel");
        String subsId = MapUtils.getString(params, (Object)"subsId");
        String appId = MapUtils.getString(params, (Object)"appId");
        String userId = MapUtils.getString(params, (Object)"userId");
        String nowTime = CurrentDateUtil.getTodayDateEx2();
        PubDatatypeDTO pubDatatype = new PubDatatypeDTO();
        List dataTypeList = this.pubDatatypeService.queryList((Object)pubDatatype);
        HashMap<String, PubDatatypeDTO> dataTypeMap = new HashMap<String, PubDatatypeDTO>();
        if (CollectionUtils.isNotEmpty((Collection)dataTypeList)) {
            for (PubDatatypeDTO dt : dataTypeList) {
                dataTypeMap.put(dt.getDatatypeId().toString(), dt);
            }
        }
        PubDbmsDatatypeDTO dataTypeParam = new PubDbmsDatatypeDTO();
        dataTypeParam.setDbmsId(Integer.valueOf(425));
        List dbmsDataTypeList = this.pubDbmsDatatypeService.queryList((Object)dataTypeParam);
        HashMap<String, PubDbmsDatatypeDTO> dbmsDataTypeMap = new HashMap<String, PubDbmsDatatypeDTO>();
        if (CollectionUtils.isNotEmpty((Collection)dbmsDataTypeList)) {
            for (PubDbmsDatatypeDTO dbmsDt : dbmsDataTypeList) {
                PubDatatypeDTO dt = (PubDatatypeDTO)dataTypeMap.get(dbmsDt.getDatatypeId().toString());
                if (dt == null) {
                    dt = new PubDatatypeDTO();
                }
                String datatypeName = dt.getDatatypeName();
                dbmsDt.setDatatypeName(datatypeName);
                dbmsDataTypeMap.put(String.format("%s-%s", datatypeName, dbmsDt.getDbmsDatatypeCode()), dbmsDt);
                dbmsDataTypeMap.put(dbmsDt.getDbmsDatatypeCode().toLowerCase(), dbmsDt);
            }
        }
        String createTime = TimeUtil.getCurrentDateTime();
        ExcelReader excelReader = null;
        try {
            excelReader = EasyExcel.read((InputStream)new FileInputStream(uploadFile)).build();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("\u5bfc\u5165\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25 " + e.getMessage(), e);
        }
        DictItemExcelReadListener itemListener = new DictItemExcelReadListener(dbmsDataTypeMap);
        ReadSheet itemSheet = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet((Integer)0).registerReadListener((ReadListener)itemListener)).headRowNumber(Integer.valueOf(1))).build();
        excelReader.read(new ReadSheet[]{itemSheet});
        if (itemListener.getItemList().size() > 0) {
            ArrayList<DictCategoryInfoDTO> cataList = new ArrayList<DictCategoryInfoDTO>();
            HashMap<String, DictCategoryInfoDTO> cataMap = new HashMap<String, DictCategoryInfoDTO>();
            HashMap<String, DictOptionInfoDTO> optionInfoMap = new HashMap<String, DictOptionInfoDTO>();
            for (DictItemInfoDTO item : itemListener.getItemList()) {
                DictCategoryInfoDTO cata3;
                DictCategoryInfoDTO cata2;
                String subjectId = item.getSubjectId();
                String cataId1 = item.getCataId1();
                String cataId2 = item.getCataId2();
                String cataId3 = item.getCataId3();
                DictCategoryInfoDTO subjectCata = (DictCategoryInfoDTO)cataMap.get(subjectId);
                DictCategoryInfoDTO cata1 = (DictCategoryInfoDTO)cataMap.get(cataId1);
                if (cata1 == null) {
                    cata1 = new DictCategoryInfoDTO();
                    cata1.setPackageLevel(PackageLevel.FirstLevel.getCode());
                    cata1.setPackageName(cataId1);
                    cata1.setPackageDesc(cataId1);
                    cata1.setCreateUser(userId);
                    cata1.setCreateTime(nowTime);
                    cata1.setPackageType(CatePackageType.Theme.getCode());
                    String packageId = this.dictCategoryInfoService.getSequencePackageId(CategoryPackagePrefix.FirstLevel.getCode());
                    int order = NumberUtils.toInt((String)packageId.substring(CategoryPackagePrefix.FirstLevel.getCode().length()), (int)1);
                    cata1.setOrderValue(Integer.valueOf(order));
                    cata1.setPackageId(packageId);
                    cata1.setPackageCode(packageId);
                    cata1.setSubsId(subsId);
                    cataList.add(cata1);
                    cataMap.put(cataId1, cata1);
                }
                if ((cata2 = (DictCategoryInfoDTO)cataMap.get(cataId2)) == null) {
                    cata2 = new DictCategoryInfoDTO();
                    cata2.setPackageLevel(PackageLevel.SecondLevel.getCode());
                    cata2.setPackageName(cataId2);
                    cata2.setPackageDesc(cataId2);
                    cata2.setCreateUser(userId);
                    cata2.setCreateTime(nowTime);
                    cata2.setPackageType(CatePackageType.Theme.getCode());
                    String packageId = this.dictCategoryInfoService.getSequencePackageId(CategoryPackagePrefix.SecondLevel.getCode());
                    int order = NumberUtils.toInt((String)packageId.substring(CategoryPackagePrefix.SecondLevel.getCode().length()), (int)1);
                    cata2.setOrderValue(Integer.valueOf(order));
                    cata2.setPackageId(packageId);
                    cata2.setPackageCode(packageId);
                    cata2.setSubsId(subsId);
                    cata2.setPackageAbvId(cata1.getPackageId());
                    cataList.add(cata2);
                    cataMap.put(cataId2, cata2);
                }
                if ((cata3 = (DictCategoryInfoDTO)cataMap.get(cataId3)) == null) {
                    cata3 = new DictCategoryInfoDTO();
                    cata3.setPackageLevel(PackageLevel.ThirdLevel.getCode());
                    cata3.setPackageName(cataId3);
                    cata3.setPackageDesc(cataId3);
                    cata3.setCreateUser(userId);
                    cata3.setCreateTime(nowTime);
                    cata3.setPackageType(CatePackageType.Theme.getCode());
                    String packageId = this.dictCategoryInfoService.getSequencePackageId(CategoryPackagePrefix.ThirdLevel.getCode());
                    int order = NumberUtils.toInt((String)packageId.substring(CategoryPackagePrefix.ThirdLevel.getCode().length()), (int)1);
                    cata3.setOrderValue(Integer.valueOf(order));
                    cata3.setPackageId(packageId);
                    cata3.setPackageCode(packageId);
                    cata3.setPackageAbvId(cata2.getPackageId());
                    cata3.setSubsId(subsId);
                    cataList.add(cata3);
                    cataMap.put(cataId3, cata3);
                }
                item.setCataId1(cata1.getPackageId());
                item.setCataId2(cata2.getPackageId());
                item.setCataId3(cata3.getPackageId());
                item.setCreateUser(userId);
                item.setCreateTime(nowTime);
                item.setAccessLevel(accessLevel);
                item.setSubsId(subsId);
                item.setAppId(appId);
                if (StringUtils.equals((String)"\u4e0d\u6d89\u53ca", (String)item.getDictId())) {
                    item.setDictId(null);
                    item.setDictCode(null);
                }
                if (!StringUtils.isNotBlank((String)item.getDictId())) continue;
                String dictId = item.getDictId();
                DictOptionInfoDTO option = (DictOptionInfoDTO)optionInfoMap.get(dictId);
                if (option == null) {
                    option = new DictOptionInfoDTO();
                    option.setDictId(dictId);
                    option.setSubsId(subsId);
                    option = (DictOptionInfoDTO)this.dictOptionInfoService.queryByPk((Object)option);
                    if (option != null) {
                        optionInfoMap.put(dictId, option);
                        continue;
                    }
                    item.setDictId(null);
                    item.setDictCode(null);
                    optionInfoMap.put(dictId, new DictOptionInfoDTO());
                    continue;
                }
                if (!StringUtils.isBlank((String)option.getDictId())) continue;
                item.setDictId(null);
                item.setDictCode(null);
            }
            this.dictItemInfoService.excelUpload(excelUploadType, itemListener.getItemList(), cataList);
        }
        return Collections.emptyMap();
    }

    public static class DictItemExcelReadListener
    extends AnalysisEventListener {
        private Map<String, PubDbmsDatatypeDTO> dbmsDataTypeMap;
        private List<DictItemInfoDTO> itemList = new ArrayList<DictItemInfoDTO>();
        List<String> HEAD = Arrays.asList("\u6807\u51c6\u7c7b\u578b", "\u6807\u51c6\u9879\u7f16\u53f7", "\u6807\u51c6\u4e3b\u9898", "\u4e00\u7ea7\u5206\u7c7b", "\u4e8c\u7ea7\u5206\u7c7b", "\u4e09\u7ea7\u5206\u7c7b", "\u4e2d\u6587\u540d\u79f0", "\u6807\u51c6\u9879\u7f16\u53f7", "\u82f1\u6587\u540d\u79f0", "\u5e38\u7528\u540d\u79f0", "\u4e1a\u52a1\u542b\u4e49", "\u5236\u5b9a\u4f9d\u636e", "\u9002\u7528\u7c7b\u578b", "\u9002\u7528\u6761\u4ef6", "\u76d1\u7ba1\u6807\u5fd7", "\u6570\u636e\u7c7b\u578b", "\u6570\u636e\u957f\u5ea6", "\u5f15\u7528\u4ee3\u7801", "\u4ee3\u7801\u5b9a\u4e49\u539f\u5219", "\u4ee3\u7801\u5f15\u7528\u6807\u51c6", "\u7f16\u7801\u89c4\u5219", "\u6821\u9a8c\u89c4\u5219", "\u6807\u51c6\u9879\u6570\u636e\u5206\u7ea7", "\u4e3b\u6570\u636e\u6240\u5728\u7cfb\u7edf", "\u7ba1\u7406\u90e8\u95e8", "\u53d1\u5e03\u72b6\u6001", "\u53d1\u5e03\u65f6\u95f4", "\u5907\u6ce8", "\u53d8\u66f4\u539f\u56e0");
        List<String> headCellList = new ArrayList<String>();
        Pattern pattern = Pattern.compile("(\\w+)\\(\\s*(\\d+),?(\\d*)(\\s+BYTE)*\\s*\\)");
        Pattern typePattern = Pattern.compile("(\\w+?)\\_+?(\\d+)\\_?(\\d*)");

        public DictItemExcelReadListener(Map<String, PubDbmsDatatypeDTO> dbmsDataTypeMap) {
            this.dbmsDataTypeMap = dbmsDataTypeMap;
        }

        public List<DictItemInfoDTO> getItemList() {
            return this.itemList;
        }

        public void setItemList(List<DictItemInfoDTO> itemList) {
            this.itemList = itemList;
        }

        public void invokeHeadMap(Map headMap, AnalysisContext context) {
            super.invokeHeadMap(headMap, context);
            int size = headMap.size();
            for (int i = 0; i < size; ++i) {
                this.headCellList.add((String)headMap.get(i));
            }
        }

        public void invoke(Object data, AnalysisContext context) {
            Matcher dashTypeMatcher;
            PubDbmsDatatypeDTO dbmsDt;
            Map map = (Map)data;
            String itemId = (String)map.get(1);
            String subjectId = (String)map.get(2);
            String cataId1 = (String)map.get(3);
            String cataId2 = (String)map.get(4);
            String cataId3 = (String)map.get(5);
            String itemName = (String)map.get(6);
            String itemCode = (String)map.get(8);
            String commonName = (String)map.get(9);
            String bussDesc = (String)map.get(10);
            String basicFormula = (String)map.get(11);
            String suitType = (String)map.get(12);
            String suitCond = (String)map.get(13);
            String itemDataType = (String)map.get(15);
            String itemDateLength = (String)map.get(16);
            String dictId = (String)map.get(17);
            String codeRule = (String)map.get(20);
            String checklist = (String)map.get(21);
            String mainSystem = (String)map.get(23);
            String manageDept = (String)map.get(24);
            String publishState = (String)map.get(25);
            String publishTime = (String)map.get(26);
            String itemRemarks = (String)map.get(27);
            DictItemInfoDTO item = new DictItemInfoDTO();
            item.setItemId(itemId);
            item.setSubjectId(subjectId);
            item.setCataId1(cataId1);
            item.setCataId2(cataId2);
            item.setCataId3(cataId3);
            item.setItemName(itemName);
            item.setItemCode(itemCode);
            item.setCommonName(commonName);
            item.setBussDesc(bussDesc);
            item.setBasicFormula(basicFormula);
            SuitType st = SuitType.getByName((String)suitType);
            if (st != null) {
                item.setSuitType(st.getCode());
            }
            item.setSuitCond(suitCond);
            itemDateLength = itemDateLength != null ? itemDateLength.replaceAll("\uff08", "(").replaceAll("\uff09", ")").replaceAll("\uff0c", ",").trim() : "";
            Matcher matcher = this.pattern.matcher(itemDateLength.toLowerCase());
            if (matcher.matches()) {
                String type = matcher.group(1);
                String length = matcher.group(2);
                String precision = matcher.group(3);
                String key = String.format("%s-%s", itemDataType, type);
                dbmsDt = this.dbmsDataTypeMap.get(key);
                if (dbmsDt != null) {
                    item.setItemDataType(dbmsDt.getDatatypeId());
                } else {
                    dbmsDt = this.dbmsDataTypeMap.get(type.toLowerCase());
                    if (dbmsDt != null) {
                        item.setItemDataType(dbmsDt.getDatatypeId());
                    }
                }
                item.setItemDataLength(Integer.valueOf(length));
                if (StringUtils.isNotEmpty((String)precision)) {
                    item.setItemDataPrecision(Integer.valueOf(precision));
                }
            }
            if ((dashTypeMatcher = this.typePattern.matcher(itemDateLength)).matches()) {
                String type = dashTypeMatcher.group(1);
                String length = dashTypeMatcher.group(2);
                String precision = dashTypeMatcher.group(3);
                dbmsDt = this.dbmsDataTypeMap.get(type.toLowerCase());
                if (dbmsDt != null) {
                    item.setItemDataType(dbmsDt.getDatatypeId());
                }
                item.setItemDataLength(Integer.valueOf(length));
                if (StringUtils.isNotEmpty((String)precision)) {
                    item.setItemDataPrecision(Integer.valueOf(precision));
                }
            }
            item.setDictId(dictId);
            item.setDictCode(dictId);
            item.setCodeRule(codeRule);
            item.setChecklist(checklist);
            item.setMainSystem(mainSystem);
            item.setManageDept(manageDept);
            PublishState ps = PublishState.getByName((String)publishState);
            if (ps != null) {
                item.setPublishState(ps.getCode());
            }
            item.setPublishTime(publishTime);
            this.itemList.add(item);
        }

        public void doAfterAllAnalysed(AnalysisContext context) {
        }

        public String checkExcelFormat() {
            if (this.headCellList.size() != this.HEAD.size()) {
                return "\u6570\u636e\u5bfc\u5165\u6a21\u677f\u4e0d\u6b63\u786e";
            }
            for (int i = 0; i < this.HEAD.size(); ++i) {
                if (StringUtils.equals((String)this.headCellList.get(i), (String)this.HEAD.get(i))) continue;
                return "\u6570\u636e\u5bfc\u5165\u6a21\u677f\u4e0d\u6b63\u786e";
            }
            return null;
        }
    }
}

