/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.application.service.impl;

import com.irdstudio.allinrdm.dev.console.acl.repository.BpmModelNodeRepository;
import com.irdstudio.allinrdm.dev.console.domain.entity.BpmModelNodeDO;
import com.irdstudio.allinrdm.dev.console.facade.BpmModelNodeService;
import com.irdstudio.allinrdm.dev.console.facade.dto.BpmModelNodeDTO;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="bpmModelNodeServiceImpl")
public class BpmModelNodeServiceImpl
extends BaseServiceImpl<BpmModelNodeDTO, BpmModelNodeDO, BpmModelNodeRepository>
implements BpmModelNodeService {
    public int saveNodeList(String userId, List<BpmModelNodeDTO> list) {
        int outputVo = 0;
        if (CollectionUtils.isNotEmpty(list)) {
            String now = CurrentDateUtil.getTodayDateEx2();
            for (BpmModelNodeDTO node : list) {
                node.setBpmNodeId(StringUtils.replace((String)node.getBpmNodeId(), (String)"-", (String)""));
                if (StringUtils.isNotBlank((CharSequence)node.getSourceNodeId())) {
                    node.setSourceNodeId(StringUtils.replace((String)node.getSourceNodeId(), (String)"-", (String)""));
                }
                if (StringUtils.isNotBlank((CharSequence)node.getTargetNodeId())) {
                    node.setTargetNodeId(StringUtils.replace((String)node.getTargetNodeId(), (String)"-", (String)""));
                }
                node.setLastUpdateUser(userId);
                node.setLastUpdateTime(now);
                int re = this.updateByPk((BaseInfo)node);
                if (re == 0) {
                    node.setCreateUser(userId);
                    node.setCreateTime(now);
                    re = this.insert((BaseInfo)node);
                }
                if (re <= 0) continue;
                ++outputVo;
            }
        }
        return outputVo;
    }

    public int deleteByCond(BpmModelNodeDTO param) {
        BpmModelNodeDO bpmModelNodeDO = new BpmModelNodeDO();
        this.beanCopy(param, bpmModelNodeDO);
        return ((BpmModelNodeRepository)this.getRepository()).deleteByCond(bpmModelNodeDO);
    }
}

