/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.application.service.impl;

import com.irdstudio.allinrdm.dam.console.facade.ModelTableFieldService;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableFieldDTO;
import com.irdstudio.allinrdm.dev.console.acl.repository.OsrvArrangeVarRepository;
import com.irdstudio.allinrdm.dev.console.acl.repository.OsrvEvalVarRepository;
import com.irdstudio.allinrdm.dev.console.domain.entity.OsrvArrangeVarDO;
import com.irdstudio.allinrdm.dev.console.domain.entity.OsrvEvalVarDO;
import com.irdstudio.allinrdm.dev.console.facade.OsrvEvalVarService;
import com.irdstudio.allinrdm.dev.console.facade.dto.OsrvEvalVarDTO;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="osrvEvalVarServiceImpl")
public class OsrvEvalVarServiceImpl
extends BaseServiceImpl<OsrvEvalVarDTO, OsrvEvalVarDO, OsrvEvalVarRepository>
implements OsrvEvalVarService {
    @Autowired
    private OsrvArrangeVarRepository osrvArrangeVarRepository;
    @Autowired
    private ModelTableFieldService modelTableFieldService;

    public boolean refreshVarList(OsrvEvalVarDTO osrvEvalVarDTO) {
        OsrvArrangeVarDO var = new OsrvArrangeVarDO();
        var.setDomainVarId(osrvEvalVarDTO.getDomainVarId());
        var = (OsrvArrangeVarDO)this.osrvArrangeVarRepository.queryByPk((Object)var);
        if (var == null) {
            return true;
        }
        ModelTableFieldDTO fieldParam = new ModelTableFieldDTO();
        fieldParam.setObjectId(var.getTableModelId());
        List fields = this.modelTableFieldService.queryList((Object)fieldParam);
        if (CollectionUtils.isEmpty((Collection)fields)) {
            return true;
        }
        ArrayList<OsrvEvalVarDO> vars = new ArrayList<OsrvEvalVarDO>(fields.size());
        for (ModelTableFieldDTO field : fields) {
            OsrvEvalVarDO checkVar = ((OsrvEvalVarRepository)this.getRepository()).queryByFieldId(osrvEvalVarDTO.getTableRowId(), var.getDomainVarId(), field.getFieldCode());
            if (checkVar != null) {
                checkVar.setFieldOrder(field.getFieldOrder());
                checkVar.setDomainFieldId(field.getFieldId());
                checkVar.setDomainFieldName(field.getFieldName());
                ((OsrvEvalVarRepository)this.getRepository()).updateByPk((Object)checkVar);
                continue;
            }
            OsrvEvalVarDO evalVar = new OsrvEvalVarDO();
            evalVar.setRecordKeyid(UUIDUtil.getUUID());
            evalVar.setSrvModelId(osrvEvalVarDTO.getSrvModelId());
            evalVar.setTableRowId(osrvEvalVarDTO.getTableRowId());
            evalVar.setDomainVarId(var.getDomainVarId());
            evalVar.setDomainVarCode(var.getDomainVarCode());
            evalVar.setDomainVarName(var.getDomainVarName());
            evalVar.setDomainFieldId(field.getFieldId());
            evalVar.setDomainFieldCode(field.getFieldCode());
            evalVar.setDomainFieldName(field.getFieldName());
            evalVar.setFieldOrder(field.getFieldOrder());
            vars.add(evalVar);
        }
        if (!vars.isEmpty()) {
            int n = ((OsrvEvalVarRepository)this.getRepository()).batchInsert(vars);
        }
        return false;
    }
}

