/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.sam.console.application.service.impl;

import com.irdstudio.allinrdm.sam.console.acl.repository.FnModelInfoRepository;
import com.irdstudio.allinrdm.sam.console.domain.entity.FnModelInfoDO;
import com.irdstudio.allinrdm.sam.console.facade.FnModelInfoService;
import com.irdstudio.allinrdm.sam.console.facade.dto.FnModelInfoDTO;
import com.irdstudio.allinrdm.sam.console.types.FnTrigger;
import com.irdstudio.allinrdm.sam.console.types.FnType;
import com.irdstudio.allintcp.sdk.bi.acl.repository.RdmModuleInfoRepository;
import com.irdstudio.allintcp.sdk.bi.domain.entity.RdmModuleInfoDO;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="fnModelInfoServiceImpl")
public class FnModelInfoServiceImpl
extends BaseServiceImpl<FnModelInfoDTO, FnModelInfoDO, FnModelInfoRepository>
implements FnModelInfoService {
    @Autowired
    private RdmModuleInfoRepository rdmModuleInfoRepository;

    public int insert(FnModelInfoDTO paramDTO) {
        if (paramDTO.getFnOrder() == null) {
            Integer order = ((FnModelInfoRepository)this.getRepository()).queryMaxOrderBySubsId(paramDTO.getSubsId(), paramDTO.getFnAbvId());
            if (order == null) {
                order = 0;
            }
            paramDTO.setFnOrder(Integer.valueOf(order + 1));
        }
        return super.insert((BaseInfo)paramDTO);
    }

    public int deleteBySubsId(String subsId) {
        int num = ((FnModelInfoRepository)this.getRepository()).deleteBySubsId(subsId);
        return num;
    }

    public int saveExcel(String subsId, String userId, String assemblySchemeId, String appId, String comId, List<FnModelInfoDTO> list) {
        int num = 0;
        try {
            if (CollectionUtils.isNotEmpty(list)) {
                String now = CurrentDateUtil.getTodayDateEx2();
                HashMap<String, FnModelInfoDO> fnMap = new HashMap<String, FnModelInfoDO>();
                HashMap<String, FnModelInfoDO> appMap = new HashMap<String, FnModelInfoDO>();
                HashMap<String, RdmModuleInfoDO> moduleMap = new HashMap<String, RdmModuleInfoDO>();
                List doList = this.beansCopy(list, FnModelInfoDO.class);
                for (int i = 0; i < doList.size(); ++i) {
                    FnModelInfoDO fn = (FnModelInfoDO)doList.get(i);
                    fnMap.put(fn.getFnName(), fn);
                    fn.setFnId(UUIDUtil.getUUID());
                    fn.setSubsId(subsId);
                    fn.setCreateUser(userId);
                    fn.setUpdateUser(userId);
                    fn.setCreateTime(now);
                    fn.setUpdateTime(now);
                    fn.setFnOrder(Integer.valueOf(i + 1));
                    fn.setFnType2(FnType.codeByName((String)fn.getFnType2()));
                    fn.setFnTrigger(FnTrigger.codeByName((String)fn.getFnTrigger()));
                    if (StringUtils.isNotBlank((CharSequence)fn.getModuleName())) {
                        RdmModuleInfoDO module = (RdmModuleInfoDO)moduleMap.get(fn.getModuleName());
                        if (module == null) {
                            module = new RdmModuleInfoDO();
                            module.setSubsId(subsId);
                            module.setModuleName(fn.getModuleName());
                            List moduleList = this.rdmModuleInfoRepository.queryListByPage((Object)module);
                            if (CollectionUtils.isNotEmpty((Collection)moduleList)) {
                                module = (RdmModuleInfoDO)moduleList.get(0);
                                moduleMap.put(fn.getModuleName(), module);
                            } else {
                                module.setCreateUser(userId);
                                module.setCreateTime(now);
                                module.setUpdateUser(userId);
                                module.setUpdateTime(now);
                                module.setModuleId(UUIDUtil.getShortUUID());
                                module.setModuleCode(StringUtils.substring((String)fn.getModuleName(), (int)0, (int)31));
                                module.setModuleName(StringUtils.substring((String)fn.getModuleName(), (int)0, (int)80));
                                module.setModuleDesc(fn.getModuleName());
                                this.rdmModuleInfoRepository.insert((Object)module);
                                moduleMap.put(fn.getModuleName(), module);
                            }
                        }
                        fn.setModuleId(module.getModuleId());
                    }
                    if (!StringUtils.isNotBlank((CharSequence)fn.getAppCode()) && !StringUtils.isNotBlank((CharSequence)fn.getAppName())) continue;
                    String key = "" + fn.getAppCode() + fn.getAppName();
                    FnModelInfoDO app = (FnModelInfoDO)appMap.get(key);
                    if (app != null) {
                        fn.setAppId(app.getAppId());
                        continue;
                    }
                    List appList = ((FnModelInfoRepository)this.getRepository()).queryPaasAppInfo(fn);
                    if (CollectionUtils.isNotEmpty((Collection)appList)) {
                        app = (FnModelInfoDO)appList.get(0);
                        appMap.put(key, app);
                        fn.setAppId(app.getAppId());
                        continue;
                    }
                    app = new FnModelInfoDO();
                    appMap.put(key, app);
                }
                for (FnModelInfoDO fn : doList) {
                    if (StringUtils.isNotBlank((CharSequence)fn.getFnAbvName())) {
                        FnModelInfoDO abvFn = (FnModelInfoDO)fnMap.get(fn.getFnAbvName());
                        if (abvFn == null) {
                            FnModelInfoDO abvParam = new FnModelInfoDO();
                            abvParam.setSubsId(subsId);
                            abvParam.setFnName(fn.getFnAbvName());
                            List abvList = ((FnModelInfoRepository)this.getRepository()).queryListByPage((Object)abvParam);
                            abvFn = CollectionUtils.isNotEmpty((Collection)abvList) ? (FnModelInfoDO)abvList.get(0) : new FnModelInfoDO();
                            fnMap.put(fn.getFnAbvName(), abvFn);
                        }
                        fn.setFnAbvId(abvFn.getFnId());
                    }
                    num += ((FnModelInfoRepository)this.getRepository()).insert((Object)fn);
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        return num;
    }

    public Integer deleteByCond(FnModelInfoDTO param) {
        return ((FnModelInfoRepository)this.getRepository()).deleteByCond((FnModelInfoDO)this.beanCopy(param, FnModelInfoDO.class));
    }

    public String queryCodeWithPrefix(String subsId, String fnType2) {
        return ((FnModelInfoRepository)this.getRepository()).queryCodeWithPrefix(subsId, fnType2);
    }
}

