/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.sam.console.application.service.impl;

import com.irdstudio.allinrdm.sam.console.acl.repository.SolFolderInfoRepository;
import com.irdstudio.allinrdm.sam.console.acl.repository.StdBaseInfoRepository;
import com.irdstudio.allinrdm.sam.console.domain.entity.SolFolderInfoDO;
import com.irdstudio.allinrdm.sam.console.domain.entity.StdBaseInfoDO;
import com.irdstudio.allinrdm.sam.console.facade.SolFolderInfoService;
import com.irdstudio.allinrdm.sam.console.facade.dto.SolFolderInfoDTO;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="solFolderInfoServiceImpl")
public class SolFolderInfoServiceImpl
extends BaseServiceImpl<SolFolderInfoDTO, SolFolderInfoDO, SolFolderInfoRepository>
implements SolFolderInfoService {
    @Autowired
    protected StdBaseInfoRepository stdBaseInfoRepository;

    public int folderMerge(SolFolderInfoDTO paramDTO, String type) {
        if (StringUtils.isBlank((String)paramDTO.getFolderId()) || StringUtils.isBlank((String)paramDTO.getFolderAbvId())) {
            return -1;
        }
        String srcPackageId = paramDTO.getFolderId();
        String targetFolderId = paramDTO.getFolderAbvId();
        SolFolderInfoDTO srcPackageParam = new SolFolderInfoDTO();
        srcPackageParam.setFolderAbvId(srcPackageId);
        List subPackageList = this.queryList((BaseInfo)srcPackageParam);
        if (CollectionUtils.isNotEmpty((Collection)subPackageList)) {
            for (SolFolderInfoDTO sub : subPackageList) {
                sub.setFolderAbvId(targetFolderId);
                this.updateByPk((BaseInfo)sub);
            }
        }
        StdBaseInfoDO solFolderParam = new StdBaseInfoDO();
        solFolderParam.setFolderId(srcPackageId);
        List folderList = this.stdBaseInfoRepository.queryList((Object)solFolderParam);
        if (CollectionUtils.isNotEmpty((Collection)folderList)) {
            for (StdBaseInfoDO model : folderList) {
                model.setFolderId(targetFolderId);
                model.setLastModifyUser(paramDTO.getLoginUserId());
                model.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
                this.stdBaseInfoRepository.updateByPk((Object)model);
            }
        }
        if (StringUtils.equals((String)type, (String)"merge")) {
            SolFolderInfoDTO deleteSrc = new SolFolderInfoDTO();
            deleteSrc.setFolderId(srcPackageId);
            this.deleteByPk((BaseInfo)deleteSrc);
        }
        return 0;
    }

    public int folderMove(SolFolderInfoDTO paramDTO) {
        if (StringUtils.isBlank((String)paramDTO.getFolderId()) || StringUtils.isBlank((String)paramDTO.getFolderAbvId())) {
            return -1;
        }
        String srcPackageId = paramDTO.getFolderId();
        String targetFolderId = paramDTO.getFolderAbvId();
        SolFolderInfoDO child = new SolFolderInfoDO();
        child.setFolderId(srcPackageId);
        child = (SolFolderInfoDO)((SolFolderInfoRepository)this.getRepository()).queryByPk((Object)child);
        if (child != null) {
            child.setFolderAbvId(targetFolderId);
            return ((SolFolderInfoRepository)this.getRepository()).updateByPk((Object)child);
        }
        return -1;
    }
}

