/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.sam.console.application.service.operation;

import com.irdstudio.allinrdm.dev.console.types.YesOrNO;
import com.irdstudio.allinrdm.sam.console.facade.TclOpensourceInfoService;
import com.irdstudio.allinrdm.sam.console.facade.dto.TclOpensourceInfoDTO;
import com.irdstudio.allintcp.sdk.job.application.operation.JobAbstractServiceImpl;
import com.irdstudio.allintcp.sdk.job.facade.operation.JobBaseService;
import com.irdstudio.allintcp.sdk.job.facade.operation.dto.JobExecuteParamDTO;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service(value="TclOpensourceFetchInfoJobServiceImpl")
public class TclOpensourceFetchInfoJobServiceImpl
extends JobAbstractServiceImpl
implements JobBaseService,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private static final String JOB_ID = "TclOpensourceFetchInfoJob";
    private static final ConcurrentMap<String, Boolean> onlyOnceMap = new ConcurrentHashMap<String, Boolean>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(JobExecuteParamDTO param) {
        if (onlyOnceMap.get(param.getBatchSerialNo()) != null) {
            return 0;
        }
        onlyOnceMap.put(param.getBatchSerialNo(), true);
        try {
            TclOpensourceInfoService tclOpensourceInfoService = (TclOpensourceInfoService)SpringContextUtils.getBean(TclOpensourceInfoService.class);
            TclOpensourceInfoDTO qryParam = new TclOpensourceInfoDTO();
            qryParam.setPage(Integer.valueOf(1));
            qryParam.setSize(Integer.valueOf(100));
            qryParam.setVersionState(YesOrNO.NO.getCode());
            List infoList = tclOpensourceInfoService.queryIndexListByPage(qryParam);
            if (CollectionUtils.isNotEmpty((Collection)infoList)) {
                int total = qryParam.getTotal();
                int loop = TclOpensourceFetchInfoJobServiceImpl.calcLoop(total, qryParam.getSize());
                for (int page = 1; page <= loop; ++page) {
                    if (page > 1) {
                        qryParam.setPage(Integer.valueOf(page));
                        infoList = tclOpensourceInfoService.queryIndexListByPage(qryParam);
                    }
                    for (TclOpensourceInfoDTO info : infoList) {
                        try {
                            tclOpensourceInfoService.fetchInfoByCrawler(info);
                            Thread.sleep(2000L);
                        }
                        catch (Exception e) {
                            logger.error("{} \u6293\u53d6\u6570\u636e\u5931\u8d25 {}", new Object[]{info.getFileName(), e.getMessage(), e});
                        }
                    }
                }
                int n = total;
                return n;
            }
        }
        finally {
            onlyOnceMap.remove(param.getBatchSerialNo());
        }
        return 0;
    }

    public static int calcLoop(int size, int pageSize) {
        int loop = size / pageSize;
        if (size % pageSize > 0) {
            return loop + 1;
        }
        return loop;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.initService(applicationContext);
    }
}

