/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.sam.console.infra.repository.impl;

import com.irdstudio.allinrdm.sam.console.acl.repository.RdmMenuInfoRepository;
import com.irdstudio.allinrdm.sam.console.domain.entity.RdmMenuInfoDO;
import com.irdstudio.allinrdm.sam.console.infra.persistence.mapper.RdmMenuInfoMapper;
import com.irdstudio.allinrdm.sam.console.infra.persistence.po.RdmMenuInfoPO;
import com.irdstudio.sdk.beans.core.base.BaseRepositoryImpl;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="rdmMenuInfoRepositoryImpl")
public class RdmMenuInfoRepositoryImpl
extends BaseRepositoryImpl<RdmMenuInfoDO, RdmMenuInfoPO, RdmMenuInfoMapper>
implements RdmMenuInfoRepository {
    public int deleteBySubsId(String subsId) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + subsId);
        int num = 0;
        try {
            num = ((RdmMenuInfoMapper)this.getMapper()).deleteBySubsId(subsId);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + subsId + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    public int deleteByModuleId(RdmMenuInfoDO rdmMenuInfoDO) {
        int num = 0;
        try {
            RdmMenuInfoPO hldFnInfo = new RdmMenuInfoPO();
            this.beanCopy(rdmMenuInfoDO, (Object)hldFnInfo);
            List children = ((RdmMenuInfoMapper)this.getMapper()).queryList((Object)hldFnInfo);
            if (CollectionUtils.isNotEmpty((Collection)children)) {
                for (RdmMenuInfoPO fn : children) {
                    num = ((RdmMenuInfoMapper)this.getMapper()).deleteByPk((Object)hldFnInfo);
                    num += this.recursionDeleteFn(hldFnInfo);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + rdmMenuInfoDO + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    public int deleteByFnAbvId(String fnAbvId) {
        return ((RdmMenuInfoMapper)this.getMapper()).deleteByFnAbvId(fnAbvId);
    }

    public Integer queryMaxOrderBySubsId(String subsId, String fnAbvId) {
        return ((RdmMenuInfoMapper)this.getMapper()).queryMaxOrderBySubsId(subsId, fnAbvId);
    }

    public Integer deleteByCond(RdmMenuInfoDO param) {
        return ((RdmMenuInfoMapper)this.getMapper()).deleteByCond((RdmMenuInfoPO)((Object)this.beanCopy(param, RdmMenuInfoPO.class)));
    }

    public String queryCodeWithPrefix(String subsId, String fnType2) {
        String seq;
        String result = "";
        String prefix = "MN";
        result = ((RdmMenuInfoMapper)this.getMapper()).queryCodeWithPrefix(subsId, prefix);
        if (StringUtils.isBlank((CharSequence)result)) {
            result = prefix + "0001";
        }
        String numStr = StringUtils.replace((String)result, (String)prefix, (String)"");
        int num = Integer.parseInt(numStr);
        result = seq = prefix + StringUtils.leftPad((String)String.valueOf(num + 1), (int)4, (String)"0");
        return result;
    }

    private int recursionDeleteFn(RdmMenuInfoPO hldFnInfo) {
        String fnId = hldFnInfo.getFnId();
        RdmMenuInfoPO param = new RdmMenuInfoPO();
        param.setFnAbvId(fnId);
        List children = ((RdmMenuInfoMapper)this.getMapper()).queryList((Object)param);
        int count = 0;
        if (CollectionUtils.isNotEmpty((Collection)children)) {
            for (RdmMenuInfoPO fn : children) {
                count = ((RdmMenuInfoMapper)this.getMapper()).deleteByPk((Object)fn);
                count += this.recursionDeleteFn(fn);
            }
        }
        return count;
    }

    public List<RdmMenuInfoDO> queryPaasAppInfo(RdmMenuInfoDO rdmMenuInfoDO) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        RdmMenuInfoPO queryRdmMenuInfoPO = new RdmMenuInfoPO();
        this.beanCopy(rdmMenuInfoDO, (Object)queryRdmMenuInfoPO);
        List<RdmMenuInfoPO> hldFnInfos = ((RdmMenuInfoMapper)this.getMapper()).queryPaasAppInfo(queryRdmMenuInfoPO);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + hldFnInfos.size());
        list = this.beansCopy(hldFnInfos, RdmMenuInfoDO.class);
        return list;
    }
}

