/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dam.console.web.controller.api;

import com.irdstudio.allinrdm.dam.console.facade.DictOptionEnumService;
import com.irdstudio.allinrdm.dam.console.facade.dto.DictOptionEnumDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.SDicDTO;
import com.irdstudio.allinrdm.dam.console.types.DictLogChangeType;
import com.irdstudio.allinrdm.dam.console.types.annotations.DictDevLogAnno;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class DictOptionEnumController
extends BaseController<DictOptionEnumDTO, DictOptionEnumService> {
    @DictDevLogAnno(action=DictLogChangeType.Add, logCatalog="option", itemId="${args[0].optionId}", itemCode="${args[0].optionCode}", itemName="${args[0].optionName}")
    @PostMapping(value={"/api/dict/option/enum"})
    @ResponseBody
    public ResponseData<Integer> insertDictOptionEnum(@RequestBody DictOptionEnumDTO inDictOptionEnumVo) {
        inDictOptionEnumVo.setOptionId(UUIDUtil.getUUID());
        inDictOptionEnumVo.setLastModifyUser(this.getUserInfo().getUserId());
        inDictOptionEnumVo.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((DictOptionEnumService)this.getService()).insert((Object)inDictOptionEnumVo);
        return this.getResponseData(outputVo);
    }

    @DictDevLogAnno(action=DictLogChangeType.Delete, logCatalog="option", itemId="${args[0].optionId}", itemCode="${old.optionCode}", itemName="${old.optionName}")
    @DeleteMapping(value={"/api/dict/option/enum"})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody DictOptionEnumDTO inDictOptionEnumVo) {
        int outputVo = ((DictOptionEnumService)this.getService()).deleteByPk((Object)inDictOptionEnumVo);
        return this.getResponseData(outputVo);
    }

    @DictDevLogAnno(action=DictLogChangeType.Update, logCatalog="option", itemId="${args[0].optionId}", itemCode="${args[0].optionCode}", itemName="${args[0].optionName}")
    @PutMapping(value={"/api/dict/option/enum"})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody DictOptionEnumDTO inDictOptionEnumVo) {
        inDictOptionEnumVo.setLastModifyUser(this.getUserInfo().getUserId());
        inDictOptionEnumVo.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((DictOptionEnumService)this.getService()).updateByPk((Object)inDictOptionEnumVo);
        return this.getResponseData(outputVo);
    }

    @GetMapping(value={"/api/dict/option/enum/{optionId}"})
    @ResponseBody
    public ResponseData<DictOptionEnumDTO> queryByPk(@PathVariable(value="optionId") String optionId) {
        DictOptionEnumDTO inVo = new DictOptionEnumDTO();
        inVo.setOptionId(optionId);
        DictOptionEnumDTO outputVo = (DictOptionEnumDTO)((DictOptionEnumService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/dict/option/enums"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<DictOptionEnumDTO>> queryDictOptionEnumAll(DictOptionEnumDTO vo) {
        List outputVo = null;
        this.setUserInfoToVO(vo);
        outputVo = ((DictOptionEnumService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @GetMapping(value={"/api/dict/option/script/{fieldId}"})
    @ResponseBody
    public ResponseData<String> generateDDL(@PathVariable(value="fieldId") String fieldId) {
        if (StringUtils.isNotBlank((CharSequence)fieldId)) {
            List dicts = ((DictOptionEnumService)this.getService()).queryModelTableFieldDicts(fieldId);
            if (CollectionUtils.isEmpty((Collection)dicts)) {
                return this.getResponseData("");
            }
            String template = "insert into s_dic (enname, cnname, opttype, memo) values ('%s', '%s', '%s', '%s');\n";
            StringBuffer buffer = new StringBuffer();
            for (SDicDTO dic : dicts) {
                buffer.append(String.format(template, dic.getEnname(), dic.getCnname(), dic.getOpttype(), dic.getMemo()));
            }
            return this.getResponseData(buffer.toString());
        }
        return this.getResponseData("");
    }

    @GetMapping(value={"/api/dict/option/enum/format"})
    @ResponseBody
    public ResponseData<String> formatOptionEnumEmpty() {
        int num = ((DictOptionEnumService)this.getService()).formatOptionEnumEmpty();
        return this.getResponseData("S");
    }

    @RequestMapping(value={"/osrv/eval/dicts"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<DictOptionEnumDTO>> queryAppDictOptionList(DictOptionEnumDTO dictOptionEnum) {
        List outputVo = ((DictOptionEnumService)this.getService()).queryAppDictOptionList(dictOptionEnum);
        return this.getResponseData(outputVo);
    }
}

