/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dam.console.web.controller.api;

import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableInfoService;
import com.irdstudio.allinrdm.dam.console.facade.PubDbmsDatatypeService;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableInfoDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.PubDbmsDatatypeDTO;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class PubDbmsDatatypeController
extends BaseController<PubDbmsDatatypeDTO, PubDbmsDatatypeService> {
    @Autowired
    private ModelTableInfoService modelTableInfoService;
    @Autowired
    private PaasAppsInfoService paasAppsInfoService;

    @PostMapping(value={"/api/pub/dbms/datatype"})
    @ResponseBody
    public ResponseData<Integer> insertPubDbmsDatatype(@RequestBody PubDbmsDatatypeDTO inPubDbmsDatatypeVo) {
        int outputVo = ((PubDbmsDatatypeService)this.getService()).insert((Object)inPubDbmsDatatypeVo);
        return this.getResponseData(outputVo);
    }

    @DeleteMapping(value={"/api/pub/dbms/datatype"})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody PubDbmsDatatypeDTO inPubDbmsDatatypeVo) {
        int outputVo = ((PubDbmsDatatypeService)this.getService()).deleteByPk((Object)inPubDbmsDatatypeVo);
        return this.getResponseData(outputVo);
    }

    @PutMapping(value={"/api/pub/dbms/datatype"})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody PubDbmsDatatypeDTO inPubDbmsDatatypeVo) {
        int outputVo = ((PubDbmsDatatypeService)this.getService()).updateByPk((Object)inPubDbmsDatatypeVo);
        return this.getResponseData(outputVo);
    }

    @GetMapping(value={"/api/pub/dbms/datatype/{dbmsId}/{datatypeId}"})
    @ResponseBody
    public ResponseData<PubDbmsDatatypeDTO> queryByPk(@PathVariable(value="dbmsId") Integer dbmsId, @PathVariable(value="datatypeId") Integer datatypeId) {
        PubDbmsDatatypeDTO inVo = new PubDbmsDatatypeDTO();
        inVo.setDbmsId(dbmsId);
        inVo.setDatatypeId(datatypeId);
        PubDbmsDatatypeDTO outputVo = (PubDbmsDatatypeDTO)((PubDbmsDatatypeService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/pub/dbms/datatypes"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PubDbmsDatatypeDTO>> queryPubDbmsDatatypeAll(PubDbmsDatatypeDTO vo) {
        List outputVo = null;
        this.setUserInfoToVO(vo);
        outputVo = ((PubDbmsDatatypeService)this.getService()).queryListByPage((Object)vo);
        if (CollectionUtils.isNotEmpty((Collection)outputVo)) {
            for (PubDbmsDatatypeDTO dd : outputVo) {
                if (dd.getDatatypeId() == null) continue;
                dd.setDatatypeName(dd.getDatatypeId().toString());
            }
        }
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/pub/dbms/datatypes/refs"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PubDbmsDatatypeDTO>> queryDbmsDatatypeRefByPage(PubDbmsDatatypeDTO vo) {
        List outputVo = null;
        this.setUserInfoToVO(vo);
        outputVo = ((PubDbmsDatatypeService)this.getService()).queryDbmsDatatypeRefByPage(vo);
        if (CollectionUtils.isNotEmpty((Collection)outputVo)) {
            for (PubDbmsDatatypeDTO dd : outputVo) {
                if (dd.getDatatypeId() == null) continue;
                dd.setDatatypeName(dd.getDatatypeId().toString());
            }
        }
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/pub/dbms/datatypes/objectid/{objectId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PubDbmsDatatypeDTO>> queryPubDbmsDatatypeAllByObjectId(@PathVariable(value="objectId") String objectId) {
        ModelTableInfoDTO tableParam = new ModelTableInfoDTO();
        tableParam.setObjectId(objectId);
        tableParam = (ModelTableInfoDTO)this.modelTableInfoService.queryByPk((Object)tableParam);
        if (tableParam != null && StringUtils.isNotBlank((CharSequence)tableParam.getAppId())) {
            PaasAppsInfoDTO tmParam = new PaasAppsInfoDTO();
            tmParam.setAppId(tableParam.getAppId());
            tmParam = (PaasAppsInfoDTO)this.paasAppsInfoService.queryByPk((Object)tmParam);
            if (tmParam != null) {
                PubDbmsDatatypeDTO pubParam = new PubDbmsDatatypeDTO();
                pubParam.setDbmsId(Integer.valueOf(NumberUtils.toInt((String)tmParam.getBizDbDbms(), (int)425)));
                ArrayList<PubDbmsDatatypeDTO> dbmsTypes = ((PubDbmsDatatypeService)this.getService()).queryList((Object)pubParam);
                if (CollectionUtils.isNotEmpty((Collection)dbmsTypes)) {
                    ArrayList<PubDbmsDatatypeDTO> list = new ArrayList<PubDbmsDatatypeDTO>();
                    HashMap<String, PubDbmsDatatypeDTO> map = new HashMap<String, PubDbmsDatatypeDTO>();
                    for (PubDbmsDatatypeDTO v : dbmsTypes) {
                        if (map.get(v.getDbmsDatatypeCode()) != null) continue;
                        list.add(v);
                        map.put(v.getDbmsDatatypeCode(), v);
                    }
                    dbmsTypes = list;
                }
                return this.getResponseData(dbmsTypes);
            }
            return this.getResponseData(new ArrayList(0));
        }
        return this.getResponseData(new ArrayList(0));
    }

    @RequestMapping(value={"/client/PubDbmsDatatypeService/queryDbmsTypeByModelTableInfoObjectId"}, method={RequestMethod.POST})
    @ResponseBody
    public List<PubDbmsDatatypeDTO> queryDbmsTypeByModelTableInfoObjectId_client(@RequestParam(value="objectId") String objectId) {
        return ((PubDbmsDatatypeService)this.getService()).queryDbmsTypeByModelTableInfoObjectId(objectId);
    }

    @RequestMapping(value={"/client/PubDbmsDatatypeService/queryDbmsType"}, method={RequestMethod.GET})
    @ResponseBody
    public PubDbmsDatatypeDTO queryDbmsType(@RequestParam(value="objectId") String objectId, @RequestParam(value="dataTypeId") String dataTypeId) {
        return ((PubDbmsDatatypeService)this.getService()).queryDbmsType(objectId, dataTypeId);
    }

    @RequestMapping(value={"/client/PubDbmsDatatypeService/queryDbmsTypeByCode"}, method={RequestMethod.GET})
    @ResponseBody
    public PubDbmsDatatypeDTO queryDbmsTypeByCode(@RequestParam(value="objectId") String objectId, @RequestParam(value="dbmsDatatypeCode") String dbmsDatatypeCode) {
        return ((PubDbmsDatatypeService)this.getService()).queryDbmsTypeByCode(objectId, dbmsDatatypeCode);
    }
}

