/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.web.controller.api;

import com.irdstudio.allinrdm.dam.console.facade.ModelTableFieldService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableInfoService;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableFieldDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.QryModelTableService;
import com.irdstudio.allinrdm.dev.console.facade.dto.QryModelTableDTO;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class QryModelTableController
extends BaseController<QryModelTableDTO, QryModelTableService> {
    @Autowired
    private ModelTableInfoService modelTableInfoService;
    @Autowired
    private ModelTableFieldService modelTableFieldService;

    @RequestMapping(value={"/api/qry/model/tables"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<QryModelTableDTO>> queryQryModelTableAll(QryModelTableDTO vo) {
        List outputDTO = ((QryModelTableService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputDTO);
    }

    @RequestMapping(value={"/api/qry/model/table/{qryId}/{tableModelId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<QryModelTableDTO> queryByPk(@PathVariable(value="qryId") String qryId, @PathVariable(value="tableModelId") String tableModelId) {
        QryModelTableDTO inDTO = new QryModelTableDTO();
        inDTO.setQryId(qryId);
        inDTO.setTableModelId(tableModelId);
        QryModelTableDTO outputDTO = (QryModelTableDTO)((QryModelTableService)this.getService()).queryByPk((Object)inDTO);
        return this.getResponseData(outputDTO);
    }

    @RequestMapping(value={"/api/qry/model/table"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody QryModelTableDTO inQryModelTableDTO) {
        int outputDTO = ((QryModelTableService)this.getService()).deleteByPk((Object)inQryModelTableDTO);
        return this.getResponseData(outputDTO);
    }

    @RequestMapping(value={"/api/qry/model/table"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody QryModelTableDTO inQryModelTableDTO) {
        inQryModelTableDTO.setLastUpdateUser(inQryModelTableDTO.getLoginUserId());
        inQryModelTableDTO.setLastUpdateTime(CurrentDateUtil.getTodayDateEx2());
        int outputDTO = ((QryModelTableService)this.getService()).updateByPk((Object)inQryModelTableDTO);
        return this.getResponseData(outputDTO);
    }

    @RequestMapping(value={"/api/qry/model/table"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertQryModelTable(@RequestBody QryModelTableDTO inQryModelTableDTO) {
        inQryModelTableDTO.setCreateUser(inQryModelTableDTO.getLoginUserId());
        inQryModelTableDTO.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        int outputDTO = ((QryModelTableService)this.getService()).insert((Object)inQryModelTableDTO);
        return this.getResponseData(outputDTO);
    }

    @RequestMapping(value={"/api/qry/model/tables/tree"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> qryModelModelFields(@RequestBody QryModelTableDTO inQryModelTableDTO) {
        ModelTableInfoDTO tableParam = new ModelTableInfoDTO();
        tableParam.setReferenceId(inQryModelTableDTO.getQryId());
        tableParam.setSize(Integer.valueOf(Integer.MAX_VALUE));
        List tableList = this.modelTableInfoService.queryListByPage((Object)tableParam);
        ArrayList<Map> outputDTO = new ArrayList<Map>();
        if (CollectionUtils.isNotEmpty((Collection)tableList)) {
            for (ModelTableInfoDTO m : tableList) {
                Map tbMap = BeanUtility.bean2Map((Object)m);
                ModelTableFieldDTO fieldParam = new ModelTableFieldDTO();
                fieldParam.setObjectId(m.getObjectId());
                List fieldList = this.modelTableFieldService.queryList((Object)fieldParam);
                tbMap.put("fieldList", fieldList);
                outputDTO.add(tbMap);
            }
        }
        return this.getResponseData(outputDTO);
    }
}

