/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.sam.console.web.controller.api;

import com.irdstudio.allinrdm.sam.console.facade.SolFolderInfoService;
import com.irdstudio.allinrdm.sam.console.facade.dto.SolFolderInfoDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class SolFolderInfoController
extends BaseController<SolFolderInfoDTO, SolFolderInfoService> {
    @RequestMapping(value={"/api/sol/folder/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SolFolderInfoDTO>> querySolFolderInfoAll(SolFolderInfoDTO dto) {
        List outputVo = ((SolFolderInfoService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/sol/folder/infos/list"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SolFolderInfoDTO>> queryList(SolFolderInfoDTO dto) {
        List outputVo = ((SolFolderInfoService)this.getService()).queryList((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/sol/folder/info/{folderId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<SolFolderInfoDTO> queryByPk(@PathVariable(value="folderId") String folderId) {
        SolFolderInfoDTO inVo = new SolFolderInfoDTO();
        inVo.setFolderId(folderId);
        SolFolderInfoDTO outputVo = (SolFolderInfoDTO)((SolFolderInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/sol/folder/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody SolFolderInfoDTO inSolFolderInfoDTO) {
        int outputVo = ((SolFolderInfoService)this.getService()).deleteByPk((Object)inSolFolderInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/sol/folder/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody SolFolderInfoDTO inSolFolderInfoDTO) {
        this.setUserInfoToVO(inSolFolderInfoDTO);
        String userId = this.getUserInfo().getUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        inSolFolderInfoDTO.setLastModifyUser(userId);
        inSolFolderInfoDTO.setLastModifyTime(now);
        int outputVo = ((SolFolderInfoService)this.getService()).updateByPk((Object)inSolFolderInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/sol/folder/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertSolFolderInfo(@RequestBody SolFolderInfoDTO inSolFolderInfoDTO) {
        this.setUserInfoToVO(inSolFolderInfoDTO);
        String userId = this.getUserInfo().getUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        inSolFolderInfoDTO.setCreateUser(userId);
        inSolFolderInfoDTO.setCreateTime(now);
        inSolFolderInfoDTO.setLastModifyUser(userId);
        inSolFolderInfoDTO.setLastModifyTime(now);
        if (StringUtils.isBlank((CharSequence)inSolFolderInfoDTO.getFolderId())) {
            inSolFolderInfoDTO.setFolderId(UUIDUtil.getShortUUID());
        }
        int outputVo = ((SolFolderInfoService)this.getService()).insert((Object)inSolFolderInfoDTO);
        return this.getResponseData(outputVo);
    }

    @PostMapping(value={"/api/sol/folder/info/merge"})
    @ResponseBody
    public ResponseData<Integer> folderMerge(@RequestBody SolFolderInfoDTO paramDTO, @RequestParam(value="type") String type) {
        this.setUserInfoToVO(paramDTO);
        int outputVo = ((SolFolderInfoService)this.getService()).folderMerge(paramDTO, type);
        return this.getResponseData(outputVo);
    }

    @PostMapping(value={"/api/sol/folder/info/move"})
    @ResponseBody
    public ResponseData<Integer> folderMove(@RequestBody SolFolderInfoDTO paramDTO) {
        this.setUserInfoToVO(paramDTO);
        int outputVo = ((SolFolderInfoService)this.getService()).folderMove(paramDTO);
        return this.getResponseData(outputVo);
    }
}

