/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.wiki.console.web.controller.api;

import com.irdstudio.allinrdm.wiki.console.facade.WikiSubsDirectoryService;
import com.irdstudio.allinrdm.wiki.console.facade.dto.WikiSubsDirectoryDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class WikiSubsDirectoryController
extends BaseController<WikiSubsDirectoryDTO, WikiSubsDirectoryService> {
    @Autowired
    @Qualifier(value="wikiSubsDirectoryServiceImpl")
    private WikiSubsDirectoryService wikiSubsDirectoryService;

    @RequestMapping(value={"/api/wiki/subs/directory/view"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<WikiSubsDirectoryDTO>> queryWikiSubsDirectoryAndCheck(@RequestBody WikiSubsDirectoryDTO vo) {
        List outputVo = this.wikiSubsDirectoryService.queryWikiSubsDirectoryAndCheck(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/wiki/subs/directorys"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<WikiSubsDirectoryDTO>> queryWikiSubsDirectoryAll(WikiSubsDirectoryDTO vo) {
        List outputVo = this.wikiSubsDirectoryService.queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/wiki/subs/directory/{dirId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<WikiSubsDirectoryDTO> queryByPk(@PathVariable(value="dirId") String dirId) {
        WikiSubsDirectoryDTO inVo = new WikiSubsDirectoryDTO();
        inVo.setDirId(dirId);
        WikiSubsDirectoryDTO outputVo = (WikiSubsDirectoryDTO)this.wikiSubsDirectoryService.queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/wiki/subs/directory"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody WikiSubsDirectoryDTO inWikiSubsDirectoryDTO) {
        int outputVo = this.wikiSubsDirectoryService.deleteByPk((Object)inWikiSubsDirectoryDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/wiki/subs/directory"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody WikiSubsDirectoryDTO inWikiSubsDirectoryDTO) {
        int outputVo = this.wikiSubsDirectoryService.updateByPk((Object)inWikiSubsDirectoryDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/wiki/subs/directory"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertWikiSubsDirectory(@RequestBody WikiSubsDirectoryDTO inWikiSubsDirectoryDTO) {
        if (StringUtils.isBlank((CharSequence)inWikiSubsDirectoryDTO.getDirId())) {
            inWikiSubsDirectoryDTO.setDirId(UUIDUtil.getUUID());
        }
        inWikiSubsDirectoryDTO.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        inWikiSubsDirectoryDTO.setCreateUser(inWikiSubsDirectoryDTO.getLoginUserId());
        int outputVo = this.wikiSubsDirectoryService.insert((Object)inWikiSubsDirectoryDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/client/WikiSubsDirectoryService/deleteByCond"}, method={RequestMethod.POST})
    @ResponseBody
    public Integer deleteByCond(@RequestBody WikiSubsDirectoryDTO param) {
        return ((WikiSubsDirectoryService)this.getService()).deleteByCond(param);
    }
}

