/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.admin.console.web.controller.api;

import com.irdstudio.allinrdm.admin.console.facade.RdmWeeklyCalendarService;
import com.irdstudio.allinrdm.admin.console.facade.dto.RdmWeeklyCalendarDTO;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class RdmWeeklyCalendarController
extends BaseController<RdmWeeklyCalendarDTO, RdmWeeklyCalendarService> {
    @RequestMapping(value={"/api/rdm/weekly/calendars"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<RdmWeeklyCalendarDTO>> queryRdmWeeklyCalendarAll(RdmWeeklyCalendarDTO dto) {
        List outputVo = ((RdmWeeklyCalendarService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/weekly/calendars/list"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<RdmWeeklyCalendarDTO>> queryList(RdmWeeklyCalendarDTO dto) {
        List outputVo = ((RdmWeeklyCalendarService)this.getService()).queryList((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/weekly/calendar/{weekId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<RdmWeeklyCalendarDTO> queryByPk(@PathVariable(value="weekId") Integer weekId) {
        RdmWeeklyCalendarDTO inVo = new RdmWeeklyCalendarDTO();
        inVo.setWeekId(weekId);
        RdmWeeklyCalendarDTO outputVo = (RdmWeeklyCalendarDTO)((RdmWeeklyCalendarService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/weekly/calendar"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody RdmWeeklyCalendarDTO inRdmWeeklyCalendarDTO) {
        int outputVo = ((RdmWeeklyCalendarService)this.getService()).deleteByPk((Object)inRdmWeeklyCalendarDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/weekly/calendar"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody RdmWeeklyCalendarDTO inRdmWeeklyCalendarDTO) {
        int outputVo = ((RdmWeeklyCalendarService)this.getService()).updateByPk((Object)inRdmWeeklyCalendarDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/weekly/calendar"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertRdmWeeklyCalendar(@RequestBody RdmWeeklyCalendarDTO inRdmWeeklyCalendarDTO) {
        int outputVo = ((RdmWeeklyCalendarService)this.getService()).insert((Object)inRdmWeeklyCalendarDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/weekly/calendar/batch"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertRdmWeeklyCalendarBatch(@RequestBody RdmWeeklyCalendarDTO inRdmWeeklyCalendarDTO) {
        Integer year = inRdmWeeklyCalendarDTO.getYear();
        if (year == null && year < 1997) {
            return this.getResponseData(null, "\u521d\u59cb\u5316\u6210\u529f", "\u5e74\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.getResponseData(((RdmWeeklyCalendarService)this.getService()).initOneYearCalendar(year));
    }

    @RequestMapping(value={"/api/rdm/weekly/calendar/this/week"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<RdmWeeklyCalendarDTO> initThisWeekCalendar(@RequestParam(value="date") String date) {
        RdmWeeklyCalendarDTO outputVo = ((RdmWeeklyCalendarService)this.getService()).initThisWeekCalendar(date);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/client/RdmWeeklyCalendarService/initThisWeekCalendar"}, method={RequestMethod.POST})
    @ResponseBody
    public RdmWeeklyCalendarDTO initThisWeekCalendar_client(@RequestParam(value="date") String date) {
        return ((RdmWeeklyCalendarService)this.getService()).initThisWeekCalendar(date);
    }

    @RequestMapping(value={"/api/rdm/weekly/calendars/no/work/days"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> queryNoWorkDays(@RequestBody Map<String, Object> param) {
        List outputVo = ((RdmWeeklyCalendarService)this.getService()).queryNoWorkDays(param);
        return this.getResponseData(outputVo);
    }
}

