/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.web.controller.api;

import com.irdstudio.allinrdm.dev.console.facade.AppModelTreeService;
import com.irdstudio.allinrdm.dev.console.facade.dto.AppModelTreeDTO;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.EasyUITreeData;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class AppModelTreeController
extends BaseController<AppModelTreeDTO, AppModelTreeService> {
    @PostMapping(value={"/api/app/model/tree/{appId}"})
    @ResponseBody
    public ResponseData<Integer> insertAppModelTree(@PathVariable(value="appId") String appId, @RequestBody AppModelTreeDTO inAppModelTreeDTO) {
        inAppModelTreeDTO.setPackageId(UUIDUtil.getUUID());
        inAppModelTreeDTO.setAppId(appId);
        int outputDTO = ((AppModelTreeService)this.getService()).insert((Object)inAppModelTreeDTO);
        return this.getResponseData(outputDTO);
    }

    @DeleteMapping(value={"/api/app/model/tree/{appId}"})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@PathVariable(value="appId") String appId, @RequestBody AppModelTreeDTO inAppModelTreeDTO) {
        inAppModelTreeDTO.setAppId(appId);
        int outputDTO = ((AppModelTreeService)this.getService()).deleteByPk((Object)inAppModelTreeDTO);
        return this.getResponseData(outputDTO);
    }

    @PutMapping(value={"/api/app/model/tree/{appId}"})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@PathVariable(value="appId") String appId, @RequestBody AppModelTreeDTO inAppModelTreeDTO) {
        inAppModelTreeDTO.setAppId(appId);
        int outputDTO = ((AppModelTreeService)this.getService()).updateByPk((Object)inAppModelTreeDTO);
        return this.getResponseData(outputDTO);
    }

    @GetMapping(value={"/api/app/model/tree/{packageId}/{appId}"})
    @ResponseBody
    public ResponseData<AppModelTreeDTO> queryByPk(@PathVariable(value="appId") String appId, @PathVariable(value="packageId") String packageId) {
        AppModelTreeDTO inDTO = new AppModelTreeDTO();
        inDTO.setPackageId(packageId);
        inDTO.setAppId(appId);
        AppModelTreeDTO outputDTO = (AppModelTreeDTO)((AppModelTreeService)this.getService()).queryByPk((Object)inDTO);
        return this.getResponseData(outputDTO);
    }

    @RequestMapping(value={"/api/app/model/trees/{appId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<AppModelTreeDTO>> queryAppModelTreeAll(@PathVariable(value="appId") String appId, AppModelTreeDTO vo) {
        List outputDTO = null;
        vo.setAppId(appId);
        outputDTO = ((AppModelTreeService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputDTO);
    }

    @GetMapping(value={"/api/app/model/tree/nav/{appId}"})
    public void queryTreeSWithAppId(@PathVariable(value="appId") String appId, HttpServletResponse response) {
        EasyUITreeData treeData = ((AppModelTreeService)this.getService()).queryTreeData(appId, new AppModelTreeDTO());
        StringBuffer jsonBuf = new StringBuffer();
    }

    @PostMapping(value={"/api/app/model/tree/nav/{appId}/catalog"})
    @ResponseBody
    public List<EasyUITreeData> queryTreeSWithAppTree(@PathVariable(value="appId") String appId, AppModelTreeDTO appModelTreeDTO) {
        List treeData = ((AppModelTreeService)this.getService()).queryTreeDataWithSingle(appId, appModelTreeDTO);
        return treeData;
    }

    @RequestMapping(value={"/client/AppModelTreeService/deleteByCond"}, method={RequestMethod.POST})
    @ResponseBody
    public Integer deleteByCond(@RequestBody AppModelTreeDTO param) {
        return ((AppModelTreeService)this.getService()).deleteByCond(param);
    }
}

