/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.web.controller.api;

import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.design.console.types.AppType;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableFieldService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableInfoService;
import com.irdstudio.allinrdm.dam.console.facade.PubDbmsDatatypeService;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableFieldDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.PubDbmsDatatypeDTO;
import com.irdstudio.allinrdm.dev.console.facade.SrvEvalFuncService;
import com.irdstudio.allinrdm.dev.console.facade.SrvModelInfoService;
import com.irdstudio.allinrdm.dev.console.facade.SrvModelPackageService;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvEvalFuncDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvModelInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvModelPackageDTO;
import com.irdstudio.sdk.beans.core.util.MapBeanUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class SrvEvalFuncController
extends BaseController<SrvEvalFuncDTO, SrvEvalFuncService> {
    @Autowired
    @Qualifier(value="srvEvalFuncServiceImpl")
    private SrvEvalFuncService srvEvalFuncService;
    @Autowired
    private PaasAppsInfoService paasAppsInfoService;
    @Autowired
    @Qualifier(value="srvModelPackageServiceImpl")
    private SrvModelPackageService srvModelPackageService;
    @Autowired
    @Qualifier(value="srvModelInfoServiceImpl")
    private SrvModelInfoService srvModelInfoService;
    @Autowired
    private PubDbmsDatatypeService pubDbmsDatatypeService;
    @Autowired
    private ModelTableFieldService modelTableFieldService;
    @Autowired
    private ModelTableInfoService modelTableInfoService;

    @RequestMapping(value={"/api/srv/eval/funcs"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SrvEvalFuncDTO>> querySrvEvalFuncAll(SrvEvalFuncDTO vo) {
        List outputVo = this.srvEvalFuncService.queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/eval/func/{targetRecordKeyid}/{funcFieldId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<SrvEvalFuncDTO> queryByPk(@PathVariable(value="targetRecordKeyid") String targetRecordKeyid, @PathVariable(value="funcFieldId") String funcFieldId) {
        SrvEvalFuncDTO inVo = new SrvEvalFuncDTO();
        inVo.setTargetRecordKeyid(targetRecordKeyid);
        inVo.setFuncFieldId(funcFieldId);
        SrvEvalFuncDTO outputVo = (SrvEvalFuncDTO)this.srvEvalFuncService.queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/eval/func"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody SrvEvalFuncDTO inSrvEvalFuncVo) {
        int outputVo = this.srvEvalFuncService.deleteByPk((Object)inSrvEvalFuncVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/eval/func/target"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByTargetRecordKeyid(@RequestBody SrvEvalFuncDTO inSrvEvalFuncVo) {
        int outputVo = this.srvEvalFuncService.deleteByTargetRecordKeyid(inSrvEvalFuncVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/eval/func"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody SrvEvalFuncDTO inSrvEvalFuncVo) {
        int outputVo = this.srvEvalFuncService.updateByPk((Object)inSrvEvalFuncVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/eval/func"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertSrvEvalFunc(@RequestBody SrvEvalFuncDTO inSrvEvalFuncVo) {
        int outputVo = this.srvEvalFuncService.insert((Object)inSrvEvalFuncVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/eval/funcs/index"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> querySrvFuncAppsNav(@RequestParam(value="fieldId") String fieldId, @RequestParam(value="funcResutlType", required=false) Integer funcResultType) {
        ModelTableFieldDTO field = new ModelTableFieldDTO();
        field.setFieldId(fieldId);
        field = (ModelTableFieldDTO)this.modelTableFieldService.queryByPk((Object)field);
        if (field == null) {
            return this.getResponseData(null);
        }
        PubDbmsDatatypeDTO middleType = this.pubDbmsDatatypeService.queryDbmsTypeByCode(field.getObjectId(), field.getFieldType());
        if (middleType == null) {
            return this.getResponseData(null);
        }
        funcResultType = middleType.getDatatypeId();
        PaasAppsInfoDTO appParam = new PaasAppsInfoDTO();
        appParam.setAppType(AppType.A10.getCode());
        appParam.setSize(Integer.valueOf(1000));
        List funcAppList = this.paasAppsInfoService.queryListByPage((Object)appParam);
        ArrayList<Map> navRoots = new ArrayList<Map>();
        if (CollectionUtils.isNotEmpty((Collection)funcAppList)) {
            for (PaasAppsInfoDTO funcApp : funcAppList) {
                Map funcNode = MapBeanUtil.beanToMap((Object)funcApp);
                funcNode.put("id", funcApp.getAppId());
                funcNode.put("text", funcApp.getAppName());
                funcNode.put("iconCls", "icon iconfont icon-yingyong");
                funcNode.put("children", new ArrayList());
                HashMap<String, Map> nodeMap = new HashMap<String, Map>();
                nodeMap.put(funcApp.getAppId(), funcNode);
                SrvModelPackageDTO packageParam = new SrvModelPackageDTO();
                packageParam.setAppId(funcApp.getAppId());
                packageParam.setSize(Integer.valueOf(1000));
                List packageList = this.srvModelPackageService.queryList((Object)packageParam);
                if (CollectionUtils.isNotEmpty((Collection)packageList)) {
                    for (SrvModelPackageDTO packageVO : packageList) {
                        Map packageNode = MapBeanUtil.beanToMap((Object)packageVO);
                        packageNode.put("id", packageVO.getPackageId());
                        packageNode.put("text", packageVO.getPackageName());
                        packageNode.put("iconCls", "icon iconfont icon-tree");
                        packageNode.put("children", new ArrayList());
                        if (StringUtils.isBlank((CharSequence)packageVO.getPackageAbvId())) {
                            packageNode.put("packageAbvId", funcApp.getAppId());
                            packageVO.setPackageAbvId(funcApp.getAppId());
                        }
                        nodeMap.put(packageVO.getPackageId(), packageNode);
                    }
                    for (SrvModelPackageDTO packageVO : packageList) {
                        if (nodeMap.get(packageVO.getPackageAbvId()) == null) continue;
                        Map parentNode = (Map)nodeMap.get(packageVO.getPackageAbvId());
                        Map packageNode = (Map)nodeMap.get(packageVO.getPackageId());
                        List children = (List)parentNode.get("children");
                        children.add(packageNode);
                    }
                }
                SrvModelInfoDTO modelParam = new SrvModelInfoDTO();
                modelParam.setAppId(funcApp.getAppId());
                modelParam.setFuncResultType(funcResultType);
                modelParam.setSize(Integer.valueOf(1000));
                List srvModelList = this.srvModelInfoService.queryList((Object)modelParam);
                if (CollectionUtils.isNotEmpty((Collection)srvModelList)) {
                    for (SrvModelInfoDTO srvModelInfo : srvModelList) {
                        Map srvMap = MapBeanUtil.beanToMap((Object)srvModelInfo);
                        srvMap.put("id", srvModelInfo.getSrvModelId());
                        srvMap.put("text", srvModelInfo.getSrvModelName());
                        srvMap.put("appCode", funcApp.getAppCode());
                        srvMap.put("appName", funcApp.getAppName());
                        srvMap.put("iconCls", "icon iconfont icon-form");
                        Map parentNode = (Map)nodeMap.get(srvModelInfo.getPackageId());
                        if (parentNode == null) {
                            // empty if block
                        }
                        List children = (List)parentNode.get("children");
                        children.add(srvMap);
                    }
                }
                navRoots.add(funcNode);
            }
        }
        return this.getResponseData(navRoots);
    }

    @RequestMapping(value={"/api/srv/eval/funcs/check"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SrvEvalFuncDTO>> queryAndCheck(@RequestParam(value="funcSrvModelId") String funcSrvModelId, @RequestParam(value="reGenFlag") boolean reGenFlag, @RequestBody SrvEvalFuncDTO vo) {
        List outputVo = this.srvEvalFuncService.queryAndCheck(funcSrvModelId, Boolean.valueOf(reGenFlag), vo);
        return this.getResponseData(outputVo);
    }
}

