/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.web.controller.api;

import com.irdstudio.allinrdm.dev.console.facade.SrvModelInfoService;
import com.irdstudio.allinrdm.dev.console.facade.SrvModelPackageService;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvModelInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvModelPackageDTO;
import com.irdstudio.allinrdm.dev.console.types.SrvPackageType;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.vo.EasyUITreeData;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class SrvModelPackageController
extends BaseController<SrvModelPackageDTO, SrvModelPackageService> {
    @Autowired
    @Qualifier(value="srvModelInfoServiceImpl")
    private SrvModelInfoService srvModelInfoService;

    @RequestMapping(value={"/api/srv/model/packages"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SrvModelPackageDTO>> querySrvModelPackageAll(SrvModelPackageDTO vo) {
        if (StringUtils.contains((CharSequence)vo.getPackageType(), (CharSequence)",")) {
            vo.setPackageTypes(Arrays.asList(StringUtils.split((String)vo.getPackageType(), (String)",")));
            vo.setPackageType(null);
        }
        List outputVo = ((SrvModelPackageService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/model/packages/list"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SrvModelPackageDTO>> queryList(SrvModelPackageDTO vo) {
        List outputVo = ((SrvModelPackageService)this.getService()).queryList((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/model/package/{packageId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<SrvModelPackageDTO> queryByPk(@PathVariable(value="packageId") String packageId) {
        SrvModelPackageDTO inVo = new SrvModelPackageDTO();
        inVo.setPackageId(packageId);
        SrvModelPackageDTO outputVo = (SrvModelPackageDTO)((SrvModelPackageService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/model/package"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody SrvModelPackageDTO inSrvModelPackageVo) {
        SrvModelInfoDTO infoParam = new SrvModelInfoDTO();
        infoParam.setAppId(inSrvModelPackageVo.getAppId());
        infoParam.setPackageId(inSrvModelPackageVo.getPackageId());
        List infoList = this.srvModelInfoService.queryListByPage((Object)infoParam);
        if (CollectionUtils.isNotEmpty((Collection)infoList)) {
            ResponseData result = this.getResponseData(-1);
            result.setMessage("\u5f53\u524d\u5206\u7ec4\u4e0b\u5b58\u5728\u670d\u52a1\uff0c\u4e0d\u80fd\u5220\u9664");
            return result;
        }
        int outputVo = ((SrvModelPackageService)this.getService()).deleteByPk((Object)inSrvModelPackageVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/model/package"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody SrvModelPackageDTO inSrvModelPackageVo) {
        this.setUserInfoToVO(inSrvModelPackageVo);
        inSrvModelPackageVo.setLastModifyUser(inSrvModelPackageVo.getLoginUserId());
        inSrvModelPackageVo.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((SrvModelPackageService)this.getService()).updateByPk((Object)inSrvModelPackageVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/model/package"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertSrvModelPackage(@RequestBody SrvModelPackageDTO inSrvModelPackageVo) {
        this.setUserInfoToVO(inSrvModelPackageVo);
        inSrvModelPackageVo.setCreateUser(inSrvModelPackageVo.getLoginUserId());
        inSrvModelPackageVo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        inSrvModelPackageVo.setLastModifyUser(inSrvModelPackageVo.getLoginUserId());
        inSrvModelPackageVo.setLastModifyTime(inSrvModelPackageVo.getCreateTime());
        int outputVo = ((SrvModelPackageService)this.getService()).insert((Object)inSrvModelPackageVo);
        return this.getResponseData(outputVo);
    }

    @PostMapping(value={"/api/srv/model/package/app"})
    @ResponseBody
    public List<Object> queryTree(@RequestParam(name="appId", required=true) String appId, @RequestParam(name="root", required=false) String root) {
        SrvModelPackageDTO param = new SrvModelPackageDTO();
        param.setAppId(appId);
        param.setSize(Integer.valueOf(1000));
        List packageList = ((SrvModelPackageService)this.getService()).queryList((Object)param);
        ArrayList<Object> result = new ArrayList<Object>();
        ArrayList<EasyUITreeData> treeData = new ArrayList<EasyUITreeData>();
        if (CollectionUtils.isNotEmpty((Collection)packageList)) {
            HashMap<String, EasyUITreeData> treeMap = new HashMap<String, EasyUITreeData>();
            treeData = new ArrayList();
            ArrayList<EasyUITreeData> treeDataList = new ArrayList<EasyUITreeData>();
            for (SrvModelPackageDTO vo : packageList) {
                EasyUITreeData node = this.generateTreeData(vo);
                treeMap.put(node.getId(), node);
                treeDataList.add(node);
            }
            for (EasyUITreeData node : treeDataList) {
                if (treeMap.get(node.getpId()) != null) {
                    EasyUITreeData parent = (EasyUITreeData)treeMap.get(node.getpId());
                    if (parent.getChildren() == null) {
                        parent.setChildren(new ArrayList());
                    }
                    parent.getChildren().add(node);
                    continue;
                }
                treeData.add(node);
            }
            ArrayList<EasyUITreeData> inner = new ArrayList<EasyUITreeData>(treeData.size());
            ArrayList<EasyUITreeData> inf = new ArrayList<EasyUITreeData>(treeData.size());
            ArrayList<EasyUITreeData> back = new ArrayList<EasyUITreeData>(treeData.size());
            for (EasyUITreeData t : treeData) {
                if (StringUtils.equals((CharSequence)SrvPackageType.ComponentServer.getCode(), (CharSequence)MapUtils.getString((Map)t.getAttributes(), (Object)"packageType"))) {
                    t.setpId(SrvPackageType.ComponentServer.getCode());
                    inner.add(t);
                    continue;
                }
                if (StringUtils.equals((CharSequence)SrvPackageType.BackServer.getCode(), (CharSequence)MapUtils.getString((Map)t.getAttributes(), (Object)"packageType"))) {
                    t.setpId(SrvPackageType.BackServer.getCode());
                    back.add(t);
                    continue;
                }
                t.setpId(SrvPackageType.InterfaceServer.getCode());
                inf.add(t);
            }
            result.add(inner);
            result.add(inf);
            result.add(back);
        }
        return result;
    }

    private EasyUITreeData generateTreeData(SrvModelPackageDTO packageVO) {
        EasyUITreeData treeData = new EasyUITreeData();
        treeData.setId(packageVO.getPackageId());
        treeData.setText(packageVO.getPackageName());
        treeData.setpId(packageVO.getPackageAbvId());
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("package_code", packageVO.getPackageCode());
        attributes.put("packageType", packageVO.getPackageType());
        attributes.put("package_type", "PA0101");
        treeData.setAttributes(attributes);
        return treeData;
    }
}

