/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.web.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.irdstudio.allinapaas.deliver.console.facade.PaasEcsInfoService;
import com.irdstudio.allinrdm.dev.console.facade.SrvTestCaseService;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvTestCaseDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
@RequestMapping(value={"/"})
public class SrvTestCaseController
extends BaseController<SrvTestCaseDTO, SrvTestCaseService> {
    @Autowired
    @Qualifier(value="srvTestCaseServiceImpl")
    private SrvTestCaseService srvTestCaseService;
    @Autowired
    private PaasEcsInfoService paasEcsInfoService;
    private static final String SRV_TEST_FLAG_Y = "Y";
    private static final String SRV_TEST_FLAG_N = "N";
    private static final String EXCEPTION = "exceptionMessage";

    @RequestMapping(value={"/api/srv/test/cases"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SrvTestCaseDTO>> querySrvTestCaseAll(SrvTestCaseDTO vo) {
        List outputVo = this.srvTestCaseService.queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/test/case/{srvCaseId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<SrvTestCaseDTO> queryByPk(@PathVariable(value="srvCaseId") String srvCaseId) {
        SrvTestCaseDTO inVo = new SrvTestCaseDTO();
        inVo.setSrvCaseId(srvCaseId);
        SrvTestCaseDTO outputVo = (SrvTestCaseDTO)this.srvTestCaseService.queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/test/case"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody SrvTestCaseDTO inSrvTestCaseVo) {
        int outputVo = this.srvTestCaseService.deleteByPk((Object)inSrvTestCaseVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/test/case"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody SrvTestCaseDTO inSrvTestCaseVo) {
        inSrvTestCaseVo.setLastUpdateUser(this.getUserInfo().getUserId());
        inSrvTestCaseVo.setLastUpdateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = this.srvTestCaseService.updateByPk((Object)inSrvTestCaseVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/test/case"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertSrvTestCase(@RequestBody SrvTestCaseDTO inSrvTestCaseVo) {
        inSrvTestCaseVo.setSrvCaseId(UUIDUtil.getUUID());
        inSrvTestCaseVo.setCreateUser(this.getUserInfo().getUserId());
        inSrvTestCaseVo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = this.srvTestCaseService.insert((Object)inSrvTestCaseVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/test/cases/appid/page"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SrvTestCaseDTO>> queryAllByAppIdByPage(SrvTestCaseDTO vo) {
        List outputVo = this.srvTestCaseService.queryAllByAppIdByPage(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/srv/test/cases/appid"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SrvTestCaseDTO>> queryAllByAppId(SrvTestCaseDTO vo) {
        List outputVo = this.srvTestCaseService.queryAllByAppId(vo);
        return this.getResponseData(outputVo);
    }

    @Async
    @RequestMapping(value={"/api/srv/test/cases/batch/test/all/{paramValue}"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> testAllByAppId(@RequestBody SrvTestCaseDTO vo, @PathVariable(value="paramValue") String paramValue) {
        List srvTestCaseVOList = this.srvTestCaseService.queryAllByAppId(vo);
        String testEcsUrl = this.paasEcsInfoService.getTestEcsUrl(paramValue);
        int outputVo = 0;
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        for (SrvTestCaseDTO srvTestCaseVO : srvTestCaseVOList) {
            try {
                JSONObject jsonObject = JSONObject.parseObject((String)srvTestCaseVO.getSrvCaseInput());
                HttpEntity request = new HttpEntity((Object)jsonObject, (MultiValueMap)httpHeaders);
                ResponseEntity response = restTemplate.postForEntity(testEcsUrl, (Object)request, JSONObject.class, new Object[0]);
                if (((JSONObject)response.getBody()).containsKey((Object)EXCEPTION)) {
                    srvTestCaseVO.setSrvTestFlag(SRV_TEST_FLAG_N);
                } else {
                    srvTestCaseVO.setSrvTestFlag(SRV_TEST_FLAG_Y);
                }
                srvTestCaseVO.setSrvCaseOutput(JSONObject.toJSONString((Object)response.getBody()));
                srvTestCaseVO.setLastUpdateUser(this.getUserInfo().getUserId());
                srvTestCaseVO.setLastUpdateTime(CurrentDateUtil.getTodayDateEx2());
                srvTestCaseVO.setSrvTestTime(CurrentDateUtil.getTodayDateEx2());
            }
            catch (Exception e) {
                srvTestCaseVO.setSrvTestFlag(SRV_TEST_FLAG_N);
                srvTestCaseVO.setSrvCaseOutput(e.getMessage());
                srvTestCaseVO.setLastUpdateUser(this.getUserInfo().getUserId());
                srvTestCaseVO.setLastUpdateTime(CurrentDateUtil.getTodayDateEx2());
                srvTestCaseVO.setSrvTestTime(CurrentDateUtil.getTodayDateEx2());
            }
            this.srvTestCaseService.updateByPk((Object)srvTestCaseVO);
            ++outputVo;
        }
        return this.getResponseData(outputVo);
    }
}

