/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.project.console.web.controller.api;

import com.irdstudio.allinrdm.project.console.facade.RdmProjectUserService;
import com.irdstudio.allinrdm.project.console.facade.dto.RdmProjectUserDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class RdmProjectUserController
extends BaseController<RdmProjectUserDTO, RdmProjectUserService> {
    @RequestMapping(value={"/api/rdm/project/users"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<RdmProjectUserDTO>> queryRdmProjectMemberAll(RdmProjectUserDTO dto) {
        List outputVo = ((RdmProjectUserService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/project/users/list"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<RdmProjectUserDTO>> queryList(RdmProjectUserDTO dto) {
        List outputVo = ((RdmProjectUserService)this.getService()).queryList((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/project/user"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<RdmProjectUserDTO> queryByPk(@RequestParam(value="projectId") String projectId, @RequestParam(value="userId") String userId) {
        RdmProjectUserDTO inVo = new RdmProjectUserDTO();
        inVo.setProjectId(projectId);
        inVo.setUserId(userId);
        RdmProjectUserDTO outputVo = (RdmProjectUserDTO)((RdmProjectUserService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/project/user"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody RdmProjectUserDTO inRdmProjectUserDTO) {
        int outputVo = ((RdmProjectUserService)this.getService()).deleteByPk((Object)inRdmProjectUserDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/project/user"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody RdmProjectUserDTO inRdmProjectUserDTO) {
        this.setUserInfoToVO(inRdmProjectUserDTO);
        String now = CurrentDateUtil.getTodayDateEx2();
        inRdmProjectUserDTO.setLastModifyTime(now);
        inRdmProjectUserDTO.setLastModifyUser(inRdmProjectUserDTO.getLoginUserId());
        int outputVo = ((RdmProjectUserService)this.getService()).updateByPk((Object)inRdmProjectUserDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/project/user"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertRdmProjectMember(@RequestBody RdmProjectUserDTO inRdmProjectUserDTO) {
        this.setUserInfoToVO(inRdmProjectUserDTO);
        String now = CurrentDateUtil.getTodayDateEx2();
        inRdmProjectUserDTO.setCreateTime(now);
        inRdmProjectUserDTO.setCreateUser(inRdmProjectUserDTO.getLoginUserId());
        inRdmProjectUserDTO.setLastModifyTime(now);
        inRdmProjectUserDTO.setLastModifyUser(inRdmProjectUserDTO.getLoginUserId());
        int outputVo = ((RdmProjectUserService)this.getService()).insert((Object)inRdmProjectUserDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/rdm/project/user/calc/workload"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<String> calcWorkload(@RequestParam(value="projectId") String projectId, @RequestParam(value="userId", required=false) String userId) {
        RdmProjectUserDTO inVo = new RdmProjectUserDTO();
        inVo.setProjectId(projectId);
        inVo.setUserId(userId);
        this.setUserInfoToVO(inVo);
        String outputVo = ((RdmProjectUserService)this.getService()).calcWorkload(inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/client/RdmProjectUserService/calcWorkload"}, method={RequestMethod.POST})
    @ResponseBody
    public String calcWorkload_client(@RequestBody RdmProjectUserDTO param) {
        return ((RdmProjectUserService)this.getService()).calcWorkload(param);
    }
}

