/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.sam.console.web.controller.api;

import com.irdstudio.allinrdm.sam.console.facade.ComBaseInfoService;
import com.irdstudio.allinrdm.sam.console.facade.dto.ComBaseInfoDTO;
import com.irdstudio.allinrdm.sam.console.types.ComSrcType;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class ComBaseInfoController
extends BaseController<ComBaseInfoDTO, ComBaseInfoService> {
    @RequestMapping(value={"/api/com/base/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<ComBaseInfoDTO>> queryComBaseInfoAll(ComBaseInfoDTO dto) {
        if (StringUtils.contains((CharSequence)dto.getComDomainId(), (CharSequence)",")) {
            dto.setComDomainIdList(Arrays.asList(StringUtils.split((String)dto.getComDomainId(), (String)",")));
            dto.setComDomainId(null);
        }
        if (StringUtils.contains((CharSequence)dto.getComGroupId(), (CharSequence)",")) {
            dto.setComGroupIdList(Arrays.asList(StringUtils.split((String)dto.getComGroupId(), (String)",")));
            dto.setComGroupId(null);
        }
        if (StringUtils.contains((CharSequence)dto.getSubsId(), (CharSequence)",")) {
            dto.setSubsIdList(Arrays.asList(StringUtils.split((String)dto.getSubsId(), (String)",")));
            dto.setSubsId(null);
        }
        List outputVo = ((ComBaseInfoService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/com/base/info/{subsId}/{comId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<ComBaseInfoDTO> queryByPk(@PathVariable(value="subsId") String subsId, @PathVariable(value="comId") String comId) {
        ComBaseInfoDTO inVo = new ComBaseInfoDTO();
        inVo.setComId(comId);
        inVo.setSubsId(subsId);
        ComBaseInfoDTO outputVo = (ComBaseInfoDTO)((ComBaseInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/com/base/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody ComBaseInfoDTO inComBaseInfoDTO) {
        int outputVo = ((ComBaseInfoService)this.getService()).deleteByPk((Object)inComBaseInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/com/base/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody ComBaseInfoDTO inComBaseInfoDTO) {
        this.setUserInfoToVO(inComBaseInfoDTO);
        inComBaseInfoDTO.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
        inComBaseInfoDTO.setLastModifyUser(inComBaseInfoDTO.getLoginUserId());
        int outputVo = ((ComBaseInfoService)this.getService()).updateByPk((Object)inComBaseInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/com/base/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertComBaseInfo(@RequestBody ComBaseInfoDTO inComBaseInfoDTO) {
        this.setUserInfoToVO(inComBaseInfoDTO);
        inComBaseInfoDTO.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        inComBaseInfoDTO.setCreateUser(inComBaseInfoDTO.getLoginUserId());
        inComBaseInfoDTO.setLastModifyTime(inComBaseInfoDTO.getCreateTime());
        inComBaseInfoDTO.setLastModifyUser(inComBaseInfoDTO.getLoginUserId());
        if (StringUtils.isBlank((CharSequence)inComBaseInfoDTO.getComId())) {
            inComBaseInfoDTO.setComId(UUIDUtil.getUUID());
        }
        if (StringUtils.isBlank((CharSequence)inComBaseInfoDTO.getComSrcType())) {
            inComBaseInfoDTO.setComSrcType(ComSrcType.Create.getCode());
        }
        int outputVo = ((ComBaseInfoService)this.getService()).insert((Object)inComBaseInfoDTO);
        return this.getResponseData(outputVo);
    }
}

