/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.sam.console.web.controller.api;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.listener.ReadListener;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinapaas.design.console.facade.SSubsInfoService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.SSubsInfoDTO;
import com.irdstudio.allinapaas.manager.console.facade.PaasDocTemplateService;
import com.irdstudio.allinapaas.manager.console.facade.dto.PaasDocTemplateDTO;
import com.irdstudio.allinrdm.dev.console.application.service.task.DocTemplateRepoPullQueueExecutor;
import com.irdstudio.allinrdm.project.console.facade.RdmProjectInfoService;
import com.irdstudio.allinrdm.project.console.facade.dto.RdmProjectInfoDTO;
import com.irdstudio.allinrdm.project.console.types.FnBaseRefType;
import com.irdstudio.allinrdm.sam.console.facade.FnBaseInfoService;
import com.irdstudio.allinrdm.sam.console.facade.dto.FnBaseInfoDTO;
import com.irdstudio.allinrdm.sam.console.types.FnBaseState;
import com.irdstudio.allinrdm.sam.console.types.FnCategory;
import com.irdstudio.allinrdm.sam.console.types.FpType;
import com.irdstudio.allinrdm.sam.console.types.WorkloadEvalType;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.excel.ExcelUtil;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/"})
public class FnBaseInfoController
extends BaseController<FnBaseInfoDTO, FnBaseInfoService> {
    @Autowired
    protected PaasDocTemplateService paasDocTemplateService;
    @Autowired
    protected SSubsInfoService sSubsInfoService;
    @Autowired
    protected PaasAppsInfoService paasAppsInfoService;
    @Autowired
    protected RdmProjectInfoService rdmProjectInfoService;

    @RequestMapping(value={"/api/fn/base/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<FnBaseInfoDTO>> queryFnBaseInfoAll(FnBaseInfoDTO dto) {
        List outputVo = ((FnBaseInfoService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/fn/base/info/{fpId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<FnBaseInfoDTO> queryByPk(@PathVariable(value="fpId") String fpId) {
        FnBaseInfoDTO inVo = new FnBaseInfoDTO();
        inVo.setFpId(fpId);
        FnBaseInfoDTO outputVo = (FnBaseInfoDTO)((FnBaseInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/fn/base/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody FnBaseInfoDTO inFnBaseInfoDTO) {
        int outputVo = ((FnBaseInfoService)this.getService()).deleteByPk((Object)inFnBaseInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/fn/base/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody FnBaseInfoDTO inFnBaseInfoDTO) {
        this.setUserInfoToVO(inFnBaseInfoDTO);
        String userId = this.getUserInfo().getUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        inFnBaseInfoDTO.setUpdateUser(userId);
        inFnBaseInfoDTO.setUpdateTime(now);
        int outputVo = ((FnBaseInfoService)this.getService()).updateByPk((Object)inFnBaseInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/fn/base/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertFnBaseInfo(@RequestBody FnBaseInfoDTO inFnBaseInfoDTO) {
        this.setUserInfoToVO(inFnBaseInfoDTO);
        String userId = this.getUserInfo().getUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        inFnBaseInfoDTO.setCreateUser(userId);
        inFnBaseInfoDTO.setCreateTime(now);
        inFnBaseInfoDTO.setUpdateUser(userId);
        inFnBaseInfoDTO.setUpdateTime(now);
        if (StringUtils.isBlank((CharSequence)inFnBaseInfoDTO.getFpId())) {
            inFnBaseInfoDTO.setFpId(UUIDUtil.getShortUUID());
        }
        int outputVo = ((FnBaseInfoService)this.getService()).insert((Object)inFnBaseInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/fn/base/info/id"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<String> queryMaxId() {
        String outputVo = ((FnBaseInfoService)this.getService()).queryMaxId();
        return this.getResponseData(outputVo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/api/fn/base/info/update/excel"})
    @ResponseBody
    public ResponseData<String> uploadUpdateExcel(@RequestParam(value="projectId", required=false) String projectId, @RequestParam(value="subsId", required=false) String subsId, @RequestParam(value="appId", required=false) String appId, @RequestParam(value="updateFields", required=false) String updateFields, @RequestParam(value="docTid") String docTid, @RequestPart(value="file") MultipartFile file) {
        ResponseData responseData;
        FileInputStream templateInput = null;
        try {
            PaasDocTemplateDTO template = new PaasDocTemplateDTO();
            template.setDocTid(docTid);
            template = (PaasDocTemplateDTO)this.paasDocTemplateService.queryByPk((Object)template);
            String docFile = template.getDocFile();
            DocTemplateRepoPullQueueExecutor.syncRun();
            String templateRootPath = DocTemplateRepoPullQueueExecutor.getDocTemplatePath();
            File templateFile = new File(templateRootPath + File.separator + docFile);
            String fileName = templateFile.getName();
            String pureFileName = fileName.substring(0, fileName.lastIndexOf("."));
            String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
            String importTemplateFileName = String.format("%s-import.%s", pureFileName, suffix);
            File downloadFile = new File(templateFile.getParentFile(), importTemplateFileName);
            templateInput = new FileInputStream(downloadFile);
            BufferedInputStream bufferedInput = new BufferedInputStream(file.getInputStream());
            ArrayList checkResult = new ArrayList();
            boolean validateFlag = ExcelUtil.validateExcel((InputStream)templateInput, (InputStream)bufferedInput, checkResult);
            if (!validateFlag) {
                ResponseData responseData2 = this.getResponseData(null, "", String.format("\u5217\u540d\u4e0d\u7b26\u5408: %s \u3002\u8bf7\u91cd\u65b0\u4e0a\u4f20\uff01", StringUtils.join(checkResult, (String)", ")));
                IOUtils.closeQuietly((InputStream)templateInput);
                return responseData2;
            }
            String now = CurrentDateUtil.getTodayDateEx2();
            String userId = this.getUserInfo().getUserId();
            String key = UUIDUtil.getShortUUID();
            AppResourceItemListener listener = new AppResourceItemListener();
            EasyExcel.read((InputStream)file.getInputStream(), CellItem.class, (ReadListener)listener).sheet(Integer.valueOf(0)).doRead();
            List<FnBaseInfoDTO> list = listener.getList();
            ArrayList updateList = new ArrayList();
            if (CollectionUtils.isNotEmpty(list)) {
                list.forEach(tmp -> {
                    FnBaseInfoDTO fnBase = new FnBaseInfoDTO();
                    fnBase.setProjectId(projectId);
                    fnBase.setAppId(subsId);
                    fnBase.setSubsId(subsId);
                    boolean hasUpdate = false;
                    if (StringUtils.contains((CharSequence)updateFields, (CharSequence)"fpName")) {
                        fnBase.setFpName(tmp.getFpName());
                        hasUpdate = true;
                    }
                    if (StringUtils.contains((CharSequence)updateFields, (CharSequence)"fpDesc")) {
                        fnBase.setFpDesc(tmp.getFpDesc());
                        hasUpdate = true;
                    }
                    if (StringUtils.contains((CharSequence)updateFields, (CharSequence)"refRoleControl")) {
                        fnBase.setRefRoleControl(tmp.getRefRoleControl());
                        hasUpdate = true;
                    }
                    if (StringUtils.contains((CharSequence)updateFields, (CharSequence)"refTable")) {
                        fnBase.setRefTable(tmp.getRefTable());
                        hasUpdate = true;
                    }
                    if (StringUtils.contains((CharSequence)updateFields, (CharSequence)"refFlow")) {
                        fnBase.setRefFlow(tmp.getRefFlow());
                        hasUpdate = true;
                    }
                    if (StringUtils.contains((CharSequence)updateFields, (CharSequence)"refOutsideInf")) {
                        fnBase.setRefOutsideInf(tmp.getRefOutsideInf());
                        hasUpdate = true;
                    }
                    if (StringUtils.contains((CharSequence)updateFields, (CharSequence)"refInnerInf")) {
                        fnBase.setRefInnerInf(tmp.getRefInnerInf());
                        hasUpdate = true;
                    }
                    if (StringUtils.contains((CharSequence)updateFields, (CharSequence)"refRiskIntercept")) {
                        fnBase.setRefRiskIntercept(tmp.getRefRiskIntercept());
                        hasUpdate = true;
                    }
                    if (StringUtils.contains((CharSequence)updateFields, (CharSequence)"designWorkload")) {
                        fnBase.setDesignWorkload(tmp.getDesignWorkload());
                        fnBase.setSumWorkload(tmp.getSumWorkload());
                        hasUpdate = true;
                    }
                    if (StringUtils.contains((CharSequence)updateFields, (CharSequence)"devWorkload")) {
                        fnBase.setDevWorkload(tmp.getDevWorkload());
                        fnBase.setSumWorkload(tmp.getSumWorkload());
                        hasUpdate = true;
                    }
                    if (StringUtils.contains((CharSequence)updateFields, (CharSequence)"testingWorkload")) {
                        fnBase.setTestingWorkload(tmp.getTestingWorkload());
                        fnBase.setSumWorkload(tmp.getSumWorkload());
                        hasUpdate = true;
                    }
                    if (StringUtils.contains((CharSequence)updateFields, (CharSequence)"deployWorkload")) {
                        fnBase.setDeployWorkload(tmp.getDeployWorkload());
                        fnBase.setSumWorkload(tmp.getSumWorkload());
                        hasUpdate = true;
                    }
                    if (StringUtils.contains((CharSequence)updateFields, (CharSequence)"designState")) {
                        fnBase.setDesignState(tmp.getDesignState());
                        hasUpdate = true;
                    }
                    if (StringUtils.contains((CharSequence)updateFields, (CharSequence)"devState")) {
                        fnBase.setDevState(tmp.getDevState());
                        hasUpdate = true;
                    }
                    if (StringUtils.contains((CharSequence)updateFields, (CharSequence)"testingState")) {
                        fnBase.setTestingState(tmp.getTestingState());
                        hasUpdate = true;
                    }
                    if (StringUtils.contains((CharSequence)updateFields, (CharSequence)"deployState")) {
                        fnBase.setDeployState(tmp.getDeployState());
                        hasUpdate = true;
                    }
                    if (StringUtils.contains((CharSequence)updateFields, (CharSequence)"remark")) {
                        fnBase.setRemark(tmp.getRemark());
                        hasUpdate = true;
                    }
                    if (hasUpdate) {
                        fnBase.setLoginUserId(userId);
                        fnBase.setFpId(tmp.getFpId());
                        updateList.add(fnBase);
                    }
                });
                ((FnBaseInfoService)this.getService()).updateExcel(userId, updateList);
            }
            responseData = this.getResponseData(key, "\u5bfc\u5165\u6210\u529f", "\u5bfc\u5165\u5931\u8d25");
            IOUtils.closeQuietly((InputStream)templateInput);
        }
        catch (Exception e) {
            logger.error("\u529f\u80fd\u70b9\u5bfc\u5165\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            ResponseData resp = this.getResponseData(null);
            resp.setMessage("\u5bfc\u5165\u5931\u8d25");
            ResponseData responseData3 = resp;
            return responseData3;
        }
        finally {
            IOUtils.closeQuietly(templateInput);
        }
        return responseData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/api/fn/base/info/excel"})
    @ResponseBody
    public ResponseData<String> uploadExcel(@RequestParam(value="projectId", required=false) String projectId, @RequestParam(value="subsId", required=false) String subsId, @RequestParam(value="appId", required=false) String appId, @RequestParam(value="fpCategory", required=false) String fpCategory, @RequestParam(value="fpType", required=false) String fpType, @RequestParam(value="excelUploadType") String excelUploadType, @RequestParam(value="docTid") String docTid, @RequestPart(value="file") MultipartFile file) {
        ResponseData responseData;
        FileInputStream templateInput = null;
        try {
            PaasDocTemplateDTO template = new PaasDocTemplateDTO();
            template.setDocTid(docTid);
            template = (PaasDocTemplateDTO)this.paasDocTemplateService.queryByPk((Object)template);
            String docFile = template.getDocFile();
            DocTemplateRepoPullQueueExecutor.syncRun();
            String templateRootPath = DocTemplateRepoPullQueueExecutor.getDocTemplatePath();
            File templateFile = new File(templateRootPath + File.separator + docFile);
            String fileName = templateFile.getName();
            String pureFileName = fileName.substring(0, fileName.lastIndexOf("."));
            String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
            String importTemplateFileName = String.format("%s-import.%s", pureFileName, suffix);
            File downloadFile = new File(templateFile.getParentFile(), importTemplateFileName);
            templateInput = new FileInputStream(downloadFile);
            BufferedInputStream bufferedInput = new BufferedInputStream(file.getInputStream());
            ArrayList checkResult = new ArrayList();
            boolean validateFlag = ExcelUtil.validateExcel((InputStream)templateInput, (InputStream)bufferedInput, checkResult);
            if (!validateFlag) {
                ResponseData responseData2 = this.getResponseData(null, "", String.format("\u5217\u540d\u4e0d\u7b26\u5408: %s \u3002\u8bf7\u91cd\u65b0\u4e0a\u4f20\uff01", StringUtils.join(checkResult, (String)", ")));
                IOUtils.closeQuietly((InputStream)templateInput);
                return responseData2;
            }
            String subsName = "";
            String projectName = "";
            String appName = "";
            if (StringUtils.isNotBlank((CharSequence)subsId)) {
                SSubsInfoDTO sSubsInfoDTO = new SSubsInfoDTO();
                sSubsInfoDTO.setSubsId(subsId);
                sSubsInfoDTO = (SSubsInfoDTO)this.sSubsInfoService.queryByPk((Object)sSubsInfoDTO);
                if (sSubsInfoDTO != null) {
                    subsName = sSubsInfoDTO.getSubsName();
                }
            }
            if (StringUtils.isNotBlank((CharSequence)projectId)) {
                RdmProjectInfoDTO rdmProjectInfoDTO = new RdmProjectInfoDTO();
                rdmProjectInfoDTO.setProjectId(projectId);
                rdmProjectInfoDTO = (RdmProjectInfoDTO)this.rdmProjectInfoService.queryByPk((Object)rdmProjectInfoDTO);
                if (rdmProjectInfoDTO != null) {
                    projectName = rdmProjectInfoDTO.getProjectName();
                }
            }
            if (StringUtils.isNotBlank((CharSequence)appId)) {
                PaasAppsInfoDTO appInfo = new PaasAppsInfoDTO();
                appInfo.setAppId(appId);
                appInfo = (PaasAppsInfoDTO)this.paasAppsInfoService.queryByPk((Object)appInfo);
                if (appInfo != null) {
                    appName = appInfo.getAppName();
                }
            }
            String userId = this.getUserInfo().getUserId();
            String key = UUIDUtil.getShortUUID();
            AppResourceItemListener listener = new AppResourceItemListener();
            EasyExcel.read((InputStream)file.getInputStream(), CellItem.class, (ReadListener)listener).sheet(Integer.valueOf(0)).doRead();
            List<FnBaseInfoDTO> list = listener.getList();
            if (CollectionUtils.isNotEmpty(list)) {
                list.forEach(tmp -> {
                    tmp.setSubsId(subsId);
                    tmp.setAppId(appId);
                    tmp.setProjectId(projectId);
                    if (StringUtils.isNotBlank((CharSequence)fpType) && StringUtils.isBlank((CharSequence)tmp.getFpType())) {
                        tmp.setFpType(fpType);
                    }
                });
                ((FnBaseInfoService)this.getService()).saveExcel(userId, subsId, subsName, projectId, projectName, appId, appName, fpCategory, excelUploadType, list);
            }
            responseData = this.getResponseData(key, "\u5bfc\u5165\u6210\u529f", "\u5bfc\u5165\u5931\u8d25");
            IOUtils.closeQuietly((InputStream)templateInput);
        }
        catch (Exception e) {
            logger.error("\u529f\u80fd\u70b9\u5bfc\u5165\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            ResponseData resp = this.getResponseData(null);
            resp.setMessage("\u5bfc\u5165\u5931\u8d25");
            ResponseData responseData3 = resp;
            return responseData3;
        }
        finally {
            IOUtils.closeQuietly(templateInput);
        }
        return responseData;
    }

    public static class CellItem {
        @ExcelProperty(value={"\u5e8f\u53f7"})
        private String seq;
        @ExcelProperty(value={"\u529f\u80fd\u70b9\u7f16\u53f7"})
        private String fpId;
        private String moduleId;
        @ExcelProperty(value={"\u6240\u5c5e\u6a21\u5757"})
        private String moduleName;
        @ExcelProperty(value={"\u529f\u80fd\u70b9\u7c7b\u522b"})
        private String fpCategory;
        @ExcelProperty(value={"\u529f\u80fd\u70b9\u7c7b\u578b"})
        private String fpType;
        @ExcelProperty(value={"\u529f\u80fd\u70b9\u540d\u79f0"})
        private String fpName;
        @ExcelProperty(value={"\u529f\u80fd\u70b9\u63cf\u8ff0"})
        private String fpDesc;
        @ExcelProperty(value={"\u662f\u5426\u5173\u8054\u6743\u9650\u63a7\u5236"})
        private String refRoleControl;
        @ExcelProperty(value={"\u662f\u5426\u5173\u8054\u6570\u636e\u8868"})
        private String refTable;
        @ExcelProperty(value={"\u662f\u5426\u5173\u8054\u6d41\u7a0b"})
        private String refFlow;
        @ExcelProperty(value={"\u662f\u5426\u5173\u8054\u5916\u90e8\u63a5\u53e3"})
        private String refOutsideInf;
        @ExcelProperty(value={"\u662f\u5426\u5173\u8054\u5185\u90e8\u63a5\u53e3"})
        private String refInnerInf;
        @ExcelProperty(value={"\u662f\u5426\u5173\u8054\u98ce\u9669\u62e6\u622a"})
        private String refRiskIntercept;
        @ExcelProperty(value={"\u8bbe\u8ba1\u5de5\u65f6"})
        private BigDecimal designWorkload;
        @ExcelProperty(value={"\u5f00\u53d1\u5de5\u65f6"})
        private BigDecimal devWorkload;
        @ExcelProperty(value={"\u6d4b\u8bd5\u5de5\u65f6"})
        private BigDecimal testingWorkload;
        @ExcelProperty(value={"\u53d1\u5e03\u5de5\u65f6"})
        private BigDecimal deployWorkload;
        @ExcelProperty(value={"\u8bc4\u4f30\u5de5\u65f6"})
        private BigDecimal sumWorkload;
        @ExcelProperty(value={"\u8bbe\u8ba1\u72b6\u6001"})
        private String designState;
        @ExcelProperty(value={"\u5f00\u53d1\u72b6\u6001"})
        private String devState;
        @ExcelProperty(value={"\u6d4b\u8bd5\u72b6\u6001"})
        private String testingState;
        @ExcelProperty(value={"\u53d1\u5e03\u72b6\u6001"})
        private String deployState;
        @ExcelProperty(value={"\u5907\u6ce8\u8bf4\u660e"})
        private String remark;

        public String getSeq() {
            return this.seq;
        }

        public void setSeq(String seq) {
            this.seq = seq;
        }

        public String getModuleId() {
            return this.moduleId;
        }

        public void setModuleId(String moduleId) {
            this.moduleId = moduleId;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public void setModuleName(String moduleName) {
            this.moduleName = moduleName;
        }

        public String getFpCategory() {
            return this.fpCategory;
        }

        public void setFpCategory(String fpCategory) {
            this.fpCategory = fpCategory;
        }

        public String getFpName() {
            return this.fpName;
        }

        public void setFpName(String fpName) {
            this.fpName = fpName;
        }

        public String getFpDesc() {
            return this.fpDesc;
        }

        public void setFpDesc(String fpDesc) {
            this.fpDesc = fpDesc;
        }

        public String getRefRoleControl() {
            return this.refRoleControl;
        }

        public void setRefRoleControl(String refRoleControl) {
            this.refRoleControl = refRoleControl;
        }

        public String getRefTable() {
            return this.refTable;
        }

        public void setRefTable(String refTable) {
            this.refTable = refTable;
        }

        public String getRefFlow() {
            return this.refFlow;
        }

        public void setRefFlow(String refFlow) {
            this.refFlow = refFlow;
        }

        public String getRefOutsideInf() {
            return this.refOutsideInf;
        }

        public void setRefOutsideInf(String refOutsideInf) {
            this.refOutsideInf = refOutsideInf;
        }

        public String getRefInnerInf() {
            return this.refInnerInf;
        }

        public void setRefInnerInf(String refInnerInf) {
            this.refInnerInf = refInnerInf;
        }

        public String getRefRiskIntercept() {
            return this.refRiskIntercept;
        }

        public void setRefRiskIntercept(String refRiskIntercept) {
            this.refRiskIntercept = refRiskIntercept;
        }

        public BigDecimal getDesignWorkload() {
            return this.designWorkload;
        }

        public void setDesignWorkload(BigDecimal designWorkload) {
            this.designWorkload = designWorkload;
        }

        public BigDecimal getDevWorkload() {
            return this.devWorkload;
        }

        public void setDevWorkload(BigDecimal devWorkload) {
            this.devWorkload = devWorkload;
        }

        public BigDecimal getTestingWorkload() {
            return this.testingWorkload;
        }

        public void setTestingWorkload(BigDecimal testingWorkload) {
            this.testingWorkload = testingWorkload;
        }

        public BigDecimal getDeployWorkload() {
            return this.deployWorkload;
        }

        public void setDeployWorkload(BigDecimal deployWorkload) {
            this.deployWorkload = deployWorkload;
        }

        public BigDecimal getSumWorkload() {
            return this.sumWorkload;
        }

        public void setSumWorkload(BigDecimal sumWorkload) {
            this.sumWorkload = sumWorkload;
        }

        public String getFpType() {
            return this.fpType;
        }

        public void setFpType(String fpType) {
            this.fpType = fpType;
        }

        public String getDesignState() {
            return this.designState;
        }

        public void setDesignState(String designState) {
            this.designState = designState;
        }

        public String getDevState() {
            return this.devState;
        }

        public void setDevState(String devState) {
            this.devState = devState;
        }

        public String getTestingState() {
            return this.testingState;
        }

        public void setTestingState(String testingState) {
            this.testingState = testingState;
        }

        public String getDeployState() {
            return this.deployState;
        }

        public void setDeployState(String deployState) {
            this.deployState = deployState;
        }

        public String getRemark() {
            return this.remark;
        }

        public void setRemark(String remark) {
            this.remark = remark;
        }

        public String getFpId() {
            return this.fpId;
        }

        public void setFpId(String fpId) {
            this.fpId = fpId;
        }
    }

    public static class AppResourceItemListener
    extends AnalysisEventListener<CellItem> {
        private List<FnBaseInfoDTO> list = new ArrayList<FnBaseInfoDTO>();

        public List<FnBaseInfoDTO> getList() {
            return this.list;
        }

        public void invoke(CellItem data, AnalysisContext context) {
            FnBaseInfoDTO vo = new FnBaseInfoDTO();
            BeanUtility.beanCopy((Object)data, (Object)vo);
            vo.setFpCategory(FnCategory.codeByName((String)data.getFpCategory()));
            vo.setFpType(FpType.codeByName((String)data.getFpType()));
            vo.setRefRoleControl(FnBaseRefType.codeByName((String)vo.getRefRoleControl()));
            vo.setRefTable(FnBaseRefType.codeByName((String)vo.getRefTable()));
            vo.setRefFlow(FnBaseRefType.codeByName((String)vo.getRefFlow()));
            vo.setRefOutsideInf(FnBaseRefType.codeByName((String)vo.getRefOutsideInf()));
            vo.setRefInnerInf(FnBaseRefType.codeByName((String)vo.getRefInnerInf()));
            vo.setRefRiskIntercept(FnBaseRefType.codeByName((String)vo.getRefRiskIntercept()));
            vo.setFpOrder(Integer.valueOf(NumberUtils.toInt((String)data.getSeq())));
            vo.setWorkloadEvalType(WorkloadEvalType.Manual.getCode());
            vo.setSumWorkload(this.sumWorkload(vo));
            vo.setDesignState(FnBaseState.codeByName((String)vo.getDesignState()));
            vo.setDevState(FnBaseState.codeByName((String)vo.getDevState()));
            vo.setTestingState(FnBaseState.codeByName((String)vo.getTestingState()));
            vo.setDeployState(FnBaseState.codeByName((String)vo.getDeployState()));
            this.list.add(vo);
        }

        private BigDecimal sumWorkload(FnBaseInfoDTO vo) {
            BigDecimal total = BigDecimal.ZERO;
            if (vo.getDesignWorkload() != null) {
                total = total.add(vo.getDesignWorkload());
            }
            if (vo.getDevWorkload() != null) {
                total = total.add(vo.getDevWorkload());
            }
            if (vo.getTestingWorkload() != null) {
                total = total.add(vo.getTestingWorkload());
            }
            if (vo.getDeployWorkload() != null) {
                total = total.add(vo.getDeployWorkload());
            }
            return total;
        }

        public void doAfterAllAnalysed(AnalysisContext context) {
        }
    }
}

