/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.wiki.console.web.controller.api;

import com.irdstudio.allinrdm.wiki.console.facade.WikiSubsDirectoryService;
import com.irdstudio.allinrdm.wiki.console.facade.WikiSubsPageService;
import com.irdstudio.allinrdm.wiki.console.facade.dto.WikiSubsDirectoryDTO;
import com.irdstudio.allinrdm.wiki.console.facade.dto.WikiSubsPageDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/client"})
public class WikiApiController
extends AbstractController {
    @Autowired
    @Qualifier(value="wikiSubsDirectoryServiceImpl")
    private WikiSubsDirectoryService wikiSubsDirectoryService;
    @Autowired
    @Qualifier(value="wikiSubsPageServiceImpl")
    private WikiSubsPageService wikiSubsPageService;

    @RequestMapping(value={"/wiki/subs/directory/save"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> saveSubsDirectors(@RequestParam(value="recovery") Boolean recovery, @RequestBody List<WikiSubsDirectoryDTO> dirList) {
        int outputVo = this.wikiSubsDirectoryService.saveSubsDirectors(dirList, recovery);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/wiki/subs/directory/view"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<WikiSubsDirectoryDTO>> queryWikiSubsDirectoryAndCheck(@RequestBody WikiSubsDirectoryDTO vo) {
        List outputVo = this.wikiSubsDirectoryService.queryWikiSubsDirectoryAndCheck(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/wiki/subs/page/batch"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> saveSubPage(@RequestBody WikiSubsPageDTO inWikiSubsPageDTO) {
        Object checkObj = new WikiSubsPageDTO();
        checkObj.setDocId(inWikiSubsPageDTO.getDocId());
        checkObj.setDocTitle(inWikiSubsPageDTO.getDocTitle());
        checkObj.setDirId(inWikiSubsPageDTO.getDirId());
        checkObj.setWikiId(inWikiSubsPageDTO.getWikiId());
        checkObj.setDocType(inWikiSubsPageDTO.getDocType());
        List checkList = this.wikiSubsPageService.queryListByPage(checkObj);
        checkObj = CollectionUtils.isNotEmpty((Collection)checkList) ? (WikiSubsPageDTO)checkList.get(0) : null;
        int outputVo = 0;
        if (checkObj != null) {
            inWikiSubsPageDTO.setDocId(checkObj.getDocId());
            inWikiSubsPageDTO.setCreateTime(CurrentDateUtil.getTodayDateEx2());
            inWikiSubsPageDTO.setCreateUser(inWikiSubsPageDTO.getLoginUserId());
            outputVo = this.wikiSubsPageService.updateByPk((Object)inWikiSubsPageDTO);
        } else {
            if (StringUtils.isBlank((CharSequence)inWikiSubsPageDTO.getDocId())) {
                inWikiSubsPageDTO.setDocId(UUIDUtil.getUUID());
            }
            inWikiSubsPageDTO.setCreateTime(CurrentDateUtil.getTodayDateEx2());
            inWikiSubsPageDTO.setCreateUser(inWikiSubsPageDTO.getLoginUserId());
            inWikiSubsPageDTO.setDocVersion("V1.0.0");
            outputVo = this.wikiSubsPageService.insert((Object)inWikiSubsPageDTO);
        }
        return this.getResponseData(outputVo);
    }
}

