/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintcp.admin.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allintcp.admin.facade.WxService;
import com.irdstudio.allintcp.admin.facade.dto.wx.WXBaseInfo;
import com.irdstudio.allintcp.admin.facade.dto.wx.WXGetPhoneNumber;
import com.irdstudio.allintcp.admin.facade.dto.wx.WXJscode2session;
import com.irdstudio.allintcp.admin.facade.dto.wx.WXSendSubscribe;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.converter.json.GsonHttpMessageConverter;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service(value="wxServiceImpl")
public class WxServiceImpl
implements WxService,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(WxService.class);
    @Value(value="${wx.app.id:}")
    private String AppId;
    @Value(value="${wx.app.secret:}")
    private String AppSecret;
    private static final String wxApiHost = "https://api.weixin.qq.com";
    @Autowired
    RestTemplate restTemplate;

    public WXJscode2session jscode2session(WXJscode2session input) {
        try {
            input.setAppid(this.AppId);
            input.setSecret(this.AppSecret);
            input.setGrant_type("authorization_code");
            WXJscode2session output = (WXJscode2session)this.restTemplate.getForObject("https://api.weixin.qq.com/sns/jscode2session?appid={appid}&secret={secret}&js_code={js_code}&grant_type={grant_type}", WXJscode2session.class, new Object[]{input.getAppid(), input.getSecret(), input.getJs_code(), input.getGrant_type()});
            return output;
        }
        catch (Exception e) {
            logger.error("\u5fae\u4fe1\u8c03\u7528\u767b\u5f55\u63a5\u53e3\u83b7\u53d6 openid\u5f02\u5e38 {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public WXGetPhoneNumber getPhoneNumber(WXGetPhoneNumber input) {
        try {
            WXBaseInfo accessToken = this.getAccessToken();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity entity = new HttpEntity((Object)JSON.toJSONString((Object)input), (MultiValueMap)headers);
            WXGetPhoneNumber output = (WXGetPhoneNumber)this.restTemplate.postForObject("https://api.weixin.qq.com/wxa/business/getuserphonenumber?access_token={access_token}", (Object)entity, WXGetPhoneNumber.class, new Object[]{accessToken.getAccess_token()});
            return output;
        }
        catch (Exception e) {
            logger.error("\u5fae\u4fe1\u8c03\u7528\u83b7\u53d6\u624b\u673a\u53f7\u63a5\u53e3\u83b7\u53d6\u5f02\u5e38 {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public String sendSubscribe(WXSendSubscribe input) {
        try {
            WXBaseInfo accessToken = this.getAccessToken();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity entity = new HttpEntity((Object)JSON.toJSONString((Object)input), (MultiValueMap)headers);
            String output = (String)this.restTemplate.postForObject("https://api.weixin.qq.com/cgi-bin/message/subscribe/send?access_token={access_token}", (Object)entity, String.class, new Object[]{accessToken.getAccess_token()});
            logger.info("\u53d1\u9001\u8ba2\u9605\u6d88\u606f\u63a5\u53e3\u8fd4\u56de {}", (Object)output);
            return output;
        }
        catch (Exception e) {
            logger.error("\u5fae\u4fe1\u8c03\u7528\u53d1\u9001\u8ba2\u9605\u6d88\u606f\u83b7\u53d6\u5f02\u5e38 {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public WXBaseInfo getAccessToken() {
        try {
            WXBaseInfo input = new WXBaseInfo();
            input.setAppid(this.AppId);
            input.setSecret(this.AppSecret);
            input.setGrant_type("client_credential");
            WXBaseInfo output = (WXBaseInfo)this.restTemplate.getForObject("https://api.weixin.qq.com/cgi-bin/token?grant_type={grant_type}&appid={appid}&secret={secret}", WXBaseInfo.class, new Object[]{input.getGrant_type(), input.getAppid(), input.getSecret()});
            return output;
        }
        catch (Exception e) {
            logger.error("\u5fae\u4fe1\u8c03\u7528\u83b7\u53d6\u624b\u673a\u53f7\u63a5\u53e3\u83b7\u53d6\u5f02\u5e38 {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.restTemplate != null) {
            this.restTemplate.getMessageConverters().add(new OwnGsonHttpMessageConverter());
        }
    }

    public static class OwnGsonHttpMessageConverter
    extends GsonHttpMessageConverter {
        public OwnGsonHttpMessageConverter() {
            this.setSupportedMediaTypes(Arrays.asList(MediaType.APPLICATION_JSON, new MediaType("application", "*+json"), MediaType.TEXT_PLAIN));
        }
    }
}

