(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _, loadjs) {


    // 资源定义 资源操作列表
    exports.SResourceactionList = {
        props: ['resourceid'],
        data(){
            return {
                dgUrl: '../../../../api/s/resourceactions' ,
                signUserId: signUserId,
                queryParams: {
                    resourceid: this.resourceid,
                },
                pageInfo:{
                    page: 1,
                    size: 10,
                    total: 0
                },
                all: '',
                allName: 'all',
                tableData: [],
                loading: false,
                currentRow: undefined,

                viewModel: "list", // 视图
                // 过滤条件
                showFilter: false,
                filterCond: [],
                groupItem: undefined,

            }
        },
        watch: {
            resourceid(val) {
                this.queryParams.resourceid = val
                this.queryList()
            },
        },
        methods: {
            formatterDic(dicName, value, row, index) {
                try {
                    return window[`formatter_${dicName}`](value, row, index);
                } catch(e) {
                    console.error(dicName, e)
                }
            },
            handlerTableCurrentChange(row) {
                this.currentRow = row;
                this.$emit('currentChange', this.currentRow)
            },
            resetQueryParams() {
                // 查询条件重置
                const self = this;
                self.all = '';
                self.allName = 'all';
                self.queryList();
            },
            queryParamsHandler(params){
                const self = this;
                params[self.allName] = self.all ;
                // 过滤条件
                if (this.filterCond && this.filterCond.length > 0) {
                    params.filterCond = JSON.stringify(this.filterCond)
                }
                return params
            },
            queryList() {
                const self = this;
                self.loading = true;
                let params = {
                    ...Vue.unref(self.pageInfo),
                    ...Vue.unref(self.queryParams)
                }
                self.queryParamsHandler(params)
                $.restfulPostForm(self.dgUrl, params, function(data){
                    self.pageInfo.total = data.total;
                    self.tableData = data.rows;
                    self.loading = false;
                }, function(){ self.loading = false; }, true);
            },
            doAdd(){
                ElementDialog.createDialog('新增', 'SResourceactionAdd.html?resourceid=' + this.resourceid).then(this.queryList);
            },
            doView(row) {
                const self = this
                ElementDialog.createDialog('查看','SResourceactionView.html?' + 'resourceid=' + row.resourceid + '&actid=' + row.actid);
            },
            doUpdate(row) {
                const self = this
                ElementDialog.createDialog('修改', 'SResourceactionUpdate.html?' + 'resourceid=' + row.resourceid + '&actid=' + row.actid).then(this.queryList);
            },
            doDelete(row) {
                const self = this
                if (row) {
                    const param = Vue.unref(row);
                    self.currentRow = param;
                    ElementPlus.ElMessageBox.confirm(
                        '你确定要删除这条记录?',
                        '提示',
                        {
                            confirmButtonText: '确定',
                            cancelButtonText: '取消',
                            type: 'warning',
                        }
                    ).then(() => {
                        $.restfulDelete('../../../../api/s/resourceaction', Vue.unref(row), function(data) {
                            if (data.success) {
                                ElementPlus.ElMessage({
                                    showClose: true,
                                    message: '删除成功',
                                    type: 'success',
                                })
                                self.queryList();
                            }
                            JLEUtil.closewin();
                        });
                    })
                }
            },
            handlerCommand(param) {
                const self = this;
                if (self[param.command]) {
                    self[param.command](param.row);
                }
            },
            allSearch(params) {
                this.allName = params && params.allName;
                this.all = params && params.all;
                this.queryList();
            },
            refreshCurrentCount() {
                this.$refs.searchRef.refreshCurrentCount();
            },
            changeView(item) {
                this.viewModel = item.value
                if (this.queryList) {
                    this.queryList()
                }
            },
            changeSort(item, initFlag) {
                const queryParams = this.queryParams || {}
                delete queryParams.ascOrder;
                delete queryParams.descOrder;
                if (item.type == 'desc') {
                    queryParams.descOrder = item.key
                } else {
                    queryParams.ascOrder = item.key
                }
                if (this.queryList && !initFlag) {
                    this.queryList()
                }
            }
        },
        provide() {
            return {
                DIC: this.DIC,
            }
        },
        computed: {
            DIC() {
                return {
                    SOLUTION_TYPE: window.SOLUTION_TYPE || [],

                }
            },
            breadcrumb() {
                if (tabTitle) {
                    return tabTitle.split('-');
                }
                return ['资源操作']
            },
            filterConfig() {
                return [
                    { key: 'actid', name: '操作ID', type: 'input', opType: '', opOption: window.FILTER_OP_TYPE.filter(el=>['lk'].indexOf(el.enname) >= 0),},
                    { key: 'descr', name: '描述', type: 'input', opType: '', opOption: window.FILTER_OP_TYPE.filter(el=>['lk'].indexOf(el.enname) >= 0),},
                ]
            },
            sortConfig() {
                return [
                    {label: '按操作ID顺序', key: 'actid', type: 'asc'},
                    {label: '按操作ID倒序', key: 'actid', type: 'desc'},
                ]
            },
            listView() {
                return this.viewModel == 'list'
            },
            dashboardView() {
                return this.viewModel == 'dashboard'
            },
        },
        mounted() {
            const self = this;
            self.queryList();
        },
        unmounted() {

        },
        template: `
        <el-col :span="24">
            <el-card class="box-card pure-theme" shadow="never">
                <template #header>
                    <page-header class="inner-title" breadcrumb="菜单资源操作" card-header>
                        <template #right>
                            <filter-button v-model="showFilter" :count="filterCond.length"></filter-button>
                            <sort-dropdown @sort="changeSort" :sort-item="sortConfig"></sort-dropdown>
                            <el-button class="button" icon="Refresh" text size="small" @click="queryList"></el-button>
                        </template>
                    </page-header>
                </template>
                <el-row>
                    <el-col :span="24">
                        <page-search ref="searchRef"
                                     v-model="queryParams.searchKey"
                                     :dg-url="dgUrl"
                                     :query-params="queryParams"
                                     enable-search
                                     :all-items="[]"
                                     @all-search="allSearch"
                        >
                            <template #more>
                                <el-form class="card-form" ref="formRef" :show-message="false" label-width="133px" label-position="left">
                                    <filter-condition v-model="filterCond" :visible="showFilter" :config="filterConfig" @close="showFilter = false" @filter="queryList" ></filter-condition>
                                    <el-row v-if="groupItem">
                                        <el-col :span="24">
                                            <group-item :item="groupItem" @cancel="groupItem = undefined"></group-item>
                                        </el-col>
                                    </el-row>
                                </el-form>
                            </template>
                            <template #tool>
                                <el-button text icon="Plus" @click="doAdd">新增</el-button>
                            </template>
                        </page-search>
                        <template v-if="listView">
                            <el-table :data="tableData"
                                      v-loading="loading"
                                      stripe border
                                      highlight-current-row
                                      @current-change="handlerTableCurrentChange"
                                      tooltip-effect="light"
                                      :tooltip-options="{placement : 'bottom'}"
                                      style="width: 100%" >
                                <el-table-column type="index" width="45" ></el-table-column>
                                <el-table-column resizable prop="actid" label="操作ID" width="200" show-overflow-tooltip>
                                    <template #default="{row, $index}">
                                        <el-link type="primary" :underline="false" @click="doView(row)">{{row.actid}}</el-link>
                                    </template>
                                </el-table-column>
                                <el-table-column resizable prop="resourceid" label="资源ID" width="200" show-overflow-tooltip></el-table-column>
                                <el-table-column resizable prop="descr" label="描述" min-width="200" show-overflow-tooltip></el-table-column>
                                <el-table-column resizable prop="orgid" label="机构号"  width="200" show-overflow-tooltip></el-table-column>
                                <el-table-column label="操作" fixed="right" width="180" header-align="center">
                                    <template #default="{row, $index}">
                                        <el-button class="button" text type="default" @click="doUpdate(row)"><el-icon><Edit ></Edit></el-icon>修改</el-button>
                                        <el-button class="button" text type="default" @click="doDelete(row)"><el-icon><Delete ></Delete></el-icon>删除</el-button>
                                    </template>
                                </el-table-column>
                            </el-table>
                            <page-table-pagination :page-info="pageInfo" :load-method="queryList"></page-table-pagination>
                        </template>
                    </el-col>
                </el-row>
            </el-card>

        </el-col>
        `
    }

}));