/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintcp.sdk.admin.web.ssm.util;

import com.irdstudio.allintcp.sdk.admin.facade.operation.dto.SResourceDTO;
import com.irdstudio.framework.beans.core.vo.ZTreeVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class TreeNodeUtil {
    public static ArrayList<ZTreeVO> getTree(List<ZTreeVO> list, String subsId) {
        ArrayList<ZTreeVO> tree = new ArrayList<ZTreeVO>();
        for (ZTreeVO treeNode : list) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)subsId, (CharSequence)treeNode.getParentId())) continue;
            treeNode.setChildren(TreeNodeUtil.getChildrenNode(treeNode.getId(), list));
            treeNode.setState("open");
            tree.add(treeNode);
        }
        return tree;
    }

    public static ArrayList<ZTreeVO> getChildrenNode(String pid, List<ZTreeVO> list) {
        ArrayList<ZTreeVO> childrenNode = new ArrayList<ZTreeVO>();
        for (ZTreeVO treeNode : list) {
            if (!pid.equals(treeNode.getParentId())) continue;
            treeNode.setChildren(TreeNodeUtil.getChildrenNode(treeNode.getId(), list));
            if (CollectionUtils.isNotEmpty((Collection)treeNode.getChildren())) {
                treeNode.setState("closed");
            }
            childrenNode.add(treeNode);
        }
        return childrenNode;
    }

    public static ArrayList<ZTreeVO> getSResourceTree(List<SResourceDTO> resourceVOList, String subsId) {
        ArrayList<ZTreeVO> sResourceTrees = new ArrayList<ZTreeVO>();
        for (SResourceDTO sResourceVO : resourceVOList) {
            ZTreeVO sResourceTree = new ZTreeVO();
            sResourceTree.setId(sResourceVO.getResourceid());
            sResourceTree.setText(sResourceVO.getCnname());
            sResourceTree.setParentId(sResourceVO.getParentid());
            sResourceTree.setUrl(sResourceVO.getUrl());
            sResourceTree.setIconCls(sResourceVO.getIcon());
            sResourceTree.setDefaultPage(sResourceVO.getDefaultPage());
            sResourceTrees.add(sResourceTree);
        }
        return TreeNodeUtil.getTree(sResourceTrees, subsId);
    }

    public static List<ZTreeVO> getSResourceRightTree(List<ZTreeVO> list) {
        ArrayList<ZTreeVO> sResourceRightTrees = new ArrayList<ZTreeVO>();
        for (ZTreeVO sResourceRightVO : list) {
            ZTreeVO sResourceRightTree = new ZTreeVO();
            sResourceRightTree.setId(sResourceRightVO.getId());
            sResourceRightTree.setText(sResourceRightVO.getText());
            sResourceRightTree.setParentId(sResourceRightVO.getParentId());
            sResourceRightTree.setChecked(sResourceRightVO.getChecked());
            sResourceRightTree.setIsBase(sResourceRightVO.getIsBase());
            sResourceRightTrees.add(sResourceRightTree);
        }
        ArrayList<ZTreeVO> tree = new ArrayList<ZTreeVO>();
        for (ZTreeVO treeNode : sResourceRightTrees) {
            if (!"root".equals(treeNode.getParentId().toLowerCase())) continue;
            treeNode.setChildren(TreeNodeUtil.getSResourceRightChildren(treeNode.getId(), sResourceRightTrees));
            if (!treeNode.getChildren().isEmpty()) {
                treeNode.setChecked(null);
            }
            tree.add(treeNode);
        }
        return tree;
    }

    public static ArrayList<ZTreeVO> getSResourceRightChildren(String pid, List<ZTreeVO> list) {
        ArrayList<ZTreeVO> childrenNode = new ArrayList<ZTreeVO>();
        for (ZTreeVO treeNode : list) {
            if (!pid.equals(treeNode.getParentId())) continue;
            treeNode.setChildren(TreeNodeUtil.getSResourceRightChildren(treeNode.getId(), list));
            if (!treeNode.getChildren().isEmpty()) {
                treeNode.setChecked(null);
                treeNode.setState("closed");
            }
            childrenNode.add(treeNode);
        }
        return childrenNode;
    }
}

