/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintcp.sdk.query.manual.application.operation;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allintcp.sdk.query.facade.operation.QryModelInfoService;
import com.irdstudio.allintcp.sdk.query.manual.application.operation.QueryServiceImpl;
import com.irdstudio.allintcp.sdk.query.manual.facade.operation.dto.QryTableConfigDTO;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class AutoLoadQueryDataServiceImpl
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(AutoLoadQueryDataServiceImpl.class);
    @Autowired
    protected QryModelInfoService qryModelInfoService;

    public void afterPropertiesSet() {
        try {
            Resource[] jsonResources;
            PathMatchingResourcePatternResolver pathMatchingResourcePatternResolver = new PathMatchingResourcePatternResolver();
            for (Resource json : jsonResources = pathMatchingResourcePatternResolver.getResources("classpath*:META-INF/query/*.json")) {
                try {
                    String jsonString = IOUtils.toString((InputStream)json.getInputStream(), (String)"UTF-8");
                    QryTableConfigDTO data = (QryTableConfigDTO)JSON.parseObject((String)jsonString, QryTableConfigDTO.class);
                    if (data == null || data.getQryInfo() == null) continue;
                    QueryServiceImpl.queryConfigMap.put(data.getQryInfo().getQryId(), data);
                    try {
                        this.qryModelInfoService.insert((Object)data.getQryInfo());
                    }
                    catch (Exception e) {
                        this.qryModelInfoService.updateByPk(data.getQryInfo());
                    }
                }
                catch (Exception e) {
                    logger.error("\u67e5\u8be2\u6570\u636e\u5f02\u5e38{}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u5f02\u5e38{}", (Object)e.getMessage(), (Object)e);
        }
    }
}

