/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintcp.sdk.report.manual.application.operation;

import com.irdstudio.allintcp.sdk.report.acl.repository.RptFolderInfoRepository;
import com.irdstudio.allintcp.sdk.report.acl.repository.RptModelInfoRepository;
import com.irdstudio.allintcp.sdk.report.domain.entity.RptFolderInfoDO;
import com.irdstudio.allintcp.sdk.report.domain.entity.RptModelInfoDO;
import com.irdstudio.allintcp.sdk.report.facade.operation.dto.RptFolderInfoDTO;
import com.irdstudio.allintcp.sdk.report.manual.facade.operation.RptFolderInfoManualService;
import com.irdstudio.framework.beans.core.base.BaseServiceImpl;
import com.irdstudio.framework.beans.core.util.CurrentDateUtil;
import com.irdstudio.framework.beans.core.vo.BaseInfo;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="RptFolderInfoManualServiceImpl")
public class RptFolderInfoManualServiceImpl
extends BaseServiceImpl<RptFolderInfoDTO, RptFolderInfoDO, RptFolderInfoRepository>
implements RptFolderInfoManualService {
    @Autowired
    protected RptModelInfoRepository rptModelInfoRepository;

    public int folderMerge(RptFolderInfoDTO paramDTO, String type) {
        if (StringUtils.isBlank((String)paramDTO.getFolderId()) || StringUtils.isBlank((String)paramDTO.getFolderAbvId())) {
            return -1;
        }
        String srcPackageId = paramDTO.getFolderId();
        String targetFolderId = paramDTO.getFolderAbvId();
        RptFolderInfoDTO srcPackageParam = new RptFolderInfoDTO();
        srcPackageParam.setFolderAbvId(srcPackageId);
        List subPackageList = this.queryList((BaseInfo)srcPackageParam);
        if (CollectionUtils.isNotEmpty((Collection)subPackageList)) {
            for (RptFolderInfoDTO sub : subPackageList) {
                sub.setFolderAbvId(targetFolderId);
                this.updateByPk((BaseInfo)sub);
            }
        }
        RptModelInfoDO rptModelParam = new RptModelInfoDO();
        rptModelParam.setFolderId(srcPackageId);
        List rptList = this.rptModelInfoRepository.queryList((Object)rptModelParam);
        if (CollectionUtils.isNotEmpty((Collection)rptList)) {
            for (RptModelInfoDO model : rptList) {
                model.setFolderId(targetFolderId);
                model.setLastUpdateUser(paramDTO.getLoginUserId());
                model.setLastUpdateTime(CurrentDateUtil.getTodayDateEx2());
                this.rptModelInfoRepository.updateByPk((Object)model);
            }
        }
        if (StringUtils.equals((String)type, (String)"merge")) {
            RptFolderInfoDTO deleteSrc = new RptFolderInfoDTO();
            deleteSrc.setFolderId(srcPackageId);
            this.deleteByPk((BaseInfo)deleteSrc);
        }
        return 0;
    }

    public int folderMove(RptFolderInfoDTO paramDTO) {
        if (StringUtils.isBlank((String)paramDTO.getFolderId()) || StringUtils.isBlank((String)paramDTO.getFolderAbvId())) {
            return -1;
        }
        String srcPackageId = paramDTO.getFolderId();
        String targetFolderId = paramDTO.getFolderAbvId();
        RptFolderInfoDO child = new RptFolderInfoDO();
        child.setFolderId(srcPackageId);
        child = (RptFolderInfoDO)((RptFolderInfoRepository)this.getRepository()).queryByPk((Object)child);
        if (child != null) {
            child.setFolderAbvId(targetFolderId);
            return ((RptFolderInfoRepository)this.getRepository()).updateByPk((Object)child);
        }
        return -1;
    }
}

