/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintcp.sdk.filesrv.web.operation;

import com.irdstudio.allintcp.sdk.filesrv.facade.operation.SeqInstInfoService;
import com.irdstudio.allintcp.sdk.filesrv.facade.operation.dto.SeqInstInfoDTO;
import com.irdstudio.framework.beans.core.util.CurrentDateUtil;
import com.irdstudio.framework.beans.core.util.UUIDUtil;
import com.irdstudio.framework.beans.core.vo.ResponseData;
import com.irdstudio.framework.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class SeqInstInfoController
extends BaseController<SeqInstInfoDTO, SeqInstInfoService> {
    @RequestMapping(value={"/api/seq/inst/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SeqInstInfoDTO>> querySeqInstInfoAll(SeqInstInfoDTO dto) {
        List outputVo = ((SeqInstInfoService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/seq/inst/info/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<SeqInstInfoDTO> queryByPk(@PathVariable(value="id") String id) {
        SeqInstInfoDTO inVo = new SeqInstInfoDTO();
        inVo.setId(id);
        SeqInstInfoDTO outputVo = (SeqInstInfoDTO)((SeqInstInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/seq/inst/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody SeqInstInfoDTO inSeqInstInfoDTO) {
        int outputVo = ((SeqInstInfoService)this.getService()).deleteByPk((Object)inSeqInstInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/seq/inst/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody SeqInstInfoDTO inSeqInstInfoDTO) {
        this.setUserInfoToVO(inSeqInstInfoDTO);
        String userId = this.getUserInfo().getUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        inSeqInstInfoDTO.setLastModifyUser(userId);
        inSeqInstInfoDTO.setLastModifyTime(now);
        int outputVo = ((SeqInstInfoService)this.getService()).updateByPk((Object)inSeqInstInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/seq/inst/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertSeqInstInfo(@RequestBody SeqInstInfoDTO inSeqInstInfoDTO) {
        this.setUserInfoToVO(inSeqInstInfoDTO);
        String userId = this.getUserInfo().getUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        inSeqInstInfoDTO.setCreateUser(userId);
        inSeqInstInfoDTO.setCreateTime(now);
        inSeqInstInfoDTO.setLastModifyUser(userId);
        inSeqInstInfoDTO.setLastModifyTime(now);
        if (StringUtils.isBlank((CharSequence)inSeqInstInfoDTO.getId())) {
            inSeqInstInfoDTO.setId(UUIDUtil.getShortUUID());
        }
        int outputVo = ((SeqInstInfoService)this.getService()).insert((Object)inSeqInstInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/sequence/id"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<String> nextSequence(@RequestParam(value="seqId") String seqId, @RequestParam(value="owner", required=false) String owner) {
        String seq = ((SeqInstInfoService)this.getService()).nextSequence(seqId, owner);
        return this.getResponseData(seq);
    }

    @RequestMapping(value={"/client/SeqInstInfoService/nextSequence"}, method={RequestMethod.POST})
    @ResponseBody
    public String nextSequence_client(@RequestParam(value="seqId") String seqId, @RequestParam(value="owner", required=false) String owner) {
        return ((SeqInstInfoService)this.getService()).nextSequence(seqId, owner);
    }

    @RequestMapping(value={"/client/SeqInstInfoService/reloadSeqInst"}, method={RequestMethod.GET})
    @ResponseBody
    public String reloadSeqInst() {
        return ((SeqInstInfoService)this.getService()).reloadSeqInst();
    }
}

