/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintcp.sdk.schedule.application.operation;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allintcp.sdk.schedule.acl.repository.SSrvsCronConfRepository;
import com.irdstudio.allintcp.sdk.schedule.application.schedule.QuartzJobEngine;
import com.irdstudio.allintcp.sdk.schedule.application.schedule.QuartzManager;
import com.irdstudio.allintcp.sdk.schedule.application.schedule.ScheduleJobUtil;
import com.irdstudio.allintcp.sdk.schedule.application.schedule.dao.SAgentInfoDao;
import com.irdstudio.allintcp.sdk.schedule.application.schedule.dao.domain.SAgentInfo;
import com.irdstudio.allintcp.sdk.schedule.domain.entity.SSrvsCronConfDO;
import com.irdstudio.allintcp.sdk.schedule.facade.operation.SSrvsCronConfService;
import com.irdstudio.allintcp.sdk.schedule.facade.operation.dto.SSrvsCronConfDTO;
import com.irdstudio.framework.beans.core.base.BaseServiceImpl;
import com.irdstudio.framework.beans.core.vo.BaseInfo;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.impl.StdSchedulerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="SSrvsCronConfServiceImpl")
public class SSrvsCronConfServiceImpl
extends BaseServiceImpl<SSrvsCronConfDTO, SSrvsCronConfDO, SSrvsCronConfRepository>
implements SSrvsCronConfService {
    @Autowired
    private DataSource dataSource;
    private HttpClient httpClient = HttpClients.createDefault();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startTask(SSrvsCronConfDTO sSrvsCronConfVO) {
        if (StringUtils.isBlank((CharSequence)(sSrvsCronConfVO = (SSrvsCronConfDTO)this.queryByPk((BaseInfo)sSrvsCronConfVO)).getAgentId())) {
            StdSchedulerFactory gSchedulerFactory = new StdSchedulerFactory();
            try {
                SSrvsCronConfDO sSrvsCronConf = new SSrvsCronConfDO();
                sSrvsCronConfVO.setJobState("A");
                this.beanCopy(sSrvsCronConfVO, sSrvsCronConf);
                ((SSrvsCronConfRepository)this.getRepository()).updateByPk((Object)sSrvsCronConf);
                Scheduler sched = gSchedulerFactory.getScheduler();
                sched.triggerJob(JobKey.jobKey((String)sSrvsCronConfVO.getJobCode(), (String)ScheduleJobUtil.JOB_GROUP_NAME));
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            SAgentInfoDao sAgentInfoDao = new SAgentInfoDao(conn);
            SAgentInfo agentInfo = sAgentInfoDao.queryAgentInfoById(sSrvsCronConfVO.getAgentId());
            if (agentInfo != null) {
                Map<String, Object> response = this.actionAgentInvoke(agentInfo.getAgentUrl(), sSrvsCronConfVO.getJobCode());
                boolean bl = response != null;
                return bl;
            }
            boolean response = false;
            return response;
        }
        catch (Exception e) {
            logger.error("\u4f7f\u7528agentId \u6267\u884c\u5931\u8d25\uff0c \u7ee7\u7eed\u4f7f\u7528\u672c\u5730\u8c03\u5ea6\u6267\u884c  {}", (Object)e.getMessage(), (Object)e);
            StdSchedulerFactory gSchedulerFactory = new StdSchedulerFactory();
            try {
                SSrvsCronConfDO sSrvsCronConf = new SSrvsCronConfDO();
                sSrvsCronConfVO.setJobState("A");
                this.beanCopy(sSrvsCronConfVO, sSrvsCronConf);
                ((SSrvsCronConfRepository)this.getRepository()).updateByPk((Object)sSrvsCronConf);
                Scheduler sched = gSchedulerFactory.getScheduler();
                sched.triggerJob(JobKey.jobKey((String)sSrvsCronConfVO.getJobCode(), (String)ScheduleJobUtil.JOB_GROUP_NAME));
                boolean bl = true;
                return bl;
            }
            catch (Exception le) {
                le.printStackTrace();
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public Map<String, Object> actionAgentInvoke(String agentUrl, String jobCode) {
        HttpGet getMethod = new HttpGet(String.format("%s/cron/start?jobCode=%s", agentUrl, jobCode));
        HttpResponse response = null;
        try {
            response = this.httpClient.execute((HttpUriRequest)getMethod);
            String json = EntityUtils.toString((HttpEntity)response.getEntity());
            Map output = (Map)JSON.parseObject((String)json, Map.class);
            return output;
        }
        catch (Exception e) {
            logger.error("\u5b9a\u65f6\u8c03\u5ea6\u4efb\u52a1\u624b\u5de5\u8c03\u7528\u6267\u884c\u5931\u8d25 {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public boolean doDisable(SSrvsCronConfDTO sSrvsCronConfVO) {
        String jobCode = sSrvsCronConfVO.getJobCode();
        try {
            QuartzManager.removeJob(jobCode, ScheduleJobUtil.JOB_GROUP_NAME, ScheduleJobUtil.TRIGGER_NAME + "-" + jobCode, ScheduleJobUtil.TRIGGER_GROUP_NAME);
            SSrvsCronConfDO sSrvsCronConf = new SSrvsCronConfDO();
            sSrvsCronConfVO.setJobState("F");
            this.beanCopy(sSrvsCronConfVO, sSrvsCronConf);
            ((SSrvsCronConfRepository)this.getRepository()).updateByPk((Object)sSrvsCronConf);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean doInitial(SSrvsCronConfDTO sSrvsCronConfVO) {
        String subcode = sSrvsCronConfVO.getJobCode();
        try {
            QuartzManager.addJob(subcode, ScheduleJobUtil.JOB_GROUP_NAME, ScheduleJobUtil.TRIGGER_NAME + "-" + subcode, ScheduleJobUtil.TRIGGER_GROUP_NAME, QuartzJobEngine.class, sSrvsCronConfVO.getCronExpression());
            SSrvsCronConfDO sSrvsCronConf = new SSrvsCronConfDO();
            sSrvsCronConfVO.setJobState("S");
            this.beanCopy(sSrvsCronConfVO, sSrvsCronConf);
            ((SSrvsCronConfRepository)this.getRepository()).updateByPk((Object)sSrvsCronConf);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

