/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintpaas.sdk.admin.autoconfigure.auth;

import com.irdstudio.allintpaas.sdk.admin.autoconfigure.cas.E4ACasFilter;
import com.irdstudio.allintpaas.sdk.admin.web.ssm.session.SessionManager;
import com.irdstudio.allintpaas.sdk.admin.web.ssm.web.filter.E4AFilter;
import com.irdstudio.framework.beans.core.vo.ResponseData;
import com.irdstudio.framework.beans.core.vo.UserInfo;
import com.irdstudio.framework.beans.web.controller.AbstractController;
import javax.servlet.Filter;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.client.boot.configuration.CasClientConfiguration;
import org.jasig.cas.client.boot.configuration.CasClientConfigurer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Configuration
@ConditionalOnProperty(value={"e4a.integer.type"})
public class E4AConfiguration {

    @RestController
    @RequestMapping(value={"/client"})
    public static class IntegerTypeConfigController
    extends AbstractController {
        @Value(value="${e4a.integer.type:L}")
        private String e4aIntegerType;
        @Value(value="${cas.server-url-prefix:}")
        private String casServerUrl;
        @Value(value="${e4a.logo.url:}")
        private String logoUrl;

        @RequestMapping(value={"/e4a/integer/type"}, method={RequestMethod.GET})
        @ResponseBody
        public ResponseData<String> getConfig() {
            if (StringUtils.equals((CharSequence)this.e4aIntegerType, (CharSequence)"L")) {
                return this.getResponseData(this.e4aIntegerType);
            }
            if (StringUtils.indexOf((CharSequence)this.casServerUrl, (CharSequence)"allincloud.irdstudio.com") >= 0) {
                return this.getResponseData("Allincloud");
            }
            if (StringUtils.indexOf((CharSequence)this.casServerUrl, (CharSequence)"demo.irdstudio.com") >= 0) {
                return this.getResponseData("Allinsaas");
            }
            return this.getResponseData(this.e4aIntegerType);
        }

        @RequestMapping(value={"/e4a/cas/url"}, method={RequestMethod.GET})
        @ResponseBody
        public ResponseData<String> getCasUrl() {
            return this.getResponseData(this.casServerUrl);
        }

        @RequestMapping(value={"/e4a/logo/url"}, method={RequestMethod.GET})
        @ResponseBody
        public ResponseData<String> getLogoUrl() {
            return this.getResponseData(this.logoUrl);
        }
    }

    @Configuration(value="EnableLocalConfiguration")
    @ConditionalOnExpression(value="'${e4a.integer.type}'=='L'")
    public static class EnableLocalConfiguration {
        @Value(value="${e4a.sessionTimeOut:3600000}")
        private int sessionTimeOut;
        @Value(value="${e4a.allowUrl:/**/*}")
        private String allowUrl;
        @Value(value="${e4a.fail.redirect:false}")
        private String failRedirect;

        @Bean
        @ConditionalOnExpression(value="'${e4a.integer.type}'=='L'")
        public SessionManager sessionManager() {
            SessionManager sessionManager = new SessionManager();
            sessionManager.setSessionTimeOut(this.sessionTimeOut);
            return sessionManager;
        }

        public Filter e4aFilter() {
            E4AFilter e4AFilter = new E4AFilter();
            return e4AFilter;
        }

        @Bean
        @ConditionalOnExpression(value="'${e4a.integer.type}'=='L'")
        public FilterRegistrationBean e4aFilterReg() {
            FilterRegistrationBean reg = new FilterRegistrationBean();
            reg.setFilter(this.e4aFilter());
            reg.addInitParameter("allowUrl", this.allowUrl);
            reg.addInitParameter("failRedirect", this.failRedirect);
            reg.addUrlPatterns(new String[]{"/*"});
            reg.setName("e4aFilter");
            reg.setOrder(2);
            return reg;
        }

        @ConditionalOnExpression(value="'${e4a.integer.type}'=='L'")
        @RestController
        @RequestMapping(value={"/api"})
        public static class UserInfoController
        extends AbstractController {
            @RequestMapping(value={"/s/user/info"}, method={RequestMethod.GET})
            @ResponseBody
            public ResponseData<UserInfo> getSessionUserInfo() {
                ResponseData data = null;
                try {
                    UserInfo userInfo = this.getUserInfo();
                    data = this.getResponseData(userInfo);
                }
                catch (Exception e) {
                    logger.error("\u83b7\u53d6session\u767b\u5f55\u4fe1\u606f\u5931\u8d25" + e.getMessage(), (Throwable)e);
                    this.httpResponse.setStatus(401);
                }
                return data;
            }
        }
    }

    @Configuration(value="EnableUnitConfiguration")
    @ConditionalOnExpression(value="'${e4a.integer.type}'=='U'")
    public static class EnableUnitConfiguration {
        @Value(value="${e4a.sessionTimeOut:3600000}")
        private int sessionTimeOut;
        @Value(value="${cas.server-url-prefix:}")
        private String casServerUrl;

        @Bean
        @ConditionalOnExpression(value="'${e4a.integer.type}'=='U'")
        public SessionManager sessionManager() {
            SessionManager sessionManager = new SessionManager();
            sessionManager.setSessionTimeOut(this.sessionTimeOut);
            return sessionManager;
        }

        public Filter e4aCasFilter() {
            E4ACasFilter e4AFilter = new E4ACasFilter();
            return e4AFilter;
        }

        @Bean
        @ConditionalOnExpression(value="'${e4a.integer.type}'=='U'")
        public FilterRegistrationBean e4aCasFilterReg() {
            FilterRegistrationBean reg = new FilterRegistrationBean();
            reg.setFilter(this.e4aCasFilter());
            reg.addInitParameter("casServerUrl", this.casServerUrl);
            reg.addUrlPatterns(new String[]{"/*"});
            reg.setName("e4aFilter");
            reg.setOrder(2);
            return reg;
        }

        @ConditionalOnExpression(value="'${e4a.integer.type}'=='U'")
        @RestController
        @RequestMapping(value={"/api"})
        public static class UserInfoController
        extends AbstractController {
            @RequestMapping(value={"/s/user/info"}, method={RequestMethod.GET})
            @ResponseBody
            public ResponseData<UserInfo> getSessionUserInfo() {
                ResponseData data = null;
                try {
                    UserInfo userInfo = this.getUserInfo();
                    data = this.getResponseData(userInfo);
                }
                catch (Exception e) {
                    logger.error("\u83b7\u53d6session\u767b\u5f55\u4fe1\u606f\u5931\u8d25" + e.getMessage(), (Throwable)e);
                    this.httpResponse.setStatus(401);
                }
                return data;
            }
        }
    }

    @Configuration(value="EnableCas")
    @ConditionalOnExpression(value="'${e4a.integer.type}'=='U'")
    @Import(value={CasClientConfiguration.class})
    public static class EnableCas
    implements CasClientConfigurer {
        @Value(value="${e4a.allowUrl:/**/*}")
        private String allowUrl;
        @Value(value="${e4a.ignore-url-pattern-type:com.irdstudio.allintpaas.sdk.admin.autoconfigure.cas.AntPathMatcherStrategy}")
        private String ignoreUrlPatternType;

        public void configureAuthenticationFilter(FilterRegistrationBean authenticationFilter) {
            authenticationFilter.getInitParameters().put("ignoreUrlPatternType", this.ignoreUrlPatternType);
            authenticationFilter.getInitParameters().put("ignorePattern", this.allowUrl);
        }
    }
}

